package de.is24.util.monitoring.tools;

public class KeyHelper {
  /**
  * Concatenates elements to form a dotted name, eliding any null values or empty strings.
  *
  * @param name     the first element of the name
  * @param names    the remaining elements of the name
  * @return {@code name} and {@code names} concatenated by periods
  */
  public static String name(String name, String... names) {
    final StringBuilder builder = new StringBuilder();
    append(builder, name);
    if (names != null) {
      for (String s : names) {
        append(builder, s);
      }
    }
    return builder.toString();
  }

  /**
   * Concatenates a class name and elements to form a dotted name, eliding any null values or
   * empty strings.
   *
   * @param klass    the first element of the name
   * @param names    the remaining elements of the name
   * @return {@code klass} and {@code names} concatenated by periods
   */
  public static String name(Class<?> klass, String... names) {
    return name(klass.getName(), names);
  }

  private static void append(StringBuilder builder, String part) {
    if ((part != null) && !part.isEmpty()) {
      if (builder.length() > 0) {
        builder.append('.');
      }
      builder.append(part);
    }
  }

}
