/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.keyhandler;

import de.is24.util.monitoring.tools.LocalHostNameResolver;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyDefinitionExpander {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyDefinitionExpander.class);

    public static String preparePrefix(String appName, LocalHostNameResolver localHostNameResolver) {
        KeyProcessor[] keyProcessors = new KeyProcessor[]{new SystemPropertyNamePartKeyProcessor(), new SystemPropertyValueKeyProcessor(), new HostNameKeyProcessor(localHostNameResolver)};
        String result = appName;
        for (KeyProcessor processor : keyProcessors) {
            result = processor.process(result);
        }
        if (result.equals(appName)) {
            result = appName + "." + localHostNameResolver.getLocalHostName() + ".states";
        }
        return result;
    }

    private static class HostNameKeyProcessor
    implements KeyProcessor {
        private LocalHostNameResolver localHostNameResolver;

        public HostNameKeyProcessor(LocalHostNameResolver localHostNameResolver) {
            this.localHostNameResolver = localHostNameResolver;
        }

        @Override
        public String process(String input) {
            if (input.contains("${hostname}")) {
                return input.replaceAll("\\$\\{hostname\\}", this.localHostNameResolver.getLocalHostName());
            }
            return input;
        }
    }

    private static class SystemPropertyValueKeyProcessor
    implements KeyProcessor {
        private Pattern systemPropertyNamePattern = Pattern.compile("\\$\\{systemProperty:([^}]*)\\}");

        private SystemPropertyValueKeyProcessor() {
        }

        @Override
        public String process(String input) {
            StringBuffer buffer = new StringBuffer();
            Matcher matcher = this.systemPropertyNamePattern.matcher(input);
            while (matcher.find()) {
                String propertyName = matcher.group(1);
                String value = System.getProperty(propertyName);
                if (value == null) {
                    String message = "could not find System property " + propertyName;
                    LOGGER.warn(message);
                    throw new RuntimeException(message);
                }
                matcher.appendReplacement(buffer, value);
            }
            matcher.appendTail(buffer);
            return buffer.toString();
        }
    }

    private static class SystemPropertyNamePartKeyProcessor
    implements KeyProcessor {
        private Pattern systemPropertyNamePattern = Pattern.compile("\\$\\{systemPropertyName:([^}]*)\\}");

        private SystemPropertyNamePartKeyProcessor() {
        }

        @Override
        public String process(String input) {
            StringBuffer buffer = new StringBuffer();
            Matcher matcher = this.systemPropertyNamePattern.matcher(input);
            while (matcher.find()) {
                String namePattern = matcher.group(1);
                Pattern pattern = Pattern.compile(namePattern);
                boolean matched = false;
                Enumeration<?> e = System.getProperties().propertyNames();
                while (!matched && e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    Matcher entryMatcher = pattern.matcher(name);
                    if (!entryMatcher.matches()) continue;
                    matched = true;
                    matcher.appendReplacement(buffer, entryMatcher.group(1));
                }
                if (matched) continue;
                throw new RuntimeException("could not find a System property matching name " + namePattern);
            }
            matcher.appendTail(buffer);
            return buffer.toString();
        }
    }

    private static interface KeyProcessor {
        public String process(String var1);
    }
}

