/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.keyhandler;

import de.is24.util.monitoring.InApplicationMonitor;
import de.is24.util.monitoring.keyhandler.KeyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingReportingKeyHandler
implements KeyHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatingReportingKeyHandler.class);
    private final KeyHandler delegate;

    public DelegatingReportingKeyHandler(KeyHandler delegate) {
        this.delegate = delegate;
    }

    @Override
    public String handle(String name) {
        String result = this.delegate.handle(name);
        if (!result.equals(name)) {
            InApplicationMonitor.getInstance().incrementCounter("malformedKey");
            LOGGER.info("corrected Key value from {} to {}", (Object)name, (Object)result);
        }
        return result;
    }
}

