/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.jmx;

import de.is24.util.monitoring.Counter;
import de.is24.util.monitoring.HistorizableList;
import de.is24.util.monitoring.Reportable;
import de.is24.util.monitoring.StateValueProvider;
import de.is24.util.monitoring.Timer;
import de.is24.util.monitoring.Version;
import de.is24.util.monitoring.jmx.CounterJmxReportable;
import de.is24.util.monitoring.jmx.HistorizableListJmxReportable;
import de.is24.util.monitoring.jmx.JmxReportable;
import de.is24.util.monitoring.jmx.NoJmxReportable;
import de.is24.util.monitoring.jmx.StateValueProviderJmxReportable;
import de.is24.util.monitoring.jmx.TimerJmxReportable;
import de.is24.util.monitoring.jmx.VersionJmxReportable;
import java.text.SimpleDateFormat;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InApplicationMonitorDynamicMBean
implements DynamicMBean {
    static final Logger LOGGER = LoggerFactory.getLogger(InApplicationMonitorDynamicMBean.class);
    static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private final JmxReportable type;

    public InApplicationMonitorDynamicMBean(Reportable reportable) {
        assert (reportable != null);
        if (reportable instanceof Timer) {
            this.type = new TimerJmxReportable((Timer)reportable);
        } else if (reportable instanceof Counter) {
            this.type = new CounterJmxReportable((Counter)reportable);
        } else if (reportable instanceof Version) {
            this.type = new VersionJmxReportable((Version)reportable);
        } else if (reportable instanceof StateValueProvider) {
            this.type = new StateValueProviderJmxReportable((StateValueProvider)reportable);
        } else if (reportable instanceof HistorizableList) {
            this.type = new HistorizableListJmxReportable((HistorizableList)reportable);
        } else {
            LOGGER.warn("Unknown reportable: {} of type {}", (Object)reportable.getName(), (Object)reportable.getClass().getName());
            this.type = NoJmxReportable.getInstance();
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo beanInfo = new MBeanInfo("de.is24.util.monitoring.InApplicationMonitorDynamicMBeanThing", "InApplication Monitor dynamic MBean", this.type.getAttributes(), null, null, null);
        return beanInfo;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.getAttributeInternal(attribute);
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList result = new AttributeList();
        for (String attributeName : attributes) {
            result.add(new Attribute(attributeName, this.getAttributeInternal(attributeName)));
        }
        return result;
    }

    private Object getAttributeInternal(String attribute) {
        Object result = this.type.getAttribute(attribute);
        return result;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return null;
    }
}

