/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.database;

import de.is24.util.monitoring.InApplicationMonitor;
import de.is24.util.monitoring.StateValueProvider;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringDataSource
implements DataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitoringDataSource.class);
    private final DataSource original;
    private final String monitorBaseName;
    private final AtomicInteger maxConnections;
    private final AtomicInteger currentConnections;
    final Set<Predicate<SQLException>> loggingFilters = new HashSet<Predicate<SQLException>>();

    public MonitoringDataSource(DataSource dataSource, String monitorBaseName) {
        if (dataSource == null) {
            throw new IllegalArgumentException("DataSource is null");
        }
        this.original = dataSource;
        this.monitorBaseName = MonitoringDataSource.class.getName() + (StringUtils.isBlank((String)monitorBaseName) ? "" : "." + monitorBaseName);
        this.currentConnections = new AtomicInteger(0);
        this.maxConnections = new AtomicInteger(0);
        InApplicationMonitor.getInstance().registerStateValue(new StateValueProvider(){

            @Override
            public String getName() {
                return MonitoringDataSource.this.monitorBaseName + ".maxOpenConnections";
            }

            @Override
            public long getValue() {
                return MonitoringDataSource.this.maxConnections.get();
            }
        });
        InApplicationMonitor.getInstance().initializeCounter(this.monitorBaseName + ".error.getConnection");
        InApplicationMonitor.getInstance().initializeCounter(this.monitorBaseName + ".error.commit");
        InApplicationMonitor.getInstance().initializeCounter(this.monitorBaseName + ".getPersonalisedConnection");
        InApplicationMonitor.getInstance().initializeCounter(this.monitorBaseName + ".error.rollback");
        InApplicationMonitor.getInstance().initializeCounter(this.monitorBaseName + ".error.rollbackSavepoint");
    }

    public MonitoringDataSource(DataSource dataSource) {
        this(dataSource, null);
    }

    public void addExceptionLogFilter(Predicate<SQLException> predicate) {
        this.loggingFilters.add(predicate);
    }

    public void setExceptionLogFilters(String configuration) {
        this.loggingFilters.clear();
        if (StringUtils.isEmpty((String)configuration)) {
            return;
        }
        this.configureSqlExceptionPredicates(configuration);
    }

    private void configureSqlExceptionPredicates(String configuration) {
        for (String configEntry : configuration.split("[,]")) {
            String[] configEntryItems = configEntry.split("[:]");
            if (configEntryItems.length > 2) {
                throw new IllegalArgumentException("The config entry [" + configEntry + "] contains more than one ':' and thus is invalid!");
            }
            int errorCode = Integer.parseInt(configEntryItems[0]);
            String regex = configEntryItems.length > 1 ? configEntryItems[1] : null;
            this.loggingFilters.add(new SqlExceptionPredicate(errorCode, regex));
        }
    }

    private void doConnectionMonitoring(long startingInstant, String monitorSuffix) {
        InApplicationMonitor.getInstance().addTimerMeasurement(this.monitorBaseName + monitorSuffix, System.currentTimeMillis() - startingInstant);
        int noCurrentConnections = this.currentConnections.incrementAndGet();
        if (noCurrentConnections > this.maxConnections.get()) {
            this.maxConnections.set(noCurrentConnections);
        }
    }

    private void monitorFailedConnectionAttempt() {
        InApplicationMonitor.getInstance().incrementCounter(this.monitorBaseName + ".error.getConnection");
    }

    private Connection getConnection(Callable<Connection> callable, String monitorSuffix) throws SQLException {
        long now = System.currentTimeMillis();
        try {
            MonitoringConnection c = new MonitoringConnection(callable.call());
            this.doConnectionMonitoring(now, monitorSuffix);
            return c;
        }
        catch (Error e) {
            this.monitorFailedConnectionAttempt();
            throw e;
        }
        catch (RuntimeException rE) {
            this.monitorFailedConnectionAttempt();
            throw rE;
        }
        catch (SQLException sqlE) {
            this.monitorFailedConnectionAttempt();
            throw sqlE;
        }
        catch (Exception e) {
            this.monitorFailedConnectionAttempt();
            LOGGER.error("Unexpected Exception thrown by Callable; please check source code of de.is24.common.database.MonitoringDataSource: " + e);
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.monitorBaseName.substring(MonitoringDataSource.class.getName().lastIndexOf(46) + 1) + " wrapping [" + this.original + "]";
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(new Callable<Connection>(){

            @Override
            public Connection call() throws SQLException {
                return MonitoringDataSource.this.original.getConnection();
            }
        }, ".getConnection");
    }

    @Override
    public Connection getConnection(final String username, final String password) throws SQLException {
        return this.getConnection(new Callable<Connection>(){

            @Override
            public Connection call() throws SQLException {
                return MonitoringDataSource.this.original.getConnection(username, password);
            }
        }, ".getPersonalisedConnection");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.original.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.original.getLoginTimeout();
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.original.getParentLogger();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.original.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.original.setLoginTimeout(seconds);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.original.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.original.unwrap(iface);
    }

    protected static interface Predicate<T> {
        public boolean apply(T var1);

        public boolean equals(Object var1);
    }

    static class SqlExceptionPredicate
    implements Predicate<SQLException> {
        private final int errorCode;
        private final String messagePattern;

        public SqlExceptionPredicate(int errorCode, String messagePattern) {
            this.errorCode = errorCode;
            this.messagePattern = messagePattern;
        }

        @Override
        public boolean apply(SQLException input) {
            if (this.errorCode != input.getErrorCode()) {
                return false;
            }
            if (this.messagePattern == null) {
                return true;
            }
            return input.getMessage() != null && input.getMessage().matches(this.messagePattern);
        }
    }

    private static class SqlLoggingInvocationHandler
    implements InvocationHandler {
        private final Object wrappedObject;
        private final String preparedSql;
        final Set<Predicate<SQLException>> loggingFilters;

        public SqlLoggingInvocationHandler(Set<Predicate<SQLException>> loggingFilters, Object wrappedObject, String preparedSql) {
            this.loggingFilters = loggingFilters;
            this.wrappedObject = wrappedObject;
            this.preparedSql = preparedSql;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
            try {
                return method.invoke(this.wrappedObject, arguments);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Cannot execute wrapped call [" + method.getName() + "()@" + proxy + "]", e);
            }
            catch (InvocationTargetException iTE) {
                this.logExecutedSqlIfApplicable(method, arguments, iTE);
                throw iTE.getTargetException();
            }
        }

        private void logExecutedSqlIfApplicable(Method method, Object[] arguments, InvocationTargetException iTE) {
            if (!this.anExecuteMethodIsCalled(method)) {
                return;
            }
            String sql = this.determineExecutedSql(arguments);
            if (sql == null) {
                return;
            }
            this.logExecutedSqlAtTheAppropriateLevel(iTE, sql);
        }

        private boolean anExecuteMethodIsCalled(Method method) {
            return method.getName().startsWith("execute");
        }

        private String determineExecutedSql(Object[] arguments) {
            String sql = this.preparedSql;
            if (arguments != null && arguments[0] instanceof String) {
                sql = (String)arguments[0];
            }
            return sql;
        }

        private void logExecutedSqlAtTheAppropriateLevel(InvocationTargetException iTE, String sql) {
            if (this.shouldLogAsWarn(iTE)) {
                LOGGER.warn("Failed to execute [{}]: {}", (Object)sql, (Object)iTE.getTargetException());
            } else {
                LOGGER.info("Failed to execute [[{}]: {}", (Object)sql, (Object)iTE.getTargetException());
            }
        }

        private boolean shouldLogAsWarn(InvocationTargetException iTE) {
            boolean logAsWarn = true;
            int index = ExceptionUtils.indexOfType((Throwable)iTE, SQLException.class);
            if (index >= 0) {
                SQLException sqlException = (SQLException)ExceptionUtils.getThrowables((Throwable)iTE)[index];
                for (Predicate<SQLException> predicate : this.loggingFilters) {
                    if (!predicate.apply(sqlException)) continue;
                    logAsWarn = false;
                    break;
                }
            }
            return logAsWarn;
        }
    }

    private class MonitoringConnection
    implements Connection {
        private final Connection original;
        private final long creationTime = System.currentTimeMillis();

        public MonitoringConnection(Connection connection) {
            if (connection == null) {
                throw new NullPointerException("The Connection cannot be null!");
            }
            this.original = connection;
        }

        private Object wrapStatementWithSqlLoggingProxy(Statement statement, String sql) {
            Class<?> clazz = statement.getClass();
            Object proxiedStatement = Proxy.newProxyInstance(clazz.getClassLoader(), clazz.getInterfaces(), (InvocationHandler)new SqlLoggingInvocationHandler(MonitoringDataSource.this.loggingFilters, statement, sql));
            return proxiedStatement;
        }

        private Object wrapStatementWithSqlLoggingProxy(Statement statement) {
            return this.wrapStatementWithSqlLoggingProxy(statement, null);
        }

        public String toString() {
            return "MonitoringConnection from " + MonitoringDataSource.this.monitorBaseName.substring(MonitoringDataSource.class.getName().lastIndexOf(46) + 1) + " wrapping [" + this.original + "]";
        }

        @Override
        public void close() throws SQLException {
            try {
                this.original.close();
            }
            finally {
                MonitoringDataSource.this.currentConnections.decrementAndGet();
                InApplicationMonitor.getInstance().incrementCounter(MonitoringDataSource.this.monitorBaseName + ".close");
                InApplicationMonitor.getInstance().addTimerMeasurement(MonitoringDataSource.this.monitorBaseName + ".usage", this.creationTime, System.currentTimeMillis());
            }
        }

        @Override
        public void commit() throws SQLException {
            try {
                this.original.commit();
            }
            catch (SQLException sqlE) {
                InApplicationMonitor.getInstance().incrementCounter(MonitoringDataSource.this.monitorBaseName + ".error.commit");
                throw sqlE;
            }
        }

        @Override
        public void rollback() throws SQLException {
            try {
                this.original.rollback();
            }
            catch (SQLException sqlE) {
                InApplicationMonitor.getInstance().incrementCounter(MonitoringDataSource.this.monitorBaseName + ".error.rollback");
                throw sqlE;
            }
        }

        @Override
        public void rollback(Savepoint savepoint) throws SQLException {
            try {
                this.original.rollback(savepoint);
            }
            catch (SQLException sqlE) {
                InApplicationMonitor.getInstance().incrementCounter(MonitoringDataSource.this.monitorBaseName + ".error.rollbackSavepoint");
                throw sqlE;
            }
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.original.clearWarnings();
        }

        @Override
        public Statement createStatement() throws SQLException {
            return (Statement)this.wrapStatementWithSqlLoggingProxy(this.original.createStatement());
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return (Statement)this.wrapStatementWithSqlLoggingProxy(this.original.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            return (Statement)this.wrapStatementWithSqlLoggingProxy(this.original.createStatement(resultSetType, resultSetConcurrency));
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            return this.original.getAutoCommit();
        }

        @Override
        public String getCatalog() throws SQLException {
            return this.original.getCatalog();
        }

        @Override
        public int getHoldability() throws SQLException {
            return this.original.getHoldability();
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            return this.original.getMetaData();
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            return this.original.getTransactionIsolation();
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            return this.original.getTypeMap();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.original.getWarnings();
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.original.isClosed();
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            return this.original.isReadOnly();
        }

        @Override
        public String nativeSQL(String sql) throws SQLException {
            return this.original.nativeSQL(sql);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return (CallableStatement)this.wrapStatementWithSqlLoggingProxy(this.original.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return (CallableStatement)this.wrapStatementWithSqlLoggingProxy(this.original.prepareCall(sql, resultSetType, resultSetConcurrency), sql);
        }

        @Override
        public CallableStatement prepareCall(String sql) throws SQLException {
            return (CallableStatement)this.wrapStatementWithSqlLoggingProxy(this.original.prepareCall(sql), sql);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return (PreparedStatement)this.wrapStatementWithSqlLoggingProxy(this.original.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return (PreparedStatement)this.wrapStatementWithSqlLoggingProxy(this.original.prepareStatement(sql, resultSetType, resultSetConcurrency), sql);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            return (PreparedStatement)this.wrapStatementWithSqlLoggingProxy(this.original.prepareStatement(sql, autoGeneratedKeys), sql);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
            return (PreparedStatement)this.wrapStatementWithSqlLoggingProxy(this.original.prepareStatement(sql, columnIndexes), sql);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            return (PreparedStatement)this.wrapStatementWithSqlLoggingProxy(this.original.prepareStatement(sql, columnNames), sql);
        }

        @Override
        public PreparedStatement prepareStatement(String sql) throws SQLException {
            return (PreparedStatement)this.wrapStatementWithSqlLoggingProxy(this.original.prepareStatement(sql), sql);
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.original.releaseSavepoint(savepoint);
        }

        @Override
        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this.original.setAutoCommit(autoCommit);
        }

        @Override
        public void setCatalog(String catalog) throws SQLException {
            this.original.setCatalog(catalog);
        }

        @Override
        public void setHoldability(int holdability) throws SQLException {
            this.original.setHoldability(holdability);
        }

        @Override
        public void setReadOnly(boolean readOnly) throws SQLException {
            this.original.setReadOnly(readOnly);
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            return this.original.setSavepoint();
        }

        @Override
        public Savepoint setSavepoint(String name) throws SQLException {
            return this.original.setSavepoint(name);
        }

        @Override
        public void setTransactionIsolation(int level) throws SQLException {
            this.original.setTransactionIsolation(level);
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
            this.original.setTypeMap(map);
        }

        @Override
        public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
            return this.original.createArrayOf(typeName, elements);
        }

        @Override
        public Blob createBlob() throws SQLException {
            return this.original.createBlob();
        }

        @Override
        public Clob createClob() throws SQLException {
            return this.original.createClob();
        }

        @Override
        public NClob createNClob() throws SQLException {
            return this.original.createNClob();
        }

        @Override
        public SQLXML createSQLXML() throws SQLException {
            return this.original.createSQLXML();
        }

        @Override
        public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
            return this.original.createStruct(typeName, attributes);
        }

        @Override
        public void setSchema(String schema) throws SQLException {
            this.original.setSchema(schema);
        }

        @Override
        public String getSchema() throws SQLException {
            return this.original.getSchema();
        }

        @Override
        public void abort(Executor executor) throws SQLException {
            this.original.abort(executor);
        }

        @Override
        public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
            this.original.setNetworkTimeout(executor, milliseconds);
        }

        @Override
        public int getNetworkTimeout() throws SQLException {
            return this.original.getNetworkTimeout();
        }

        @Override
        public Properties getClientInfo() throws SQLException {
            return this.original.getClientInfo();
        }

        @Override
        public String getClientInfo(String name) throws SQLException {
            return this.original.getClientInfo(name);
        }

        @Override
        public boolean isValid(int timeout) throws SQLException {
            return this.original.isValid(timeout);
        }

        @Override
        public void setClientInfo(Properties properties) throws SQLClientInfoException {
            this.original.setClientInfo(properties);
        }

        @Override
        public void setClientInfo(String name, String value) throws SQLClientInfoException {
            this.original.setClientInfo(name, value);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.original.isWrapperFor(iface);
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.original.unwrap(iface);
        }
    }
}

