/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.statsd;

import de.is24.util.monitoring.statsd.StatsdDatagrammSocket;
import de.is24.util.monitoring.statsd.StatsdHostGroupedMessageFormatter;
import de.is24.util.monitoring.statsd.StatsdMessageFormatter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StatsdClient {
    private static final Logger LOG = LoggerFactory.getLogger((String)StatsdClient.class.getName());
    static Random rng = new Random();
    private final StatsdDatagrammSocket socket;
    private final StatsdMessageFormatter messageFormatter;

    public StatsdClient(String host, int port, String appName) throws UnknownHostException, SocketException {
        this(host, port, new StatsdHostGroupedMessageFormatter(appName));
    }

    public StatsdClient(String host, int port, StatsdMessageFormatter messageFormatter) throws UnknownHostException, SocketException {
        this(new StatsdDatagrammSocket(InetAddress.getByName(host), port), messageFormatter);
    }

    StatsdClient(StatsdDatagrammSocket socket, StatsdMessageFormatter formatter) {
        this.socket = socket;
        this.messageFormatter = formatter;
        LOG.info("StatsdClient connected to {} initialized", (Object)socket.toString());
    }

    public void close() {
        LOG.info("closing StatsdClient connected to {}", (Object)this.socket.toString());
        this.socket.close();
    }

    public boolean timing(String key, int value) {
        return this.timing(key, value, 1.0);
    }

    public boolean timing(String key, int value, double sampleRate) {
        return this.send(sampleRate, this.formatTimer(key, value));
    }

    private String formatTimer(String key, int value) {
        return key + ":" + value + "|ms";
    }

    public boolean decrement(String key) {
        return this.increment(key, -1, 1.0);
    }

    public boolean decrement(String key, int magnitude) {
        return this.decrement(key, magnitude, 1.0);
    }

    public boolean decrement(String key, int magnitude, double sampleRate) {
        magnitude = magnitude < 0 ? magnitude : -magnitude;
        return this.increment(key, magnitude, sampleRate);
    }

    public boolean decrement(String ... keys) {
        return this.increment(-1, 1.0, keys);
    }

    public boolean decrement(int magnitude, String ... keys) {
        magnitude = magnitude < 0 ? magnitude : -magnitude;
        return this.increment(magnitude, 1.0, keys);
    }

    public boolean decrement(int magnitude, double sampleRate, String ... keys) {
        magnitude = magnitude < 0 ? magnitude : -magnitude;
        return this.increment(magnitude, sampleRate, keys);
    }

    public boolean increment(String key) {
        return this.increment(key, 1, 1.0);
    }

    public boolean increment(String key, int magnitude) {
        return this.increment(key, magnitude, 1.0);
    }

    public boolean increment(String key, int magnitude, double sampleRate) {
        String stat = this.formatCounter(key, magnitude);
        return this.send(stat, sampleRate);
    }

    private String formatCounter(String key, int magnitude) {
        return key + ":" + magnitude + "|c";
    }

    public boolean increment(int magnitude, double sampleRate, String ... keys) {
        String[] stats = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            stats[i] = this.formatCounter(keys[i], magnitude);
        }
        return this.send(sampleRate, stats);
    }

    private boolean send(String stat, double sampleRate) {
        return this.send(sampleRate, stat);
    }

    private boolean send(double sampleRate, String ... stats) {
        boolean retval = false;
        if (sampleRate < 1.0) {
            for (String stat : stats) {
                String key;
                if (!(rng.nextDouble() <= sampleRate) || !this.doSend(key = this.messageFormatter.formatSampledValue(stat, sampleRate))) continue;
                retval = true;
            }
        } else {
            for (String stat : stats) {
                String key = this.messageFormatter.formatUnsampledValue(stat);
                if (!this.doSend(key)) continue;
                retval = true;
            }
        }
        return retval;
    }

    private boolean doSend(String stat) {
        try {
            this.socket.send(stat);
            return true;
        }
        catch (IOException e) {
            LOG.error("Could not send stat " + stat + " to host " + this.socket, (Throwable)e);
            return false;
        }
    }
}

