/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring;

import de.is24.util.monitoring.ReportVisitor;
import de.is24.util.monitoring.Reportable;
import de.is24.util.monitoring.ReportableObserver;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

class Monitors<T extends Reportable> {
    private final ConcurrentHashMap<String, T> monitors = new ConcurrentHashMap();
    private final List<ReportableObserver> reportableObservers;

    public Monitors(List<ReportableObserver> reportableObservers) {
        this.reportableObservers = reportableObservers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(String key, Factory<T> factory) {
        Object result = this.get(key);
        if (result == null) {
            ConcurrentHashMap<String, T> concurrentHashMap = this.monitors;
            synchronized (concurrentHashMap) {
                result = this.get(key);
                if (result == null) {
                    result = (Reportable)factory.createMonitor();
                    this.put(key, result);
                    this.notifyReportableObservers((Reportable)result);
                }
            }
        }
        return result;
    }

    public T get(String key) {
        return (T)((Reportable)this.monitors.get(key));
    }

    public T put(String key, T reportable) {
        return (T)((Reportable)this.monitors.put(key, reportable));
    }

    public void putIfAbsent(String key, T reportable) {
        this.monitors.putIfAbsent(key, reportable);
        this.notifyReportableObservers((Reportable)reportable);
    }

    private void notifyReportableObservers(Reportable reportable) {
        for (ReportableObserver reportableObserver : this.reportableObservers) {
            reportableObserver.addNewReportable(reportable);
        }
    }

    public void accept(ReportVisitor reportVisitor) {
        for (Reportable reportable : this.getMonitors()) {
            reportable.accept(reportVisitor);
        }
    }

    public Collection<T> getMonitors() {
        return this.monitors.values();
    }

    public static interface Factory<T> {
        public T createMonitor();
    }
}

