/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.visitors;

import de.is24.util.monitoring.HistorizableList;
import de.is24.util.monitoring.MultiValueProvider;
import de.is24.util.monitoring.StateValueProvider;
import de.is24.util.monitoring.Version;
import de.is24.util.monitoring.visitors.AbstractSortedReportVisitor;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

public class ValueOrderedReportVisitor
extends AbstractSortedReportVisitor {
    protected Set<AbstractSortedReportVisitor.CounterEntry> counterSet = new TreeSet<AbstractSortedReportVisitor.CounterEntry>(new CounterComparator());
    protected Set<AbstractSortedReportVisitor.TimerEntry> timerSet = new TreeSet<AbstractSortedReportVisitor.TimerEntry>(new TimerComparator());

    @Override
    public void reportHistorizableList(HistorizableList aHistorizableList) {
    }

    @Override
    public void reportVersion(Version aVersion) {
    }

    @Override
    public void reportStateValue(StateValueProvider stateValueProvider) {
    }

    @Override
    public void reportMultiValue(MultiValueProvider multiValueProvider) {
    }

    @Override
    protected void addEntry(AbstractSortedReportVisitor.Entry entry) {
        if (entry instanceof AbstractSortedReportVisitor.TimerEntry) {
            this.timerSet.add((AbstractSortedReportVisitor.TimerEntry)entry);
        } else if (entry instanceof AbstractSortedReportVisitor.CounterEntry) {
            this.counterSet.add((AbstractSortedReportVisitor.CounterEntry)entry);
        }
    }

    @Override
    public String toString() {
        StringBuilder buffy = new StringBuilder();
        buffy.append(this.getClass().getName());
        buffy.append("\n");
        for (AbstractSortedReportVisitor.CounterEntry counterEntry : this.counterSet) {
            buffy.append(counterEntry.getValue());
            buffy.append("\n");
        }
        for (AbstractSortedReportVisitor.TimerEntry timerEntry : this.timerSet) {
            buffy.append(timerEntry.getValue());
            buffy.append("\n");
        }
        return buffy.toString();
    }

    private static class TimerComparator
    implements Comparator<AbstractSortedReportVisitor.TimerEntry> {
        private TimerComparator() {
        }

        @Override
        public int compare(AbstractSortedReportVisitor.TimerEntry o1, AbstractSortedReportVisitor.TimerEntry o2) {
            if (o1.getAverage() == o2.getAverage()) {
                return 0;
            }
            return o1.getAverage() > o2.getAverage() ? -1 : 1;
        }
    }

    private static class CounterComparator
    implements Comparator<AbstractSortedReportVisitor.CounterEntry> {
        private CounterComparator() {
        }

        @Override
        public int compare(AbstractSortedReportVisitor.CounterEntry o1, AbstractSortedReportVisitor.CounterEntry o2) {
            if (o1.getCount() == o2.getCount()) {
                return 0;
            }
            return o1.getCount() > o2.getCount() ? -1 : 1;
        }
    }
}

