/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.visitors;

import de.is24.util.monitoring.visitors.AbstractSortedReportVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchyReportVisitor
extends AbstractSortedReportVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(HierarchyReportVisitor.class);
    private Tree tree;

    public HierarchyReportVisitor() {
        LOGGER.debug("+++ enter HierarchyReportVisitor.HierarchyReportVisitor +++");
        this.tree = new Tree();
    }

    @Override
    protected void addEntry(AbstractSortedReportVisitor.Entry entry) {
        this.tree.addEntry(entry);
    }

    public Tree getTree() {
        return this.tree;
    }

    @Override
    public String toString() {
        StringBuilder buffy = new StringBuilder();
        buffy.append(this.getClass().getName()).append("\n");
        for (Tree.TreeNode element : this.tree.getAllNodesWithEntries()) {
            for (AbstractSortedReportVisitor.Entry entry : element.entries()) {
                buffy.append(entry.getValue()).append("\n");
            }
        }
        return buffy.toString();
    }

    public static class Tree {
        private TreeNode root = new TreeNode("", "root");

        protected Tree() {
        }

        public TreeNode getRoot() {
            return this.root;
        }

        public void addEntry(AbstractSortedReportVisitor.Entry entry) {
            StringTokenizer toki = new StringTokenizer(entry.getPath(), ".");
            TreeNode currentNode = this.root;
            while (toki.hasMoreTokens()) {
                String key = toki.nextToken();
                currentNode = currentNode.getChild(key);
            }
            currentNode.addEntry(entry);
        }

        public List<TreeNode> getAllNodesWithEntries() {
            return this.root.addAllNodesWithEntries(new ArrayList<TreeNode>());
        }

        public static final class TreeNode {
            String name;
            String fqn;
            TreeMap<String, TreeNode> children;
            TreeMap<String, AbstractSortedReportVisitor.Entry> entries;

            private TreeNode(String fqn, String name) {
                this.fqn = fqn;
                this.name = name;
            }

            public TreeNode getChild(String childName) {
                TreeNode child = null;
                if (this.children != null) {
                    child = this.children.get(childName);
                }
                if (child == null) {
                    child = new TreeNode(this.fqn + "." + childName, childName);
                    if (this.children == null) {
                        this.children = new TreeMap();
                    }
                    this.children.put(childName, child);
                }
                return child;
            }

            public void addEntry(AbstractSortedReportVisitor.Entry entry) {
                if (this.entries == null) {
                    this.entries = new TreeMap();
                }
                this.entries.put(entry.getKey(), entry);
            }

            public boolean hasEntries() {
                return this.entries != null && this.entries.size() > 0;
            }

            public Iterator<AbstractSortedReportVisitor.Entry> getEntries() {
                return this.entries == null ? null : this.entries.values().iterator();
            }

            public Collection<AbstractSortedReportVisitor.Entry> entries() {
                return this.entries == null ? Collections.emptyList() : this.entries.values();
            }

            public boolean hasChildren() {
                return this.children != null && this.children.size() > 0;
            }

            public List<TreeNode> addAllNodesWithEntries(List<TreeNode> list) {
                if (this.hasEntries()) {
                    list.add(this);
                }
                if (this.hasChildren()) {
                    for (TreeNode treeNode : this.children.values()) {
                        treeNode.addAllNodesWithEntries(list);
                    }
                }
                return list;
            }
        }
    }
}

