/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.tools;

import de.is24.util.monitoring.CorePlugin;
import de.is24.util.monitoring.MultiValueProvider;
import de.is24.util.monitoring.ReportVisitor;
import de.is24.util.monitoring.State;
import de.is24.util.monitoring.StateValueProvider;
import de.is24.util.monitoring.tools.VirtualMachineMBeans;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualMachineMetrics {
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtualMachineMetrics.class);
    private static final int MAX_STACK_TRACE_DEPTH = 100;

    public static void registerVMStates(CorePlugin corePlugin) {
        final MemoryMXBean memory = VirtualMachineMBeans.getInstance().getMemory();
        corePlugin.registerStateValue(new StateValueProvider(){

            @Override
            public long getValue() {
                return memory.getHeapMemoryUsage().getInit();
            }

            @Override
            public String getName() {
                return "jvm.memory.heap.init";
            }
        });
        corePlugin.registerStateValue(new StateValueProvider(){

            @Override
            public long getValue() {
                return memory.getNonHeapMemoryUsage().getInit();
            }

            @Override
            public String getName() {
                return "jvm.memory.nonHeap.init";
            }
        });
        corePlugin.registerStateValue(new StateValueProvider(){

            @Override
            public long getValue() {
                return memory.getHeapMemoryUsage().getUsed();
            }

            @Override
            public String getName() {
                return "jvm.memory.heap.used";
            }
        });
        corePlugin.registerStateValue(new StateValueProvider(){

            @Override
            public long getValue() {
                return memory.getNonHeapMemoryUsage().getUsed();
            }

            @Override
            public String getName() {
                return "jvm.memory.nonHeap.used";
            }
        });
        corePlugin.registerStateValue(new StateValueProvider(){

            @Override
            public long getValue() {
                return memory.getHeapMemoryUsage().getCommitted();
            }

            @Override
            public String getName() {
                return "jvm.memory.heap.committed";
            }
        });
        corePlugin.registerStateValue(new StateValueProvider(){

            @Override
            public long getValue() {
                return memory.getNonHeapMemoryUsage().getCommitted();
            }

            @Override
            public String getName() {
                return "jvm.memory.nonHeap.committed";
            }
        });
        for (final MemoryPoolMXBean pool : VirtualMachineMBeans.getInstance().getMemoryPools()) {
            corePlugin.registerStateValue(new StateValueProvider(){

                @Override
                public long getValue() {
                    return pool.getUsage().getUsed();
                }

                @Override
                public String getName() {
                    return "jvm.memory." + pool.getName().replace(" ", "_") + ".used";
                }
            });
            corePlugin.registerStateValue(new StateValueProvider(){

                @Override
                public long getValue() {
                    return pool.getUsage().getCommitted();
                }

                @Override
                public String getName() {
                    return "jvm.memory." + pool.getName().replace(" ", "_") + ".committed";
                }
            });
        }
        final ThreadMXBean threadMXBean = VirtualMachineMBeans.getInstance().getThreads();
        corePlugin.registerStateValue(new StateValueProvider(){

            @Override
            public long getValue() {
                return threadMXBean.getThreadCount();
            }

            @Override
            public String getName() {
                return "jvm.threads.count";
            }
        });
        corePlugin.registerStateValue(new StateValueProvider(){

            @Override
            public long getValue() {
                return threadMXBean.getDaemonThreadCount();
            }

            @Override
            public String getName() {
                return "jvm.threads.daemon";
            }
        });
        final OperatingSystemMXBean operatingSystemMXBean = VirtualMachineMBeans.getInstance().getOs();
        corePlugin.registerStateValue(new StateValueProvider(){

            @Override
            public long getValue() {
                try {
                    Method getOpenFileDescriptorCount = operatingSystemMXBean.getClass().getDeclaredMethod("getOpenFileDescriptorCount", new Class[0]);
                    getOpenFileDescriptorCount.setAccessible(true);
                    return (Long)getOpenFileDescriptorCount.invoke((Object)operatingSystemMXBean, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    return -1L;
                }
                catch (IllegalAccessException e) {
                    return -1L;
                }
                catch (InvocationTargetException e) {
                    return -1L;
                }
            }

            @Override
            public String getName() {
                return "jvm.filedescriptors.open";
            }
        });
        corePlugin.registerStateValue(new StateValueProvider(){

            @Override
            public long getValue() {
                try {
                    Method getMaxFileDescriptorCount = operatingSystemMXBean.getClass().getDeclaredMethod("getMaxFileDescriptorCount", new Class[0]);
                    getMaxFileDescriptorCount.setAccessible(true);
                    return (Long)getMaxFileDescriptorCount.invoke((Object)operatingSystemMXBean, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    return -1L;
                }
                catch (IllegalAccessException e) {
                    return -1L;
                }
                catch (InvocationTargetException e) {
                    return -1L;
                }
            }

            @Override
            public String getName() {
                return "jvm.filedescriptors.max";
            }
        });
        List<GarbageCollectorMXBean> garbageCollectors = VirtualMachineMBeans.getInstance().getGarbageCollectors();
        LOGGER.info("found {} garbage collectors", (Object)garbageCollectors.size());
        Iterator<GarbageCollectorMXBean> i$ = garbageCollectors.iterator();
        while (i$.hasNext()) {
            GarbageCollectorMXBean gc;
            final GarbageCollectorMXBean finalGC = gc = i$.next();
            LOGGER.info("adding garbage collector {}", (Object)gc.getName());
            corePlugin.registerStateValue(new StateValueProvider(){

                @Override
                public long getValue() {
                    return finalGC.getCollectionCount();
                }

                @Override
                public String getName() {
                    return "jvm.gc." + finalGC.getName() + ".count";
                }
            });
            corePlugin.registerStateValue(new StateValueProvider(){

                @Override
                public long getValue() {
                    return finalGC.getCollectionTime();
                }

                @Override
                public String getName() {
                    return "jvm.gc." + finalGC.getName() + ".time";
                }
            });
        }
        corePlugin.registerMultiValueProvider(new ThreadStateProvider());
    }

    public Map<String, BufferPoolStats> getBufferPoolStats() {
        try {
            String[] attributes = new String[]{"Count", "MemoryUsed", "TotalCapacity"};
            ObjectName direct = new ObjectName("java.nio:type=BufferPool,name=direct");
            ObjectName mapped = new ObjectName("java.nio:type=BufferPool,name=mapped");
            MBeanServer mBeanServer = VirtualMachineMBeans.getInstance().getMBeanServer();
            AttributeList directAttributes = mBeanServer.getAttributes(direct, attributes);
            AttributeList mappedAttributes = mBeanServer.getAttributes(mapped, attributes);
            TreeMap<String, BufferPoolStats> stats = new TreeMap<String, BufferPoolStats>();
            BufferPoolStats directStats = new BufferPoolStats((Long)((Attribute)directAttributes.get(0)).getValue(), (Long)((Attribute)directAttributes.get(1)).getValue(), (Long)((Attribute)directAttributes.get(2)).getValue());
            stats.put("direct", directStats);
            BufferPoolStats mappedStats = new BufferPoolStats((Long)((Attribute)mappedAttributes.get(0)).getValue(), (Long)((Attribute)mappedAttributes.get(1)).getValue(), (Long)((Attribute)mappedAttributes.get(2)).getValue());
            stats.put("mapped", mappedStats);
            return Collections.unmodifiableMap(stats);
        }
        catch (JMException e) {
            return Collections.emptyMap();
        }
    }

    public static class ThreadStateProvider
    implements MultiValueProvider {
        @Override
        public Collection<State> getValues() {
            ArrayList<State> threadStates = new ArrayList<State>();
            HashMap<Thread.State, Integer> conditions = new HashMap<Thread.State, Integer>();
            for (Thread.State state : Thread.State.values()) {
                conditions.put(state, 0);
            }
            ThreadMXBean threadMXBean = VirtualMachineMBeans.getInstance().getThreads();
            long[] allThreadIds = threadMXBean.getAllThreadIds();
            ThreadInfo[] allThreads = threadMXBean.getThreadInfo(allThreadIds);
            int liveCount = 0;
            for (ThreadInfo info : allThreads) {
                if (info == null) continue;
                Thread.State state = info.getThreadState();
                conditions.put(state, (Integer)conditions.get((Object)state) + 1);
                ++liveCount;
            }
            long total = 0L;
            for (Thread.State state : new ArrayList(conditions.keySet())) {
                Integer value = (Integer)conditions.get((Object)state);
                total += value.longValue();
                threadStates.add(new State("jvm.threads", state.name(), value.intValue()));
            }
            threadStates.add(new State("jvm.threads", "total", total));
            return threadStates;
        }

        @Override
        public String getName() {
            return "VMThreadStates";
        }

        @Override
        public void accept(ReportVisitor visitor) {
            visitor.reportMultiValue(this);
        }
    }

    public static class BufferPoolStats {
        private final long count;
        private final long memoryUsed;
        private final long totalCapacity;

        private BufferPoolStats(long count, long memoryUsed, long totalCapacity) {
            this.count = count;
            this.memoryUsed = memoryUsed;
            this.totalCapacity = totalCapacity;
        }

        public long getCount() {
            return this.count;
        }

        public long getMemoryUsed() {
            return this.memoryUsed;
        }

        public long getTotalCapacity() {
            return this.totalCapacity;
        }
    }

    public static class GarbageCollectorStats {
        private final long runs;
        private final long timeMS;

        private GarbageCollectorStats(long runs, long timeMS) {
            this.runs = runs;
            this.timeMS = timeMS;
        }

        public long getRuns() {
            return this.runs;
        }

        public long getTime(TimeUnit unit) {
            return unit.convert(this.timeMS, TimeUnit.MILLISECONDS);
        }
    }
}

