/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.statsd;

import de.is24.util.monitoring.AbstractMonitorPlugin;
import de.is24.util.monitoring.statsd.StatsdClient;
import de.is24.util.monitoring.statsd.StatsdMessageFormatter;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsdPlugin
extends AbstractMonitorPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(StatsdPlugin.class);
    private final StatsdClient delegate;
    private final String uniqueName;
    private double sampleRate;
    private double highVolumeSampleRate;

    public StatsdPlugin(String host, int port, String appName) throws UnknownHostException, SocketException {
        this(host, port, appName, 1.0);
    }

    public StatsdPlugin(String host, int port, String appName, double sampleRate) throws UnknownHostException, SocketException {
        this(new StatsdClient(host, port, appName), StatsdPlugin.getUniqeName(host, port, sampleRate), sampleRate);
    }

    public StatsdPlugin(String host, int port, StatsdMessageFormatter statsdMessageFormatter) throws SocketException, UnknownHostException {
        this(new StatsdClient(host, port, statsdMessageFormatter), StatsdPlugin.getUniqeName(host, port, 1.0), 1.0);
    }

    public StatsdPlugin(String host, int port, double sampleRate, StatsdMessageFormatter statsdMessageFormatter) throws SocketException, UnknownHostException {
        this(new StatsdClient(host, port, statsdMessageFormatter), StatsdPlugin.getUniqeName(host, port, sampleRate), sampleRate);
    }

    StatsdPlugin(StatsdClient client, String uniqeName, double sampleRate) {
        this.delegate = client;
        this.uniqueName = uniqeName;
        if (sampleRate < 0.0) {
            throw new IllegalArgumentException("negative sample rate not permitted");
        }
        this.sampleRate = sampleRate;
        this.initHighVolumeSampleRate();
        LOG.info("StatsdPlugin {} initialized", (Object)this.uniqueName);
    }

    private static String getUniqeName(String host, int port, double sampleRate) {
        return "StatsdPlugin_" + host + "_" + port + "_" + sampleRate;
    }

    @Override
    public void afterRemovalNotification() {
        LOG.info("StatsdPlugin {} notified of removal", (Object)this.uniqueName);
        this.delegate.close();
    }

    private void initHighVolumeSampleRate() {
        this.highVolumeSampleRate = this.sampleRate * 0.1;
    }

    @Override
    public String getUniqueName() {
        return this.uniqueName;
    }

    private String sanitizeKey(String key) {
        return key.replaceAll(":", "_");
    }

    @Override
    public void incrementCounter(String key, int increment) {
        this.delegate.increment(this.sanitizeKey(key), increment, this.sampleRate);
    }

    @Override
    public void incrementHighRateCounter(String key, int increment) {
        this.delegate.increment(this.sanitizeKey(key), increment, this.highVolumeSampleRate);
    }

    @Override
    public void initializeCounter(String name) {
    }

    @Override
    public void addTimerMeasurement(String key, long timing) {
        this.delegate.timing(this.sanitizeKey(key), (int)timing, this.sampleRate);
    }

    @Override
    public void addSingleEventTimerMeasurement(String name, long timing) {
    }

    @Override
    public void initializeTimerMeasurement(String name) {
    }

    @Override
    public void addHighRateTimerMeasurement(String key, long timing) {
        this.delegate.timing(this.sanitizeKey(key), (int)timing, this.highVolumeSampleRate);
    }
}

