/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.aop;

import de.is24.util.monitoring.PerfTimer;
import de.is24.util.monitoring.measurement.MeasurementHandler;
import de.is24.util.monitoring.measurement.TimerMeasurementHandler;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InApplicationMonitorInterceptor
implements MethodInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(InApplicationMonitorInterceptor.class);
    private String prefix;
    MeasurementHandler[] handlers = new MeasurementHandler[]{new TimerMeasurementHandler()};

    public void setHandlers(MeasurementHandler[] handlers) {
        this.handlers = handlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation mi) throws Throwable {
        String monitorName = this.getMonitorName(mi);
        PerfTimer.PerfMonitor monitor = PerfTimer.createMonitor();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("enter [" + monitorName + "]");
            }
            Object object = mi.proceed();
            return object;
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("leave [" + monitorName + "]");
            }
            monitor.handleMeasurement(monitorName, this.handlers);
        }
    }

    protected String getMonitorName(MethodInvocation mi) {
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isNotEmpty((String)this.prefix)) {
            builder.append(this.prefix).append(":");
        }
        builder.append(mi.getThis().getClass().getName());
        builder.append(".");
        builder.append(mi.getMethod().getName());
        return builder.toString();
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

