/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.jmx;

import de.is24.util.monitoring.CorePlugin;
import de.is24.util.monitoring.Counter;
import de.is24.util.monitoring.HistorizableList;
import de.is24.util.monitoring.InApplicationMonitor;
import de.is24.util.monitoring.MultiValueProvider;
import de.is24.util.monitoring.Reportable;
import de.is24.util.monitoring.ReportableObserver;
import de.is24.util.monitoring.StateValueProvider;
import de.is24.util.monitoring.Timer;
import de.is24.util.monitoring.Version;
import de.is24.util.monitoring.jmx.InApplicationMonitorDynamicMBean;
import de.is24.util.monitoring.jmx.JMXBeanRegistrationHelper;
import de.is24.util.monitoring.jmx.JmxAppMon4JNamingStrategy;
import de.is24.util.monitoring.jmx.MultiValueProviderHelper;
import de.is24.util.monitoring.state2graphite.StateValuesToGraphite;
import de.is24.util.monitoring.statsd.StatsdPlugin;
import de.is24.util.monitoring.visitors.HistogramLikeValueAnalysisVisitor;
import de.is24.util.monitoring.visitors.StringWriterReportVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InApplicationMonitorJMXConnector
implements DynamicMBean,
ReportableObserver {
    private static final String DUMP_STRING_WRITER = "dumpStringWriter";
    private static final String DUMP_HISTOGRAM_LIKE_VALUE_ANALYSIS = "dumpHistogramLikeValueAnalysis";
    private static final String ACTIVATE = "activate";
    private static final String DEACTIVATE = "deactivate";
    private static final String IS_MONITOR_ACTIVE = "isMonitorActive";
    private static final String GET_REGISTERED_PLUGIN_KEYS = "getRegisteredPluginKeys";
    private static final String GET_REGISTERED_OBSERVERS = "getRegisteredReportableObservers";
    private static final String REMOVE_ALL_PLUGINS = "removeAllPlugins";
    private static final String ADD_STATSD_PLUGIN = "addStatsdPlugin";
    private static final String ADD_STATE_VALUES_TO_GRAPHITE = "addStateValuesToGraphite";
    private static final String ADD_JMX_EXPORTER_PATTERN = "addJmxExporterPattern";
    private static final String LIST_JMX_EXPORTER_PATTERN = "listJmxExporterPattern";
    private static final String REMOVE_JMX_EXPORTER_PATTERN = "removeJmxExporterPattern";
    private static final Logger LOG = LoggerFactory.getLogger(InApplicationMonitorJMXConnector.class);
    private static volatile InApplicationMonitorJMXConnector instance;
    private static final Object semaphore;
    private final Map<String, Reportable> reportables = new ConcurrentHashMap<String, Reportable>();
    private final JMXBeanRegistrationHelper jmxBeanRegistrationHelper;
    private final CorePlugin corePlugin;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InApplicationMonitorJMXConnector(CorePlugin corePlugin, JmxAppMon4JNamingStrategy jmxAppMon4JNamingStrategy) {
        Object object = semaphore;
        synchronized (object) {
            LOG.info("initializing InApplicationMonitorJMXConnector");
            if (instance != null) {
                LOG.error("JMXConnector allready initialized, this is not allowed");
                throw new IllegalStateException("JMXConnector already initialized");
            }
            this.corePlugin = corePlugin;
            this.jmxBeanRegistrationHelper = new JMXBeanRegistrationHelper(jmxAppMon4JNamingStrategy);
            this.registerJMXStuff();
            corePlugin.addReportableObserver(this);
            instance = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = semaphore;
        synchronized (object) {
            LOG.info("shutting down InApplicationMonitorJMXConnector ");
            this.corePlugin.removeReportableObserver(this);
            this.removeAllReportables();
            try {
                this.jmxBeanRegistrationHelper.unregisterMBeanOnJMX("InApplicationMonitor", null);
            }
            catch (Exception e) {
                LOG.warn("problem when unregistering InApplicationMonitorJMXConnector during shutdown", e);
            }
            instance = null;
        }
    }

    private void registerJMXStuff() {
        LOG.info("registering InApplicationMonitorDynamicMBean on JMX server");
        try {
            this.jmxBeanRegistrationHelper.registerMBeanOnJMX(this, "InApplicationMonitor", null);
        }
        catch (Exception e) {
            LOG.error("could not register MBean server : ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNewReportable(Reportable reportable) {
        String reportableKey;
        String string = reportableKey = reportable.getName().intern();
        synchronized (string) {
            boolean beanAlreadyRegistred = this.reportables.containsKey(reportableKey);
            this.reportables.put(reportableKey, reportable);
            if (reportable instanceof Timer || reportable instanceof HistorizableList) {
                InApplicationMonitorDynamicMBean bean = new InApplicationMonitorDynamicMBean(reportable);
                try {
                    if (beanAlreadyRegistred) {
                        this.jmxBeanRegistrationHelper.unregisterMBeanOnJMX(reportableKey, "InApplicationMonitor");
                    }
                    this.jmxBeanRegistrationHelper.registerMBeanOnJMX(bean, reportableKey, "InApplicationMonitor");
                }
                catch (Exception e) {
                    LOG.error("could not register MBean for " + reportableKey, e);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("registered new reportable " + reportableKey + " for JMX");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllReportables() {
        for (Reportable reportable : this.reportables.values()) {
            String reportableKey;
            String string = reportableKey = reportable.getName().intern();
            synchronized (string) {
                if (reportable instanceof Timer || reportable instanceof HistorizableList) {
                    try {
                        this.jmxBeanRegistrationHelper.unregisterMBeanOnJMX(reportableKey, "InApplicationMonitor");
                    }
                    catch (Exception e) {
                        LOG.error("could not unregister MBean for " + reportableKey, e);
                    }
                }
            }
        }
        this.reportables.clear();
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
        for (Map.Entry<String, Reportable> entry : this.reportables.entrySet()) {
            if (entry.getValue() instanceof Counter || entry.getValue() instanceof StateValueProvider) {
                attributes.add(new MBeanAttributeInfo(entry.getKey(), "long", entry.getKey(), true, false, false));
                continue;
            }
            if (entry.getValue() instanceof MultiValueProvider) {
                LOG.info("### add multi value " + entry.getKey());
                attributes.add(new MBeanAttributeInfo(entry.getKey(), "javax.management.openmbean.CompositeData", entry.getKey(), true, false, false));
                continue;
            }
            if (!(entry.getValue() instanceof Version)) continue;
            attributes.add(new MBeanAttributeInfo(entry.getKey(), "String", entry.getKey(), true, false, false));
        }
        MBeanAttributeInfo[] beanAttributeInfos = new MBeanAttributeInfo[attributes.size()];
        if (LOG.isDebugEnabled()) {
            LOG.debug("getMBeanInfo returning " + attributes.size() + " reportables.");
        }
        for (int loop = 0; loop < attributes.size(); ++loop) {
            beanAttributeInfos[loop] = (MBeanAttributeInfo)attributes.get(loop);
        }
        MBeanOperationInfo[] beanOperationInfos = new MBeanOperationInfo[]{new MBeanOperationInfo(DUMP_STRING_WRITER, "", null, "String", 2), new MBeanOperationInfo(DUMP_HISTOGRAM_LIKE_VALUE_ANALYSIS, "", new MBeanParameterInfo[]{new MBeanParameterInfo("base", "java.lang.String", "")}, "String", 2), new MBeanOperationInfo(ACTIVATE, "enable monitoring", null, "void", 1), new MBeanOperationInfo(DEACTIVATE, "disable monitoring", null, "void", 1), new MBeanOperationInfo(IS_MONITOR_ACTIVE, "check if monitor is active", null, "java.lang.Boolean", 0), new MBeanOperationInfo(GET_REGISTERED_PLUGIN_KEYS, "list registered plugin keys", null, "java.util.List", 0), new MBeanOperationInfo(GET_REGISTERED_OBSERVERS, "list registered reportable observers", null, "java.util.List", 0), new MBeanOperationInfo(REMOVE_ALL_PLUGINS, "remove all plugins", null, "void", 1), new MBeanOperationInfo(ADD_STATSD_PLUGIN, "", new MBeanParameterInfo[]{new MBeanParameterInfo("statsd hostname", "java.lang.String", ""), new MBeanParameterInfo("statsd port", "java.lang.Integer", ""), new MBeanParameterInfo("app name", "java.lang.String", ""), new MBeanParameterInfo("sample rate", "java.lang.Double", "")}, "void", 1), new MBeanOperationInfo(ADD_STATE_VALUES_TO_GRAPHITE, "", new MBeanParameterInfo[]{new MBeanParameterInfo("graphite hostname", "java.lang.String", ""), new MBeanParameterInfo("graphite port", "java.lang.Integer", ""), new MBeanParameterInfo("app name", "java.lang.String", "")}, "void", 1), new MBeanOperationInfo(ADD_JMX_EXPORTER_PATTERN, "This will add an ObjectName pattern to the JMXExporter", new MBeanParameterInfo[]{new MBeanParameterInfo("ObjectName pattern", "java.lang.String", "")}, "void", 1), new MBeanOperationInfo(LIST_JMX_EXPORTER_PATTERN, "List current JMXExporter Patterns", null, "java.util.List", 1), new MBeanOperationInfo(REMOVE_JMX_EXPORTER_PATTERN, "This will remove an ObjectName pattern to the JMXExporter", new MBeanParameterInfo[]{new MBeanParameterInfo("ObjectName pattern", "java.lang.String", "")}, "java.lang.Boolean", 1)};
        return new MBeanInfo("de.is24.util.monitoring.InApplicationMonitorDynamicMBeanThing", "InApplication Monitor dynamic MBean", beanAttributeInfos, null, beanOperationInfos, null);
    }

    private Object getValueForReportable(String attribute) {
        LOG.debug("getting value for attribute " + attribute);
        Reportable reportable = this.reportables.get(attribute);
        if (reportable != null) {
            if (reportable instanceof Counter) {
                return ((Counter)reportable).getCount();
            }
            if (reportable instanceof StateValueProvider) {
                return ((StateValueProvider)reportable).getValue();
            }
            if (reportable instanceof MultiValueProvider) {
                CompositeData compositeData = new MultiValueProviderHelper((MultiValueProvider)reportable).toComposite();
                LOG.info("type : " + compositeData.getCompositeType().toString());
                return compositeData;
            }
            if (reportable instanceof Version) {
                return ((Version)reportable).getValue();
            }
        } else {
            LOG.warn("attribute " + attribute + " not found");
        }
        return null;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.getValueForReportable(attribute);
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList attributeList = new AttributeList();
        for (Attribute attribute : attributeList.asList()) {
            attributeList.add(new Attribute(attribute.getName(), this.getValueForReportable(attribute.getName())));
        }
        return attributeList;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName.equals(DUMP_STRING_WRITER)) {
            return this.dumpStringWriter();
        }
        if (actionName.equals(DUMP_HISTOGRAM_LIKE_VALUE_ANALYSIS)) {
            return this.dumpHistogramLikeValueAnalysis((String)params[0]);
        }
        if (actionName.equals(ACTIVATE)) {
            this.activate();
        } else if (actionName.equals(DEACTIVATE)) {
            this.deactivate();
        } else {
            if (actionName.equals(IS_MONITOR_ACTIVE)) {
                return this.isMonitorActive();
            }
            if (actionName.equals(GET_REGISTERED_PLUGIN_KEYS)) {
                return this.getRegisteredPluginKeys();
            }
            if (actionName.equals(GET_REGISTERED_OBSERVERS)) {
                return this.getRegisteredObservers();
            }
            if (actionName.equals(REMOVE_ALL_PLUGINS)) {
                InApplicationMonitor.getInstance().removeAllPlugins();
            } else if (actionName.equals(ADD_STATSD_PLUGIN)) {
                String host = (String)params[0];
                Integer port = (Integer)params[1];
                String appName = (String)params[2];
                Double sampleRate = (Double)params[3];
                this.addStatsdPlugin(host, port, appName, sampleRate);
            } else if (actionName.equals(ADD_STATE_VALUES_TO_GRAPHITE)) {
                String host = (String)params[0];
                Integer port = (Integer)params[1];
                String appName = (String)params[2];
                this.addStateValuesToGraphite(host, port, appName);
            } else if (actionName.equals(ADD_JMX_EXPORTER_PATTERN)) {
                String pattern = (String)params[0];
                this.corePlugin.addJMXExporterPattern(pattern);
            } else {
                if (actionName.equals(LIST_JMX_EXPORTER_PATTERN)) {
                    return this.corePlugin.listJMXExporterPattern();
                }
                if (actionName.equals(REMOVE_JMX_EXPORTER_PATTERN)) {
                    String pattern = (String)params[0];
                    return this.corePlugin.removeJMXExporterPattern(pattern);
                }
            }
        }
        return null;
    }

    private void addStatsdPlugin(String host, Integer port, String appName, Double sampleRate) {
        try {
            StatsdPlugin statsdPlugin = new StatsdPlugin(host, (int)port, appName, sampleRate);
            InApplicationMonitor.getInstance().registerPlugin(statsdPlugin);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addStateValuesToGraphite(String host, Integer port, String appName) {
        try {
            LOG.info("About to create a StateValueToGraphite Instance in JMXConnector with host: " + host + ", port: " + port + ", appName: " + appName);
            new StateValuesToGraphite(host, port, appName);
            LOG.info("Creation of StateValueToGraphite Instance succeeded");
        }
        catch (Exception e) {
            LOG.warn("Creation of StateValueToGraphite Instance in JMXConnector failed: host: " + host + ", port: " + port + ", appName: " + appName, e);
            throw new RuntimeException(e);
        }
    }

    public String dumpStringWriter() {
        StringWriterReportVisitor visitor = new StringWriterReportVisitor();
        this.corePlugin.reportInto(visitor);
        LOG.info(visitor.toString());
        return visitor.toString();
    }

    public String dumpHistogramLikeValueAnalysis(String base) {
        HistogramLikeValueAnalysisVisitor visitor = new HistogramLikeValueAnalysisVisitor(base);
        this.corePlugin.reportInto(visitor);
        LOG.info(visitor.toString());
        return visitor.toString();
    }

    public void activate() {
        InApplicationMonitor.getInstance().activate();
    }

    public void deactivate() {
        InApplicationMonitor.getInstance().deactivate();
    }

    public Boolean isMonitorActive() {
        return InApplicationMonitor.getInstance().isMonitorActive();
    }

    public List<String> getRegisteredPluginKeys() {
        return InApplicationMonitor.getInstance().getRegisteredPluginKeys();
    }

    public List<String> getRegisteredObservers() {
        return InApplicationMonitor.getInstance().getCorePlugin().getRegisteredReportableObservers();
    }

    static {
        semaphore = new Object();
    }
}

