/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.agent;

import de.is24.util.monitoring.CorePlugin;
import de.is24.util.monitoring.InApplicationMonitor;
import de.is24.util.monitoring.agent.Appmon4JAgentConfiguration;
import de.is24.util.monitoring.keyhandler.DefaultKeyEscaper;
import de.is24.util.monitoring.keyhandler.KeyHandler;
import de.is24.util.monitoring.state2graphite.StateValuesToGraphite;
import java.lang.instrument.Instrumentation;

public class Appmon4JAgent {
    private CorePlugin corePlugin;

    protected Appmon4JAgent(Appmon4JAgentConfiguration configuration, Instrumentation instrumentation) {
        this.initializeInApplicationMonitorAndCorePlugin();
        if (configuration.isJmxExportConfigured()) {
            this.log("Will configure JMX Exporter, which in turn will configure InApplicationMonitor ...");
            String jmxExporterSource = configuration.getJmxExporterSource();
            if (configuration.isJmxExportFile()) {
                this.log("... config JMXExporter from file " + jmxExporterSource);
                this.corePlugin.readJMXExporterPatternFromFile(jmxExporterSource);
            } else {
                this.log("... config JMXExporter from directory " + jmxExporterSource);
                this.corePlugin.readJMXExporterPatternFromDir(jmxExporterSource);
            }
            this.log("... JMX Exporter configured successfully.");
        } else {
            this.log("JMX Exporter not configured.");
        }
        if (configuration.isGraphiteConfigured()) {
            this.log("Will configure StateValuesToGraphite Plugin ...");
            new StateValuesToGraphite(configuration.getGraphiteHost(), configuration.getGraphitePort(), configuration.getGraphiteAppNamePrefix());
            this.log("... StateValuesToGraphite configured.");
        } else {
            this.log("StateValuesToGraphite not configured.");
        }
    }

    private void log(String message) {
        System.out.println("Appmon4jAgent: " + message);
    }

    private synchronized void initializeInApplicationMonitorAndCorePlugin() {
        if (this.corePlugin == null) {
            KeyHandler keyHandler = this.getKeyHandler();
            this.corePlugin = new CorePlugin(null, keyHandler);
            InApplicationMonitor.initInstance(this.corePlugin, keyHandler);
        }
    }

    private KeyHandler getKeyHandler() {
        return new DefaultKeyEscaper();
    }

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        System.out.println("Initialiting Appmon4jAgent");
        Appmon4JAgentConfiguration configuration = null;
        try {
            configuration = Appmon4JAgentConfiguration.load(agentArgs);
        }
        catch (Exception e) {
            System.err.println("failed to load appmon4j agent configuration from " + agentArgs + ".");
            e.printStackTrace();
        }
        if (configuration != null) {
            new Appmon4JAgent(configuration, instrumentation);
        } else {
            System.err.println("appmon4j Agent: Unable to start up. No valid configuration found. Will do nothing. ");
        }
    }
}

