/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring;

import de.is24.util.monitoring.Math;
import de.is24.util.monitoring.ReportVisitor;
import de.is24.util.monitoring.Reportable;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timer
implements Reportable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Timer.class);
    private final String name;
    private final AtomicLong count = new AtomicLong();
    private final AtomicLong timerSum = new AtomicLong();
    private final AtomicLong timerSumOfSquares = new AtomicLong();

    Timer(String name) {
        this.name = name;
    }

    @Override
    public void accept(ReportVisitor aVisitor) {
        LOGGER.debug("+++ entering Timer.accept +++");
        aVisitor.reportTimer(this);
    }

    public void addMeasurement(long durationInMillis) {
        this.count.addAndGet(1L);
        this.timerSum.addAndGet(durationInMillis);
        this.timerSumOfSquares.addAndGet(durationInMillis * durationInMillis);
    }

    public void initializeMeasurement() {
        this.count.set(0L);
        this.timerSum.set(0L);
        this.timerSumOfSquares.set(0L);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public long getCount() {
        return this.count.get();
    }

    public long getTimerSum() {
        return this.timerSum.get();
    }

    public double getTimerAvg() {
        return Math.average(this.count.get(), this.timerSum.get());
    }

    public double getTimerStdDev() {
        return Math.stdDeviation(this.count.get(), this.timerSum.get(), this.timerSumOfSquares.get());
    }
}

