/*
 * Decompiled with CFR 0.152.
 */
package de.is24.util.monitoring.agent;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Appmon4JAgentConfiguration {
    private boolean instrumentationConfigured;
    private boolean jmxExportConfigured;
    private boolean jmxExportFile;
    private String jmxExporterSource;
    private boolean graphiteConfigured;
    private String graphiteHost;
    private String graphiteAppNamePrefix;
    private int graphitePort;
    private static final String JXMEXPORT_PATTERN_FILE_NAME = "JMXExporter.patternFileName";
    private static final String JXMEXPORT_PATTERN_DIRECTORY_NAME = "JMXExporter.patternDirectoryName";
    private static final String GRAPHITE_HOST = "graphite.host";
    private static final String GRAPHITE_APP_NAME_PREFIX = "graphite.appNamePrefix";
    private static final String GRAPHITE_PORT = "graphite.port";

    public Appmon4JAgentConfiguration(Properties properties) {
        this.checkJMXExporterConfig(properties);
        this.checkGraphiteConfig(properties);
    }

    private void checkJMXExporterConfig(Properties properties) {
        this.jmxExporterSource = properties.getProperty(JXMEXPORT_PATTERN_DIRECTORY_NAME);
        this.jmxExportConfigured = true;
        if (this.jmxExporterSource != null) {
            this.jmxExportFile = false;
        } else {
            this.jmxExporterSource = properties.getProperty(JXMEXPORT_PATTERN_FILE_NAME);
            if (this.jmxExporterSource != null) {
                this.jmxExportFile = true;
            } else {
                this.jmxExportConfigured = false;
            }
        }
    }

    private void checkGraphiteConfig(Properties properties) {
        this.graphiteHost = properties.getProperty(GRAPHITE_HOST);
        this.graphiteAppNamePrefix = properties.getProperty(GRAPHITE_APP_NAME_PREFIX, "Appmon4jAgent");
        this.graphitePort = Integer.parseInt(properties.getProperty(GRAPHITE_PORT, "2003"));
        this.graphiteConfigured = this.graphiteHost != null && this.graphiteHost.trim().length() > 0;
    }

    public static Appmon4JAgentConfiguration load(String propertiesFileName) throws IOException {
        InputStream inputStream = new File(propertiesFileName).toURI().toURL().openStream();
        Properties properties = new Properties();
        properties.load(inputStream);
        return new Appmon4JAgentConfiguration(properties);
    }

    public boolean isInstrumentationConfigured() {
        return this.instrumentationConfigured;
    }

    public void setInstrumentationConfigured(boolean instrumentationConfigured) {
        this.instrumentationConfigured = instrumentationConfigured;
    }

    public boolean isJmxExportConfigured() {
        return this.jmxExportConfigured;
    }

    public boolean isJmxExportFile() {
        return this.jmxExportFile;
    }

    public String getJmxExporterSource() {
        return this.jmxExporterSource;
    }

    public boolean isGraphiteConfigured() {
        return this.graphiteConfigured;
    }

    public void setGraphiteConfigured(boolean graphiteConfigured) {
        this.graphiteConfigured = graphiteConfigured;
    }

    public String getGraphiteHost() {
        return this.graphiteHost;
    }

    public String getGraphiteAppNamePrefix() {
        return this.graphiteAppNamePrefix;
    }

    public int getGraphitePort() {
        return this.graphitePort;
    }
}

