/*
 * Decompiled with CFR 0.152.
 */
package de.irissmann.arachni.client.rest;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.irissmann.arachni.client.ArachniClientException;
import java.util.Map;

class GsonUtils {
    GsonUtils() {
    }

    static void merge(JsonObject leftObj, JsonObject rightObj, MergeConflictStrategy conflictStrategy) {
        for (Map.Entry rightEntry : rightObj.entrySet()) {
            String rightKey = (String)rightEntry.getKey();
            JsonElement rightVal = (JsonElement)rightEntry.getValue();
            if (leftObj.has(rightKey)) {
                JsonElement leftVal = leftObj.get(rightKey);
                if (leftVal.isJsonArray() && rightVal.isJsonArray()) {
                    JsonArray leftArr = leftVal.getAsJsonArray();
                    JsonArray rightArr = rightVal.getAsJsonArray();
                    for (int i = 0; i < rightArr.size(); ++i) {
                        leftArr.add(rightArr.get(i));
                    }
                    continue;
                }
                if (leftVal.isJsonObject() && rightVal.isJsonObject()) {
                    GsonUtils.merge(leftVal.getAsJsonObject(), rightVal.getAsJsonObject(), conflictStrategy);
                    continue;
                }
                GsonUtils.handleMergeConflict(rightKey, leftObj, leftVal, rightVal, conflictStrategy);
                continue;
            }
            leftObj.add(rightKey, rightVal);
        }
    }

    private static void handleMergeConflict(String key, JsonObject leftObj, JsonElement leftVal, JsonElement rightVal, MergeConflictStrategy conflictStrategy) {
        switch (conflictStrategy) {
            case PREFER_OBJECT: {
                break;
            }
            case PREFER_STRING: {
                leftObj.add(key, rightVal);
                break;
            }
            case PREFER_NON_NULL: {
                if (!leftVal.isJsonNull() || rightVal.isJsonNull()) break;
                leftObj.add(key, rightVal);
                break;
            }
            case THROW_EXCEPTION: {
                throw new ArachniClientException("Key " + key + " exists in both objects and the conflict resolution strategy is " + (Object)((Object)conflictStrategy));
            }
            default: {
                throw new UnsupportedOperationException("The conflict strategy " + (Object)((Object)conflictStrategy) + " is unknown and cannot be processed");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MergeConflictStrategy {
        THROW_EXCEPTION,
        PREFER_OBJECT,
        PREFER_STRING,
        PREFER_NON_NULL;

    }
}

