/*
 * Decompiled with CFR 0.152.
 */
package de.irissmann.arachni.client.rest;

import de.irissmann.arachni.client.ArachniClient;
import de.irissmann.arachni.client.ArachniClientException;
import de.irissmann.arachni.client.rest.ArachniRestClient;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.http.auth.UsernamePasswordCredentials;

public class ArachniRestClientBuilder {
    private final URL arachniRestUrl;
    private UsernamePasswordCredentials credentials;

    private ArachniRestClientBuilder(URL arachniRestUrl) {
        this.arachniRestUrl = arachniRestUrl;
    }

    public static ArachniRestClientBuilder create(String arachniRestUrl) {
        try {
            return new ArachniRestClientBuilder(new URL(arachniRestUrl));
        }
        catch (MalformedURLException exception) {
            throw new ArachniClientException(exception.getMessage());
        }
    }

    public final ArachniRestClientBuilder addCredentials(String username, String password) {
        this.credentials = new UsernamePasswordCredentials(username, password);
        return this;
    }

    public final ArachniClient build() {
        return new ArachniRestClient(this.arachniRestUrl, this.credentials);
    }
}

