/*
 * Decompiled with CFR 0.152.
 */
package de.id.quarkus.kafka.testing;

import de.id.quarkus.kafka.testing.ConfluentSchemaRegistryContainer;
import de.id.quarkus.kafka.testing.ConfluentStackClient;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.utility.DockerImageName;

public class ConfluentStack
implements QuarkusTestResourceLifecycleManager {
    public static final String CONFLUENT_VERSION_ARG = "confluentVersion";
    public static final String CONFLUENT_VERSION_DEFAULT = "5.4.3";
    private DockerImageName kafkaImage;
    private DockerImageName registryImage;
    String kafkaNetworkAlias = "kafka";
    Network network;
    KafkaContainer kafka;
    ConfluentSchemaRegistryContainer schemaRegistry;
    ConfluentStackClient testClusterClient;

    public void init(Map<String, String> initArgs) {
        String confluentVersion = initArgs.getOrDefault(CONFLUENT_VERSION_ARG, CONFLUENT_VERSION_DEFAULT);
        this.kafkaImage = DockerImageName.parse((String)String.format("confluentinc/cp-kafka:%s", confluentVersion));
        this.registryImage = DockerImageName.parse((String)String.format("confluentinc/cp-schema-registry:%s", confluentVersion));
    }

    public Map<String, String> start() {
        this.network = Network.newNetwork();
        this.kafka = (KafkaContainer)((KafkaContainer)new KafkaContainer(this.kafkaImage).withNetwork(this.network)).withNetworkAliases(new String[]{this.kafkaNetworkAlias});
        this.kafka.start();
        String dockerNetworkKafkaConnectString = String.format("%s:%d", this.kafkaNetworkAlias, 9092);
        this.schemaRegistry = (ConfluentSchemaRegistryContainer)new ConfluentSchemaRegistryContainer(this.registryImage, dockerNetworkKafkaConnectString).withNetwork(this.network);
        this.schemaRegistry.start();
        this.testClusterClient = new ConfluentStackClient(this.kafka.getBootstrapServers(), this.schemaRegistry.getUrl());
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("kafka.bootstrap.servers", this.kafka.getBootstrapServers());
        properties.put("mp.messaging.connector.smallrye-kafka.schema.registry.url", this.schemaRegistry.getUrl());
        return properties;
    }

    public void inject(Object testInstance) {
        this.testClusterClient.deleteAllConsumerGroups();
        this.testClusterClient.deleteAllTopics();
        this.injectClientInTestInstance(testInstance);
    }

    private void injectClientInTestInstance(Object testInstance) {
        Stream.of(testInstance.getClass(), testInstance.getClass().getSuperclass()).filter(Objects::nonNull).flatMap(clazz -> Arrays.stream(clazz.getDeclaredFields())).filter(field -> field.getType().equals(ConfluentStackClient.class)).forEach(field -> {
            field.setAccessible(true);
            try {
                field.set(testInstance, this.testClusterClient);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(String.format("Error while injecting %s to instance %s", ConfluentStackClient.class.getName(), testInstance), e);
            }
        });
    }

    public void stop() {
        this.kafka.close();
        this.schemaRegistry.close();
    }
}

