/*
 * Decompiled with CFR 0.152.
 */
package de.id.quarkus.kafka.testing;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class ConfluentSchemaRegistryContainer
extends GenericContainer<ConfluentSchemaRegistryContainer> {
    private static final int SCHEMA_REGISTRY_INTERNAL_PORT = 8081;
    private static final String NETWORK_ALIAS = "schema-registry";

    public ConfluentSchemaRegistryContainer(DockerImageName dockerImageName, String internalKafkaConnectString) {
        super(dockerImageName);
        this.addEnv("SCHEMA_REGISTRY_KAFKASTORE_BOOTSTRAP_SERVERS", internalKafkaConnectString);
        this.addEnv("SCHEMA_REGISTRY_HOST_NAME", "localhost");
        this.withExposedPorts(new Integer[]{8081});
        this.withNetworkAliases(new String[]{NETWORK_ALIAS});
        this.waitingFor((WaitStrategy)Wait.forHttp((String)"/subjects"));
    }

    public String getUrl() {
        return String.format("http://%s:%d", this.getContainerIpAddress(), this.getMappedPort(8081));
    }
}

