/*
 * Decompiled with CFR 0.152.
 */
package de.ipb_halle.molecularfaces.component.openvectoreditor;

import de.ipb_halle.molecularfaces.component.openvectoreditor.OpenVectorEditorCore;
import de.ipb_halle.molecularfaces.util.RendererUtils;
import jakarta.faces.application.Resource;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.render.FacesRenderer;
import jakarta.faces.render.Renderer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

@FacesRenderer(rendererType="molecularfaces.OpenVectorEditorRenderer", componentFamily="molecularfaces.OpenVectorEditorFamily")
public class OpenVectorEditorRenderer
extends Renderer {
    private static final Logger LOGGER = Logger.getLogger(OpenVectorEditorRenderer.class.getName());
    public static final String RENDERER_TYPE = "molecularfaces.OpenVectorEditorRenderer";
    private String loaderJSVar = "molecularfaces.openVectorEditorLoaderInstance";

    public void decode(FacesContext context, UIComponent component) {
        OpenVectorEditorCore plugin = (OpenVectorEditorCore)component;
        if (!plugin.isReadonly()) {
            RendererUtils.decodeComponent(context, plugin);
        }
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return RendererUtils.convertSubmittedValueToObject(context, component, submittedValue);
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        OpenVectorEditorCore plugin = (OpenVectorEditorCore)component;
        if (!plugin.isRendered()) {
            return;
        }
        String clientId = plugin.getClientId();
        String hiddenInputId = clientId + "_Input";
        String iframeId = clientId + "_Iframe";
        String editorTargetDivId = clientId + "_OpenVectorEditor";
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)plugin);
        writer.writeAttribute("id", (Object)clientId, null);
        this.encodeHiddenInput(context, writer, plugin, hiddenInputId);
        this.encodeJS(writer, plugin, editorTargetDivId, iframeId, hiddenInputId);
        this.encodeIframe(context, writer, plugin, editorTargetDivId, iframeId, hiddenInputId);
        writer.endElement("div");
    }

    private void encodeHiddenInput(FacesContext context, ResponseWriter writer, OpenVectorEditorCore plugin, String hiddenInputId) throws IOException {
        String value = RendererUtils.convertValueToString(context, plugin, plugin.getValue());
        writer.startElement("input", (UIComponent)plugin);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)hiddenInputId, null);
        if (!plugin.isReadonly()) {
            writer.writeAttribute("name", (Object)plugin.getClientId(), null);
        }
        writer.writeAttribute("value", (Object)value, "value");
        writer.endElement("input");
    }

    private void encodeJS(ResponseWriter writer, OpenVectorEditorCore plugin, String editorTargetDivId, String iframeId, String hiddenInputId) throws IOException {
        String jsCode = this.generateJSCode(plugin, editorTargetDivId, iframeId, hiddenInputId);
        this.writeScriptTag(jsCode, plugin, writer);
    }

    private void writeScriptTag(String jsCode, OpenVectorEditorCore plugin, ResponseWriter writer) throws IOException {
        writer.startElement("script", (UIComponent)plugin);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)jsCode, null);
        writer.endElement("script");
    }

    private void encodeIframe(FacesContext context, ResponseWriter writer, OpenVectorEditorCore plugin, String editorTargetDivId, String iframeId, String hiddenInputId) throws IOException {
        writer.startElement("iframe", (UIComponent)plugin);
        writer.writeAttribute("id", (Object)iframeId, null);
        writer.writeAttribute("style", (Object)"border:none;", null);
        writer.writeAttribute("srcdoc", (Object)this.generateIframeSrcdocHTML(context, plugin, editorTargetDivId), null);
        writer.writeText((Object)"Your browser does not support iframes.", null);
        writer.endElement("iframe");
    }

    private String generateIframeSrcdocHTML(FacesContext context, OpenVectorEditorCore plugin, String editorTargetDivId) throws IOException {
        StringBuilder sb = new StringBuilder(256);
        sb.append("<html><head>");
        sb.append(this.renderCssResourcesFromFacet(context, plugin));
        sb.append("</head><body>");
        sb.append(this.renderScriptResourcesFromFacet(context, plugin));
        sb.append("<div id=\"").append(editorTargetDivId).append("\"></div>");
        sb.append("</body></html>");
        return sb.toString();
    }

    private String renderCssResourcesFromFacet(FacesContext context, OpenVectorEditorCore plugin) throws IOException {
        return this.encodeResourceComponents(context, this.getChildrenFromFacet("molecularfaces.resourceloader.stylesheet", (UIComponent)plugin));
    }

    private String renderScriptResourcesFromFacet(FacesContext context, OpenVectorEditorCore plugin) throws IOException {
        return this.encodeResourceComponents(context, this.getChildrenFromFacet("molecularfaces.resourceloader.javascript", (UIComponent)plugin));
    }

    private List<UIComponent> getChildrenFromFacet(String facetName, UIComponent component) {
        UIComponent facet = component.getFacet(facetName);
        if (facet == null) {
            return Collections.emptyList();
        }
        return facet.getChildren();
    }

    private String encodeResourceComponents(FacesContext context, List<UIComponent> components) throws IOException {
        if (components.isEmpty()) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        ResponseWriter newWriter = context.getResponseWriter().cloneWithWriter((Writer)stringWriter);
        for (UIComponent comp : components) {
            if (Boolean.FALSE.equals(comp.getAttributes().get("external"))) {
                this.encodeResourceFromJSFResourceLibrary(context, newWriter, comp);
                continue;
            }
            this.encodeResourceFromExt(context, newWriter, comp);
        }
        return stringWriter.toString();
    }

    private void encodeResourceFromJSFResourceLibrary(FacesContext context, ResponseWriter writer, UIComponent component) throws IOException {
        Map attributes = component.getAttributes();
        String resourceName = (String)attributes.get("name");
        String library = (String)attributes.get("library");
        if (resourceName == null || resourceName.isEmpty()) {
            return;
        }
        Resource resource = context.getApplication().getResourceHandler().createResource(resourceName, library);
        if (resource == null) {
            LOGGER.warning("Resource not found: resourceName=" + resourceName + (String)(library != null ? ", library=" + library : ""));
            return;
        }
        String path = resource.getRequestPath();
        String url = context.getExternalContext().encodeResourceURL(path);
        this.encodeResource(writer, component, url);
    }

    private void encodeResourceFromExt(FacesContext context, ResponseWriter writer, UIComponent component) throws IOException {
        String url = (String)component.getAttributes().get("name");
        this.encodeResource(writer, component, url);
    }

    private void encodeResource(ResponseWriter writer, UIComponent component, String url) throws IOException {
        if (component.getRendererType().equals("jakarta.faces.resource.Script")) {
            this.encodeScriptInclude(writer, component, url);
        } else if (component.getRendererType().equals("jakarta.faces.resource.Stylesheet")) {
            this.encodeStylesheetInclude(writer, component, url);
        }
    }

    private void encodeScriptInclude(ResponseWriter writer, UIComponent component, String url) throws IOException {
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeURIAttribute("src", (Object)url, null);
        writer.endElement("script");
    }

    private void encodeStylesheetInclude(ResponseWriter writer, UIComponent component, String url) throws IOException {
        writer.startElement("link", component);
        writer.writeAttribute("rel", (Object)"stylesheet", null);
        writer.writeAttribute("type", (Object)"text/css", null);
        writer.writeURIAttribute("href", (Object)url, null);
        writer.endElement("link");
    }

    private String generateJSCode(OpenVectorEditorCore plugin, String editorTargetDivId, String iframeId, String hiddenInputId) {
        StringBuilder sb = new StringBuilder(512);
        sb.append((CharSequence)plugin.getResourceLoader().encodeLoadExtResources(this.loaderJSVar));
        Formatter fmt = new Formatter(sb);
        String widgetVar = plugin.getWidgetVar();
        if (widgetVar != null && !widgetVar.isEmpty()) {
            fmt.format("var %s = ", widgetVar);
        }
        fmt.format("%s.status().then(() => {", this.loaderJSVar);
        fmt.format("let valueAsText = document.getElementById(\"%s\").getAttribute(\"value\");", hiddenInputId);
        fmt.format("let valueAsJSON = {};", new Object[0]);
        fmt.format("if (!(!valueAsText || valueAsText.length === 0)) {", new Object[0]);
        fmt.format("try { valueAsJSON = JSON.parse(valueAsText); }", new Object[0]);
        fmt.format("catch(e) { console.error(\"%s\" + e); }", "Could not parse JSON input: ");
        fmt.format("}", new Object[0]);
        fmt.format("let editorPromise = molecularfaces.OpenVectorEditor.newEditor(\"%s\", \"%s\", valueAsJSON, %b);", editorTargetDivId, iframeId, plugin.isReadonly());
        fmt.format("editorPromise.then(editor => editor.getOnChangeSubject().addChangeCallback((sequence) => { document.getElementById(\"%s\").setAttribute(\"value\", JSON.stringify(sequence)); }));", hiddenInputId);
        fmt.close();
        sb.append("return editorPromise;");
        sb.append("});");
        return sb.toString();
    }
}

