/*
 * Decompiled with CFR 0.152.
 */
package de.ipb_halle.molecularfaces;

import de.ipb_halle.molecularfaces.MolPluginCore;
import java.io.IOException;
import java.util.Formatter;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;
import javax.faces.render.Renderer;

@FacesRenderer(rendererType="molecularfaces.MarvinJSRenderer", componentFamily="molecularfaces.MolPluginFamily")
public class MarvinJSRenderer
extends Renderer {
    public static final String RENDERER_TYPE = "molecularfaces.MarvinJSRenderer";
    private String loaderJSVar = "molecularfaces.marvinJSLoaderInstance";

    public void decode(FacesContext context, UIComponent component) {
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        MolPluginCore plugin = (MolPluginCore)component;
        if (!plugin.isReadonly()) {
            String clientId = plugin.getClientId(context);
            String value = (String)requestMap.get(clientId);
            plugin.setSubmittedValue(value);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        MolPluginCore plugin = (MolPluginCore)component;
        if (!plugin.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)plugin);
        writer.writeAttribute("id", (Object)plugin.getClientId(), null);
        writer.writeAttribute("style", (Object)this.generateDivStyle(plugin), null);
        if (plugin.isReadonly()) {
            this.encodeViewer(context, writer, plugin);
        } else {
            this.encodeEditor(context, writer, plugin);
        }
        writer.endElement("div");
    }

    private void encodeViewer(FacesContext context, ResponseWriter writer, MolPluginCore plugin) throws IOException {
        String divId = plugin.getClientId() + "_MarvinJSViewer";
        this.encodeViewerHTML(writer, plugin, divId);
        this.encodeViewerJS(context, writer, plugin, divId);
    }

    private void encodeViewerHTML(ResponseWriter writer, MolPluginCore plugin, String divId) throws IOException {
        writer.startElement("div", (UIComponent)plugin);
        writer.writeAttribute("id", (Object)divId, null);
        writer.writeAttribute("style", (Object)this.generateDivStyle(plugin), null);
        writer.endElement("div");
    }

    private void encodeViewerJS(FacesContext context, ResponseWriter writer, MolPluginCore plugin, String divId) throws IOException {
        String escapedMolecule = this.escape((String)plugin.getValue());
        writer.startElement("script", (UIComponent)plugin);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String installPath = context.getExternalContext().getInitParameter("de.ipb_halle.molecularfaces.MARVINJS_BASE_URL");
        if (installPath == null) {
            installPath = "";
        }
        StringBuilder sb = new StringBuilder(512 + installPath.length() + escapedMolecule.length());
        sb.append((CharSequence)plugin.encodeLoadExtResources(this.loaderJSVar));
        Formatter fmt = new Formatter(sb);
        String widgetVar = plugin.getWidgetVar();
        if (widgetVar != null && !widgetVar.isEmpty()) {
            fmt.format("var %s = ", widgetVar);
        }
        fmt.format("%s.status().then(() => {", this.loaderJSVar);
        fmt.format("return molecularfaces.MarvinJSViewer.newViewer(\"%s\", \"%s\", \"%s\", %d, %d);", divId, escapedMolecule, installPath, plugin.getHeight(), plugin.getWidth());
        fmt.close();
        sb.append("});");
        writer.writeText((Object)sb, null);
        writer.endElement("script");
    }

    private void encodeEditor(FacesContext context, ResponseWriter writer, MolPluginCore plugin) throws IOException {
        String clientId = plugin.getClientId();
        String hiddenInputId = clientId + "_Input";
        String iframeId = clientId + "_MarvinJSEditor";
        this.encodeEditorHTML(context, writer, plugin, iframeId, hiddenInputId);
        this.encodeEditorJS(context, writer, plugin, iframeId, hiddenInputId);
    }

    private void encodeEditorHTML(FacesContext context, ResponseWriter writer, MolPluginCore plugin, String iframeId, String hiddenInputId) throws IOException {
        writer.startElement("iframe", (UIComponent)plugin);
        writer.writeAttribute("id", (Object)iframeId, null);
        writer.writeAttribute("src", (Object)(context.getExternalContext().getInitParameter("de.ipb_halle.molecularfaces.MARVINJS_BASE_URL") + "/editor.html"), null);
        writer.writeAttribute("style", (Object)("height:" + plugin.getHeight() + "px;width:" + plugin.getWidth() + "px;"), null);
        writer.endElement("iframe");
        writer.startElement("input", (UIComponent)plugin);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)hiddenInputId, null);
        writer.writeAttribute("name", (Object)plugin.getClientId(), null);
        writer.writeAttribute("value", plugin.getValue(), "value");
        writer.endElement("input");
    }

    private void encodeEditorJS(FacesContext context, ResponseWriter writer, MolPluginCore plugin, String iframeId, String hiddenInputId) throws IOException {
        String license;
        writer.startElement("script", (UIComponent)plugin);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String installPath = context.getExternalContext().getInitParameter("de.ipb_halle.molecularfaces.MARVINJS_BASE_URL");
        if (installPath == null) {
            installPath = "";
        }
        if ((license = context.getExternalContext().getInitParameter("de.ipb_halle.molecularfaces.MARVINJS_LICENSE_URL")) == null) {
            license = "";
        }
        StringBuilder sb = new StringBuilder(512 + installPath.length() + license.length());
        sb.append((CharSequence)plugin.encodeLoadExtResources(this.loaderJSVar));
        Formatter fmt = new Formatter(sb);
        String widgetVar = plugin.getWidgetVar();
        if (widgetVar != null && !widgetVar.isEmpty()) {
            fmt.format("var %s = ", widgetVar);
        }
        fmt.format("%s.status().then(() => {", this.loaderJSVar);
        fmt.format("return molecularfaces.MarvinJSEditor.newEditor(\"%s\", document.getElementById(\"%s\").getAttribute(\"value\"), \"%s\", \"%s\", %d, %d)", iframeId, hiddenInputId, installPath, license, plugin.getHeight(), plugin.getWidth());
        fmt.format(".then((editor) => editor.addChangeListener((mol) => { document.getElementById(\"%s\").setAttribute(\"value\", mol); }));", hiddenInputId);
        fmt.close();
        sb.append("});");
        writer.writeText((Object)sb, null);
        writer.endElement("script");
    }

    private String generateDivStyle(MolPluginCore plugin) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("width:").append(plugin.getWidth()).append("px;");
        sb.append("height:").append(plugin.getHeight()).append("px;");
        if (plugin.isBorder()) {
            sb.append("border:solid;border-width:1px;");
        }
        return sb.toString();
    }

    private String escape(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "");
    }
}

