/*
 * Decompiled with CFR 0.152.
 */
package de.intension.keycloak.test;

import dasniko.testcontainers.keycloak.KeycloakContainer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.SelinuxContext;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.shaded.com.google.common.cache.Cache;
import org.testcontainers.shaded.com.google.common.cache.CacheBuilder;
import org.testcontainers.utility.MountableFile;

public class KeycloakDevContainer
extends KeycloakContainer {
    private boolean classFolderChangeTrackingEnabled;
    private String deployableJarName;

    public KeycloakDevContainer() {
        super("quay.io/keycloak/keycloak:12.0.2");
    }

    public KeycloakDevContainer(String deployableJarName) {
        this();
        this.deployableJarName = deployableJarName;
    }

    public KeycloakContainer withFixedExposedPort(int hostPort, int containerPort) {
        super.addFixedExposedPort(hostPort, containerPort);
        return (KeycloakContainer)this.self();
    }

    protected void configure() {
        super.configure();
        this.withExposedPorts(new Integer[]{8080, 8443, 8787});
        this.withCommand(new String[]{"-c standalone.xml", "-Dkeycloak.profile.feature.upload_scripts=enabled", "-Dwildfly.statistics-enabled=true", "--debug *:8787"});
        if (this.deployableJarName == null) {
            return;
        }
        String explodedFolderExtensionsJar = "/opt/jboss/keycloak/standalone/deployments/extensions.jar";
        String deploymentTriggerFile = explodedFolderExtensionsJar + ".dodeploy";
        String classesLocation = MountableFile.forClasspathResource((String)".").getResolvedPath() + "../" + this.deployableJarName + ".jar";
        this.addFileSystemBind(classesLocation, explodedFolderExtensionsJar, BindMode.READ_WRITE, SelinuxContext.SINGLE);
        this.withClasspathResourceMapping("dodeploy", deploymentTriggerFile, BindMode.READ_ONLY);
        if (this.isClassFolderChangeTrackingEnabled()) {
            this.registerClassFolderWatcher(Paths.get(classesLocation, new String[0]).normalize(), Set.of(new File(deploymentTriggerFile).getName()), watchEvent -> {
                System.out.println("Detected change... trigger redeployment. changed file: " + watchEvent.context());
                this.copyFileToContainer(Transferable.of((byte[])"true".getBytes(StandardCharsets.UTF_8)), deploymentTriggerFile);
                System.out.println("Redeployment triggered");
            });
        }
    }

    private void registerClassFolderWatcher(Path classPath, Set<String> excludes, Consumer<WatchEvent<Path>> onChange) {
        Set watchList = Collections.newSetFromMap(new ConcurrentHashMap());
        try {
            WatchService watcher = FileSystems.getDefault().newWatchService();
            Cache seen = CacheBuilder.newBuilder().expireAfterWrite(500L, TimeUnit.MILLISECONDS).build();
            Executors.newSingleThreadExecutor().execute(() -> {
                while (true) {
                    try {
                        WatchKey key;
                        boolean valid;
                        block3: do {
                            this.registerFileWatcherRecursively(watchList, watcher, classPath);
                            key = watcher.take();
                            for (WatchEvent<?> event : key.pollEvents()) {
                                WatchEvent<?> ev;
                                Path contextPath;
                                String filename;
                                WatchEvent.Kind<?> kind = event.kind();
                                if (kind == StandardWatchEventKinds.OVERFLOW || excludes.contains(filename = (contextPath = (Path)(ev = event).context()).getName(0).toString()) || !filename.endsWith(".class") || seen.getIfPresent((Object)filename) != null) continue;
                                seen.put((Object)filename, (Object)Boolean.TRUE);
                                onChange.accept(ev);
                                continue block3;
                            }
                        } while (valid = key.reset());
                        System.out.println("Watch key no longer valid, exiting...");
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void registerFileWatcherRecursively(final Set<String> watchList, final WatchService watcher, Path classesPath) throws IOException {
        Files.walkFileTree(classesPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                String absolutePath = dir.toFile().getAbsolutePath();
                if (watchList.contains(absolutePath)) {
                    return FileVisitResult.CONTINUE;
                }
                dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public boolean isClassFolderChangeTrackingEnabled() {
        return this.classFolderChangeTrackingEnabled;
    }

    public KeycloakDevContainer withClassFolderChangeTrackingEnabled(boolean classFolderChangeTrackingEnabled) {
        this.classFolderChangeTrackingEnabled = classFolderChangeTrackingEnabled;
        return this;
    }
}

