/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import org.apache.commons.lang3.ObjectUtils;

public class GetProcess {
    @SerializedName(value="id")
    private Long id = null;
    @SerializedName(value="status")
    private StatusEnum status = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="export_url")
    private String exportUrl = null;

    public GetProcess id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="145", required=true, value="Id of the process")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public GetProcess status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="queued", required=true, value="Status of the process")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public GetProcess name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="IMPORTUSER", required=true, value="Process name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GetProcess exportUrl(String exportUrl) {
        this.exportUrl = exportUrl;
        return this;
    }

    @ApiModelProperty(example="http://requestb.in/16ua3aj1", value="URL on which send export the of contacts once the process is completed")
    public String getExportUrl() {
        return this.exportUrl;
    }

    public void setExportUrl(String exportUrl) {
        this.exportUrl = exportUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetProcess getProcess = (GetProcess)o;
        return ObjectUtils.equals(this.id, getProcess.id) && ObjectUtils.equals((Object)this.status, (Object)getProcess.status) && ObjectUtils.equals(this.name, getProcess.name) && ObjectUtils.equals(this.exportUrl, getProcess.exportUrl);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti(new Object[]{this.id, this.status, this.name, this.exportUrl});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetProcess {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    exportUrl: ").append(this.toIndentedString(this.exportUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        QUEUED("queued"),
        IN_PROCESS("in_process"),
        COMPLETED("completed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            @Override
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

