/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import org.apache.commons.lang3.ObjectUtils;
import org.threeten.bp.OffsetDateTime;

public class GetCampaignOverview {
    @SerializedName(value="id")
    private Long id = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="subject")
    private String subject = null;
    @SerializedName(value="type")
    private TypeEnum type = null;
    @SerializedName(value="status")
    private StatusEnum status = null;
    @SerializedName(value="scheduledAt")
    private OffsetDateTime scheduledAt = null;
    @SerializedName(value="abTesting")
    private Boolean abTesting = null;
    @SerializedName(value="subjectA")
    private String subjectA = null;
    @SerializedName(value="subjectB")
    private String subjectB = null;
    @SerializedName(value="splitRule")
    private Integer splitRule = null;
    @SerializedName(value="winnerCriteria")
    private String winnerCriteria = null;
    @SerializedName(value="winnerDelay")
    private Integer winnerDelay = null;
    @SerializedName(value="sendAtBestTime")
    private Boolean sendAtBestTime = null;

    public GetCampaignOverview id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="12", required=true, value="ID of the campaign")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public GetCampaignOverview name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="EN - Sales Summer 2017", required=true, value="Name of the campaign")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GetCampaignOverview subject(String subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(example="20% OFF for 2017 Summer Sales", value="Subject of the campaign. Only available if `abTesting` flag of the campaign is `false`")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public GetCampaignOverview type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="classic", required=true, value="Type of campaign")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public GetCampaignOverview status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="sent", required=true, value="Status of the campaign")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public GetCampaignOverview scheduledAt(OffsetDateTime scheduledAt) {
        this.scheduledAt = scheduledAt;
        return this;
    }

    @ApiModelProperty(example="2017-06-01T12:30:00Z", value="UTC date-time on which campaign is scheduled (YYYY-MM-DDTHH:mm:ss.SSSZ)")
    public OffsetDateTime getScheduledAt() {
        return this.scheduledAt;
    }

    public void setScheduledAt(OffsetDateTime scheduledAt) {
        this.scheduledAt = scheduledAt;
    }

    public GetCampaignOverview abTesting(Boolean abTesting) {
        this.abTesting = abTesting;
        return this;
    }

    @ApiModelProperty(example="true", value="Status of A/B Test for the campaign. abTesting = false means it is disabled, & abTesting = true means it is enabled.")
    public Boolean isAbTesting() {
        return this.abTesting;
    }

    public void setAbTesting(Boolean abTesting) {
        this.abTesting = abTesting;
    }

    public GetCampaignOverview subjectA(String subjectA) {
        this.subjectA = subjectA;
        return this;
    }

    @ApiModelProperty(example="Discover the New Collection!", value="Subject A of the ab-test campaign. Only available if `abTesting` flag of the campaign is `true`")
    public String getSubjectA() {
        return this.subjectA;
    }

    public void setSubjectA(String subjectA) {
        this.subjectA = subjectA;
    }

    public GetCampaignOverview subjectB(String subjectB) {
        this.subjectB = subjectB;
        return this;
    }

    @ApiModelProperty(example="Want to discover the New Collection?", value="Subject B of the ab-test campaign. Only available if `abTesting` flag of the campaign is `true`")
    public String getSubjectB() {
        return this.subjectB;
    }

    public void setSubjectB(String subjectB) {
        this.subjectB = subjectB;
    }

    public GetCampaignOverview splitRule(Integer splitRule) {
        this.splitRule = splitRule;
        return this;
    }

    @ApiModelProperty(example="25", value="The size of your ab-test groups. Only available if `abTesting` flag of the campaign is `true`")
    public Integer getSplitRule() {
        return this.splitRule;
    }

    public void setSplitRule(Integer splitRule) {
        this.splitRule = splitRule;
    }

    public GetCampaignOverview winnerCriteria(String winnerCriteria) {
        this.winnerCriteria = winnerCriteria;
        return this;
    }

    @ApiModelProperty(example="open", value="Criteria for the winning version. Only available if `abTesting` flag of the campaign is `true`")
    public String getWinnerCriteria() {
        return this.winnerCriteria;
    }

    public void setWinnerCriteria(String winnerCriteria) {
        this.winnerCriteria = winnerCriteria;
    }

    public GetCampaignOverview winnerDelay(Integer winnerDelay) {
        this.winnerDelay = winnerDelay;
        return this;
    }

    @ApiModelProperty(example="50", value="The duration of the test in hours at the end of which the winning version will be sent. Only available if `abTesting` flag of the campaign is `true`")
    public Integer getWinnerDelay() {
        return this.winnerDelay;
    }

    public void setWinnerDelay(Integer winnerDelay) {
        this.winnerDelay = winnerDelay;
    }

    public GetCampaignOverview sendAtBestTime(Boolean sendAtBestTime) {
        this.sendAtBestTime = sendAtBestTime;
        return this;
    }

    @ApiModelProperty(example="true", value="It is true if you have chosen to send your campaign at best time, otherwise it is false")
    public Boolean isSendAtBestTime() {
        return this.sendAtBestTime;
    }

    public void setSendAtBestTime(Boolean sendAtBestTime) {
        this.sendAtBestTime = sendAtBestTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetCampaignOverview getCampaignOverview = (GetCampaignOverview)o;
        return ObjectUtils.equals(this.id, getCampaignOverview.id) && ObjectUtils.equals(this.name, getCampaignOverview.name) && ObjectUtils.equals(this.subject, getCampaignOverview.subject) && ObjectUtils.equals((Object)this.type, (Object)getCampaignOverview.type) && ObjectUtils.equals((Object)this.status, (Object)getCampaignOverview.status) && ObjectUtils.equals(this.scheduledAt, getCampaignOverview.scheduledAt) && ObjectUtils.equals(this.abTesting, getCampaignOverview.abTesting) && ObjectUtils.equals(this.subjectA, getCampaignOverview.subjectA) && ObjectUtils.equals(this.subjectB, getCampaignOverview.subjectB) && ObjectUtils.equals(this.splitRule, getCampaignOverview.splitRule) && ObjectUtils.equals(this.winnerCriteria, getCampaignOverview.winnerCriteria) && ObjectUtils.equals(this.winnerDelay, getCampaignOverview.winnerDelay) && ObjectUtils.equals(this.sendAtBestTime, getCampaignOverview.sendAtBestTime);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti(new Object[]{this.id, this.name, this.subject, this.type, this.status, this.scheduledAt, this.abTesting, this.subjectA, this.subjectB, this.splitRule, this.winnerCriteria, this.winnerDelay, this.sendAtBestTime});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetCampaignOverview {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    scheduledAt: ").append(this.toIndentedString(this.scheduledAt)).append("\n");
        sb.append("    abTesting: ").append(this.toIndentedString(this.abTesting)).append("\n");
        sb.append("    subjectA: ").append(this.toIndentedString(this.subjectA)).append("\n");
        sb.append("    subjectB: ").append(this.toIndentedString(this.subjectB)).append("\n");
        sb.append("    splitRule: ").append(this.toIndentedString(this.splitRule)).append("\n");
        sb.append("    winnerCriteria: ").append(this.toIndentedString(this.winnerCriteria)).append("\n");
        sb.append("    winnerDelay: ").append(this.toIndentedString(this.winnerDelay)).append("\n");
        sb.append("    sendAtBestTime: ").append(this.toIndentedString(this.sendAtBestTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        DRAFT("draft"),
        SENT("sent"),
        ARCHIVE("archive"),
        QUEUED("queued"),
        SUSPENDED("suspended"),
        IN_PROCESS("in_process");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            @Override
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        CLASSIC("classic"),
        TRIGGER("trigger");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            @Override
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

