/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

public class CreateDoiContact {
    @SerializedName(value="email")
    private String email = null;
    @SerializedName(value="attributes")
    private Object attributes = null;
    @SerializedName(value="includeListIds")
    private List<Long> includeListIds = new ArrayList<Long>();
    @SerializedName(value="excludeListIds")
    private List<Long> excludeListIds = null;
    @SerializedName(value="templateId")
    private Long templateId = null;
    @SerializedName(value="redirectionUrl")
    private String redirectionUrl = null;

    public CreateDoiContact email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(example="elly@example.com", required=true, value="Email address where the confirmation email will be sent. This email address will be the identifier for all other contact attributes.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public CreateDoiContact attributes(Object attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(example="{\"FNAME\":\"Elly\",\"LNAME\":\"Roger\"}", value="Pass the set of attributes and their values. These attributes must be present in your SendinBlue account. For eg. {'FNAME':'Elly', 'LNAME':'Roger'}")
    public Object getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Object attributes) {
        this.attributes = attributes;
    }

    public CreateDoiContact includeListIds(List<Long> includeListIds) {
        this.includeListIds = includeListIds;
        return this;
    }

    public CreateDoiContact addIncludeListIdsItem(Long includeListIdsItem) {
        this.includeListIds.add(includeListIdsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Lists under user account where contact should be added")
    public List<Long> getIncludeListIds() {
        return this.includeListIds;
    }

    public void setIncludeListIds(List<Long> includeListIds) {
        this.includeListIds = includeListIds;
    }

    public CreateDoiContact excludeListIds(List<Long> excludeListIds) {
        this.excludeListIds = excludeListIds;
        return this;
    }

    public CreateDoiContact addExcludeListIdsItem(Long excludeListIdsItem) {
        if (this.excludeListIds == null) {
            this.excludeListIds = new ArrayList<Long>();
        }
        this.excludeListIds.add(excludeListIdsItem);
        return this;
    }

    @ApiModelProperty(value="Lists under user account where contact should not be added")
    public List<Long> getExcludeListIds() {
        return this.excludeListIds;
    }

    public void setExcludeListIds(List<Long> excludeListIds) {
        this.excludeListIds = excludeListIds;
    }

    public CreateDoiContact templateId(Long templateId) {
        this.templateId = templateId;
        return this;
    }

    @ApiModelProperty(example="2", required=true, value="Id of the Double opt-in (DOI) template")
    public Long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public CreateDoiContact redirectionUrl(String redirectionUrl) {
        this.redirectionUrl = redirectionUrl;
        return this;
    }

    @ApiModelProperty(example="http://requestb.in/173lyyx1", required=true, value="URL of the web page that user will be redirected to after clicking on the double opt in URL. When editing your DOI template you can reference this URL by using the tag {{ params.DOIurl }}.")
    public String getRedirectionUrl() {
        return this.redirectionUrl;
    }

    public void setRedirectionUrl(String redirectionUrl) {
        this.redirectionUrl = redirectionUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateDoiContact createDoiContact = (CreateDoiContact)o;
        return ObjectUtils.equals(this.email, createDoiContact.email) && ObjectUtils.equals(this.attributes, createDoiContact.attributes) && ObjectUtils.equals(this.includeListIds, createDoiContact.includeListIds) && ObjectUtils.equals(this.excludeListIds, createDoiContact.excludeListIds) && ObjectUtils.equals(this.templateId, createDoiContact.templateId) && ObjectUtils.equals(this.redirectionUrl, createDoiContact.redirectionUrl);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti(this.email, this.attributes, this.includeListIds, this.excludeListIds, this.templateId, this.redirectionUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateDoiContact {\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    includeListIds: ").append(this.toIndentedString(this.includeListIds)).append("\n");
        sb.append("    excludeListIds: ").append(this.toIndentedString(this.excludeListIds)).append("\n");
        sb.append("    templateId: ").append(this.toIndentedString(this.templateId)).append("\n");
        sb.append("    redirectionUrl: ").append(this.toIndentedString(this.redirectionUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

