/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import org.apache.commons.lang3.ObjectUtils;

public class CreateChild {
    @SerializedName(value="email")
    private String email = null;
    @SerializedName(value="firstName")
    private String firstName = null;
    @SerializedName(value="lastName")
    private String lastName = null;
    @SerializedName(value="companyName")
    private String companyName = null;
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="language")
    private LanguageEnum language = null;

    public CreateChild email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(example="josh.cruise@example.com", required=true, value="Email address to create the child account")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public CreateChild firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(example="Josh", required=true, value="First name to use to create the child account")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public CreateChild lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(example="Cruise", required=true, value="Last name to use to create the child account")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public CreateChild companyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    @ApiModelProperty(example="Your Company", required=true, value="Company name to use to create the child account")
    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public CreateChild password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(example="Pa55w0rd65", required=true, value="Password for the child account to login")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public CreateChild language(LanguageEnum language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(example="en", value="Language of the child account")
    public LanguageEnum getLanguage() {
        return this.language;
    }

    public void setLanguage(LanguageEnum language) {
        this.language = language;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateChild createChild = (CreateChild)o;
        return ObjectUtils.equals(this.email, createChild.email) && ObjectUtils.equals(this.firstName, createChild.firstName) && ObjectUtils.equals(this.lastName, createChild.lastName) && ObjectUtils.equals(this.companyName, createChild.companyName) && ObjectUtils.equals(this.password, createChild.password) && ObjectUtils.equals((Object)this.language, (Object)createChild.language);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti(new Object[]{this.email, this.firstName, this.lastName, this.companyName, this.password, this.language});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateChild {\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    companyName: ").append(this.toIndentedString(this.companyName)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    language: ").append(this.toIndentedString((Object)this.language)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum LanguageEnum {
        FR("fr"),
        ES("es"),
        PT("pt"),
        IT("it"),
        DE("de"),
        EN("en");

        private String value;

        private LanguageEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static LanguageEnum fromValue(String text) {
            for (LanguageEnum b : LanguageEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<LanguageEnum> {
            @Override
            public void write(JsonWriter jsonWriter, LanguageEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public LanguageEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return LanguageEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

