/*
 * Decompiled with CFR 0.152.
 */
package sibApi;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.threeten.bp.OffsetDateTime;
import sendinblue.ApiCallback;
import sendinblue.ApiClient;
import sendinblue.ApiException;
import sendinblue.ApiResponse;
import sendinblue.Configuration;
import sendinblue.Pair;
import sendinblue.ProgressRequestBody;
import sendinblue.ProgressResponseBody;
import sibModel.CreateModel;
import sibModel.CreateSmsCampaign;
import sibModel.CreatedProcessId;
import sibModel.GetSmsCampaign;
import sibModel.GetSmsCampaigns;
import sibModel.RequestSmsRecipientExport;
import sibModel.SendReport;
import sibModel.SendTestSms;
import sibModel.UpdateCampaignStatus;
import sibModel.UpdateSmsCampaign;

public class SmsCampaignsApi {
    private ApiClient apiClient;

    public SmsCampaignsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SmsCampaignsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createSmsCampaignCall(CreateSmsCampaign createSmsCampaign, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateSmsCampaign localVarPostBody = createSmsCampaign;
        String localVarPath = "/smsCampaigns";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createSmsCampaignValidateBeforeCall(CreateSmsCampaign createSmsCampaign, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (createSmsCampaign == null) {
            throw new ApiException("Missing the required parameter 'createSmsCampaign' when calling createSmsCampaign(Async)");
        }
        Call call = this.createSmsCampaignCall(createSmsCampaign, progressListener, progressRequestListener);
        return call;
    }

    public CreateModel createSmsCampaign(CreateSmsCampaign createSmsCampaign) throws ApiException {
        ApiResponse<CreateModel> resp = this.createSmsCampaignWithHttpInfo(createSmsCampaign);
        return resp.getData();
    }

    public ApiResponse<CreateModel> createSmsCampaignWithHttpInfo(CreateSmsCampaign createSmsCampaign) throws ApiException {
        Call call = this.createSmsCampaignValidateBeforeCall(createSmsCampaign, null, null);
        Type localVarReturnType = new TypeToken<CreateModel>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createSmsCampaignAsync(CreateSmsCampaign createSmsCampaign, final ApiCallback<CreateModel> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createSmsCampaignValidateBeforeCall(createSmsCampaign, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreateModel>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteSmsCampaignCall(Long campaignId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/smsCampaigns/{campaignId}".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(campaignId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteSmsCampaignValidateBeforeCall(Long campaignId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (campaignId == null) {
            throw new ApiException("Missing the required parameter 'campaignId' when calling deleteSmsCampaign(Async)");
        }
        Call call = this.deleteSmsCampaignCall(campaignId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteSmsCampaign(Long campaignId) throws ApiException {
        this.deleteSmsCampaignWithHttpInfo(campaignId);
    }

    public ApiResponse<Void> deleteSmsCampaignWithHttpInfo(Long campaignId) throws ApiException {
        Call call = this.deleteSmsCampaignValidateBeforeCall(campaignId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteSmsCampaignAsync(Long campaignId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSmsCampaignValidateBeforeCall(campaignId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getSmsCampaignCall(Long campaignId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/smsCampaigns/{campaignId}".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(campaignId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSmsCampaignValidateBeforeCall(Long campaignId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (campaignId == null) {
            throw new ApiException("Missing the required parameter 'campaignId' when calling getSmsCampaign(Async)");
        }
        Call call = this.getSmsCampaignCall(campaignId, progressListener, progressRequestListener);
        return call;
    }

    public GetSmsCampaign getSmsCampaign(Long campaignId) throws ApiException {
        ApiResponse<GetSmsCampaign> resp = this.getSmsCampaignWithHttpInfo(campaignId);
        return resp.getData();
    }

    public ApiResponse<GetSmsCampaign> getSmsCampaignWithHttpInfo(Long campaignId) throws ApiException {
        Call call = this.getSmsCampaignValidateBeforeCall(campaignId, null, null);
        Type localVarReturnType = new TypeToken<GetSmsCampaign>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSmsCampaignAsync(Long campaignId, final ApiCallback<GetSmsCampaign> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSmsCampaignValidateBeforeCall(campaignId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetSmsCampaign>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getSmsCampaignsCall(String status, OffsetDateTime startDate, OffsetDateTime endDate, Long limit, Long offset, String sort, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/smsCampaigns";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (status != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", status));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSmsCampaignsValidateBeforeCall(String status, OffsetDateTime startDate, OffsetDateTime endDate, Long limit, Long offset, String sort, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getSmsCampaignsCall(status, startDate, endDate, limit, offset, sort, progressListener, progressRequestListener);
        return call;
    }

    public GetSmsCampaigns getSmsCampaigns(String status, OffsetDateTime startDate, OffsetDateTime endDate, Long limit, Long offset, String sort) throws ApiException {
        ApiResponse<GetSmsCampaigns> resp = this.getSmsCampaignsWithHttpInfo(status, startDate, endDate, limit, offset, sort);
        return resp.getData();
    }

    public ApiResponse<GetSmsCampaigns> getSmsCampaignsWithHttpInfo(String status, OffsetDateTime startDate, OffsetDateTime endDate, Long limit, Long offset, String sort) throws ApiException {
        Call call = this.getSmsCampaignsValidateBeforeCall(status, startDate, endDate, limit, offset, sort, null, null);
        Type localVarReturnType = new TypeToken<GetSmsCampaigns>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSmsCampaignsAsync(String status, OffsetDateTime startDate, OffsetDateTime endDate, Long limit, Long offset, String sort, final ApiCallback<GetSmsCampaigns> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSmsCampaignsValidateBeforeCall(status, startDate, endDate, limit, offset, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetSmsCampaigns>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call requestSmsRecipientExportCall(Long campaignId, RequestSmsRecipientExport recipientExport, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RequestSmsRecipientExport localVarPostBody = recipientExport;
        String localVarPath = "/smsCampaigns/{campaignId}/exportRecipients".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(campaignId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call requestSmsRecipientExportValidateBeforeCall(Long campaignId, RequestSmsRecipientExport recipientExport, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (campaignId == null) {
            throw new ApiException("Missing the required parameter 'campaignId' when calling requestSmsRecipientExport(Async)");
        }
        Call call = this.requestSmsRecipientExportCall(campaignId, recipientExport, progressListener, progressRequestListener);
        return call;
    }

    public CreatedProcessId requestSmsRecipientExport(Long campaignId, RequestSmsRecipientExport recipientExport) throws ApiException {
        ApiResponse<CreatedProcessId> resp = this.requestSmsRecipientExportWithHttpInfo(campaignId, recipientExport);
        return resp.getData();
    }

    public ApiResponse<CreatedProcessId> requestSmsRecipientExportWithHttpInfo(Long campaignId, RequestSmsRecipientExport recipientExport) throws ApiException {
        Call call = this.requestSmsRecipientExportValidateBeforeCall(campaignId, recipientExport, null, null);
        Type localVarReturnType = new TypeToken<CreatedProcessId>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call requestSmsRecipientExportAsync(Long campaignId, RequestSmsRecipientExport recipientExport, final ApiCallback<CreatedProcessId> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.requestSmsRecipientExportValidateBeforeCall(campaignId, recipientExport, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreatedProcessId>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call sendSmsCampaignNowCall(Long campaignId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/smsCampaigns/{campaignId}/sendNow".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(campaignId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call sendSmsCampaignNowValidateBeforeCall(Long campaignId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (campaignId == null) {
            throw new ApiException("Missing the required parameter 'campaignId' when calling sendSmsCampaignNow(Async)");
        }
        Call call = this.sendSmsCampaignNowCall(campaignId, progressListener, progressRequestListener);
        return call;
    }

    public void sendSmsCampaignNow(Long campaignId) throws ApiException {
        this.sendSmsCampaignNowWithHttpInfo(campaignId);
    }

    public ApiResponse<Void> sendSmsCampaignNowWithHttpInfo(Long campaignId) throws ApiException {
        Call call = this.sendSmsCampaignNowValidateBeforeCall(campaignId, null, null);
        return this.apiClient.execute(call);
    }

    public Call sendSmsCampaignNowAsync(Long campaignId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.sendSmsCampaignNowValidateBeforeCall(campaignId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call sendSmsReportCall(Long campaignId, SendReport sendReport, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SendReport localVarPostBody = sendReport;
        String localVarPath = "/smsCampaigns/{campaignId}/sendReport".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(campaignId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call sendSmsReportValidateBeforeCall(Long campaignId, SendReport sendReport, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (campaignId == null) {
            throw new ApiException("Missing the required parameter 'campaignId' when calling sendSmsReport(Async)");
        }
        if (sendReport == null) {
            throw new ApiException("Missing the required parameter 'sendReport' when calling sendSmsReport(Async)");
        }
        Call call = this.sendSmsReportCall(campaignId, sendReport, progressListener, progressRequestListener);
        return call;
    }

    public void sendSmsReport(Long campaignId, SendReport sendReport) throws ApiException {
        this.sendSmsReportWithHttpInfo(campaignId, sendReport);
    }

    public ApiResponse<Void> sendSmsReportWithHttpInfo(Long campaignId, SendReport sendReport) throws ApiException {
        Call call = this.sendSmsReportValidateBeforeCall(campaignId, sendReport, null, null);
        return this.apiClient.execute(call);
    }

    public Call sendSmsReportAsync(Long campaignId, SendReport sendReport, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.sendSmsReportValidateBeforeCall(campaignId, sendReport, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call sendTestSmsCall(Long campaignId, SendTestSms phoneNumber, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SendTestSms localVarPostBody = phoneNumber;
        String localVarPath = "/smsCampaigns/{campaignId}/sendTest".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(campaignId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call sendTestSmsValidateBeforeCall(Long campaignId, SendTestSms phoneNumber, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (campaignId == null) {
            throw new ApiException("Missing the required parameter 'campaignId' when calling sendTestSms(Async)");
        }
        if (phoneNumber == null) {
            throw new ApiException("Missing the required parameter 'phoneNumber' when calling sendTestSms(Async)");
        }
        Call call = this.sendTestSmsCall(campaignId, phoneNumber, progressListener, progressRequestListener);
        return call;
    }

    public void sendTestSms(Long campaignId, SendTestSms phoneNumber) throws ApiException {
        this.sendTestSmsWithHttpInfo(campaignId, phoneNumber);
    }

    public ApiResponse<Void> sendTestSmsWithHttpInfo(Long campaignId, SendTestSms phoneNumber) throws ApiException {
        Call call = this.sendTestSmsValidateBeforeCall(campaignId, phoneNumber, null, null);
        return this.apiClient.execute(call);
    }

    public Call sendTestSmsAsync(Long campaignId, SendTestSms phoneNumber, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.sendTestSmsValidateBeforeCall(campaignId, phoneNumber, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call updateSmsCampaignCall(Long campaignId, UpdateSmsCampaign updateSmsCampaign, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdateSmsCampaign localVarPostBody = updateSmsCampaign;
        String localVarPath = "/smsCampaigns/{campaignId}".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(campaignId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateSmsCampaignValidateBeforeCall(Long campaignId, UpdateSmsCampaign updateSmsCampaign, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (campaignId == null) {
            throw new ApiException("Missing the required parameter 'campaignId' when calling updateSmsCampaign(Async)");
        }
        if (updateSmsCampaign == null) {
            throw new ApiException("Missing the required parameter 'updateSmsCampaign' when calling updateSmsCampaign(Async)");
        }
        Call call = this.updateSmsCampaignCall(campaignId, updateSmsCampaign, progressListener, progressRequestListener);
        return call;
    }

    public void updateSmsCampaign(Long campaignId, UpdateSmsCampaign updateSmsCampaign) throws ApiException {
        this.updateSmsCampaignWithHttpInfo(campaignId, updateSmsCampaign);
    }

    public ApiResponse<Void> updateSmsCampaignWithHttpInfo(Long campaignId, UpdateSmsCampaign updateSmsCampaign) throws ApiException {
        Call call = this.updateSmsCampaignValidateBeforeCall(campaignId, updateSmsCampaign, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateSmsCampaignAsync(Long campaignId, UpdateSmsCampaign updateSmsCampaign, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateSmsCampaignValidateBeforeCall(campaignId, updateSmsCampaign, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call updateSmsCampaignStatusCall(Long campaignId, UpdateCampaignStatus status, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdateCampaignStatus localVarPostBody = status;
        String localVarPath = "/smsCampaigns/{campaignId}/status".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(campaignId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateSmsCampaignStatusValidateBeforeCall(Long campaignId, UpdateCampaignStatus status, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (campaignId == null) {
            throw new ApiException("Missing the required parameter 'campaignId' when calling updateSmsCampaignStatus(Async)");
        }
        if (status == null) {
            throw new ApiException("Missing the required parameter 'status' when calling updateSmsCampaignStatus(Async)");
        }
        Call call = this.updateSmsCampaignStatusCall(campaignId, status, progressListener, progressRequestListener);
        return call;
    }

    public void updateSmsCampaignStatus(Long campaignId, UpdateCampaignStatus status) throws ApiException {
        this.updateSmsCampaignStatusWithHttpInfo(campaignId, status);
    }

    public ApiResponse<Void> updateSmsCampaignStatusWithHttpInfo(Long campaignId, UpdateCampaignStatus status) throws ApiException {
        Call call = this.updateSmsCampaignStatusValidateBeforeCall(campaignId, status, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateSmsCampaignStatusAsync(Long campaignId, UpdateCampaignStatus status, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateSmsCampaignStatusValidateBeforeCall(campaignId, status, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

