/*
 * Decompiled with CFR 0.152.
 */
package sibApi;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.threeten.bp.OffsetDateTime;
import sendinblue.ApiCallback;
import sendinblue.ApiClient;
import sendinblue.ApiException;
import sendinblue.ApiResponse;
import sendinblue.Configuration;
import sendinblue.Pair;
import sendinblue.ProgressRequestBody;
import sendinblue.ProgressResponseBody;
import sibModel.AbTestCampaignResult;
import sibModel.CreateEmailCampaign;
import sibModel.CreateModel;
import sibModel.CreatedProcessId;
import sibModel.EmailExportRecipients;
import sibModel.GetEmailCampaign;
import sibModel.GetEmailCampaigns;
import sibModel.GetSharedTemplateUrl;
import sibModel.SendReport;
import sibModel.SendTestEmail;
import sibModel.UpdateCampaignStatus;
import sibModel.UpdateEmailCampaign;
import sibModel.UploadImageToGallery;

public class EmailCampaignsApi {
    private ApiClient apiClient;

    public EmailCampaignsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EmailCampaignsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createEmailCampaignCall(CreateEmailCampaign emailCampaigns, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateEmailCampaign localVarPostBody = emailCampaigns;
        String localVarPath = "/emailCampaigns";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createEmailCampaignValidateBeforeCall(CreateEmailCampaign emailCampaigns, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (emailCampaigns == null) {
            throw new ApiException("Missing the required parameter 'emailCampaigns' when calling createEmailCampaign(Async)");
        }
        Call call = this.createEmailCampaignCall(emailCampaigns, progressListener, progressRequestListener);
        return call;
    }

    public CreateModel createEmailCampaign(CreateEmailCampaign emailCampaigns) throws ApiException {
        ApiResponse<CreateModel> resp = this.createEmailCampaignWithHttpInfo(emailCampaigns);
        return resp.getData();
    }

    public ApiResponse<CreateModel> createEmailCampaignWithHttpInfo(CreateEmailCampaign emailCampaigns) throws ApiException {
        Call call = this.createEmailCampaignValidateBeforeCall(emailCampaigns, null, null);
        Type localVarReturnType = new TypeToken<CreateModel>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createEmailCampaignAsync(CreateEmailCampaign emailCampaigns, final ApiCallback<CreateModel> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createEmailCampaignValidateBeforeCall(emailCampaigns, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreateModel>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteEmailCampaignCall(Long campaignId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/emailCampaigns/{campaignId}".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(campaignId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteEmailCampaignValidateBeforeCall(Long campaignId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (campaignId == null) {
            throw new ApiException("Missing the required parameter 'campaignId' when calling deleteEmailCampaign(Async)");
        }
        Call call = this.deleteEmailCampaignCall(campaignId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteEmailCampaign(Long campaignId) throws ApiException {
        this.deleteEmailCampaignWithHttpInfo(campaignId);
    }

    public ApiResponse<Void> deleteEmailCampaignWithHttpInfo(Long campaignId) throws ApiException {
        Call call = this.deleteEmailCampaignValidateBeforeCall(campaignId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteEmailCampaignAsync(Long campaignId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteEmailCampaignValidateBeforeCall(campaignId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call emailExportRecipientsCall(Long campaignId, EmailExportRecipients recipientExport, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        EmailExportRecipients localVarPostBody = recipientExport;
        String localVarPath = "/emailCampaigns/{campaignId}/exportRecipients".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(campaignId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call emailExportRecipientsValidateBeforeCall(Long campaignId, EmailExportRecipients recipientExport, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (campaignId == null) {
            throw new ApiException("Missing the required parameter 'campaignId' when calling emailExportRecipients(Async)");
        }
        Call call = this.emailExportRecipientsCall(campaignId, recipientExport, progressListener, progressRequestListener);
        return call;
    }

    public CreatedProcessId emailExportRecipients(Long campaignId, EmailExportRecipients recipientExport) throws ApiException {
        ApiResponse<CreatedProcessId> resp = this.emailExportRecipientsWithHttpInfo(campaignId, recipientExport);
        return resp.getData();
    }

    public ApiResponse<CreatedProcessId> emailExportRecipientsWithHttpInfo(Long campaignId, EmailExportRecipients recipientExport) throws ApiException {
        Call call = this.emailExportRecipientsValidateBeforeCall(campaignId, recipientExport, null, null);
        Type localVarReturnType = new TypeToken<CreatedProcessId>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call emailExportRecipientsAsync(Long campaignId, EmailExportRecipients recipientExport, final ApiCallback<CreatedProcessId> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.emailExportRecipientsValidateBeforeCall(campaignId, recipientExport, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreatedProcessId>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAbTestCampaignResultCall(Long campaignId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/emailCampaigns/{campaignId}/abTestCampaignResult".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(campaignId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAbTestCampaignResultValidateBeforeCall(Long campaignId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (campaignId == null) {
            throw new ApiException("Missing the required parameter 'campaignId' when calling getAbTestCampaignResult(Async)");
        }
        Call call = this.getAbTestCampaignResultCall(campaignId, progressListener, progressRequestListener);
        return call;
    }

    public AbTestCampaignResult getAbTestCampaignResult(Long campaignId) throws ApiException {
        ApiResponse<AbTestCampaignResult> resp = this.getAbTestCampaignResultWithHttpInfo(campaignId);
        return resp.getData();
    }

    public ApiResponse<AbTestCampaignResult> getAbTestCampaignResultWithHttpInfo(Long campaignId) throws ApiException {
        Call call = this.getAbTestCampaignResultValidateBeforeCall(campaignId, null, null);
        Type localVarReturnType = new TypeToken<AbTestCampaignResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAbTestCampaignResultAsync(Long campaignId, final ApiCallback<AbTestCampaignResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAbTestCampaignResultValidateBeforeCall(campaignId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AbTestCampaignResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getEmailCampaignCall(Long campaignId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/emailCampaigns/{campaignId}".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(campaignId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getEmailCampaignValidateBeforeCall(Long campaignId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (campaignId == null) {
            throw new ApiException("Missing the required parameter 'campaignId' when calling getEmailCampaign(Async)");
        }
        Call call = this.getEmailCampaignCall(campaignId, progressListener, progressRequestListener);
        return call;
    }

    public GetEmailCampaign getEmailCampaign(Long campaignId) throws ApiException {
        ApiResponse<GetEmailCampaign> resp = this.getEmailCampaignWithHttpInfo(campaignId);
        return resp.getData();
    }

    public ApiResponse<GetEmailCampaign> getEmailCampaignWithHttpInfo(Long campaignId) throws ApiException {
        Call call = this.getEmailCampaignValidateBeforeCall(campaignId, null, null);
        Type localVarReturnType = new TypeToken<GetEmailCampaign>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getEmailCampaignAsync(Long campaignId, final ApiCallback<GetEmailCampaign> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getEmailCampaignValidateBeforeCall(campaignId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetEmailCampaign>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getEmailCampaignsCall(String type, String status, OffsetDateTime startDate, OffsetDateTime endDate, Long limit, Long offset, String sort, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/emailCampaigns";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (type != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", status));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getEmailCampaignsValidateBeforeCall(String type, String status, OffsetDateTime startDate, OffsetDateTime endDate, Long limit, Long offset, String sort, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getEmailCampaignsCall(type, status, startDate, endDate, limit, offset, sort, progressListener, progressRequestListener);
        return call;
    }

    public GetEmailCampaigns getEmailCampaigns(String type, String status, OffsetDateTime startDate, OffsetDateTime endDate, Long limit, Long offset, String sort) throws ApiException {
        ApiResponse<GetEmailCampaigns> resp = this.getEmailCampaignsWithHttpInfo(type, status, startDate, endDate, limit, offset, sort);
        return resp.getData();
    }

    public ApiResponse<GetEmailCampaigns> getEmailCampaignsWithHttpInfo(String type, String status, OffsetDateTime startDate, OffsetDateTime endDate, Long limit, Long offset, String sort) throws ApiException {
        Call call = this.getEmailCampaignsValidateBeforeCall(type, status, startDate, endDate, limit, offset, sort, null, null);
        Type localVarReturnType = new TypeToken<GetEmailCampaigns>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getEmailCampaignsAsync(String type, String status, OffsetDateTime startDate, OffsetDateTime endDate, Long limit, Long offset, String sort, final ApiCallback<GetEmailCampaigns> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getEmailCampaignsValidateBeforeCall(type, status, startDate, endDate, limit, offset, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetEmailCampaigns>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getSharedTemplateUrlCall(Long campaignId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/emailCampaigns/{campaignId}/sharedUrl".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(campaignId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSharedTemplateUrlValidateBeforeCall(Long campaignId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (campaignId == null) {
            throw new ApiException("Missing the required parameter 'campaignId' when calling getSharedTemplateUrl(Async)");
        }
        Call call = this.getSharedTemplateUrlCall(campaignId, progressListener, progressRequestListener);
        return call;
    }

    public GetSharedTemplateUrl getSharedTemplateUrl(Long campaignId) throws ApiException {
        ApiResponse<GetSharedTemplateUrl> resp = this.getSharedTemplateUrlWithHttpInfo(campaignId);
        return resp.getData();
    }

    public ApiResponse<GetSharedTemplateUrl> getSharedTemplateUrlWithHttpInfo(Long campaignId) throws ApiException {
        Call call = this.getSharedTemplateUrlValidateBeforeCall(campaignId, null, null);
        Type localVarReturnType = new TypeToken<GetSharedTemplateUrl>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSharedTemplateUrlAsync(Long campaignId, final ApiCallback<GetSharedTemplateUrl> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSharedTemplateUrlValidateBeforeCall(campaignId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetSharedTemplateUrl>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call sendEmailCampaignNowCall(Long campaignId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/emailCampaigns/{campaignId}/sendNow".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(campaignId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call sendEmailCampaignNowValidateBeforeCall(Long campaignId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (campaignId == null) {
            throw new ApiException("Missing the required parameter 'campaignId' when calling sendEmailCampaignNow(Async)");
        }
        Call call = this.sendEmailCampaignNowCall(campaignId, progressListener, progressRequestListener);
        return call;
    }

    public void sendEmailCampaignNow(Long campaignId) throws ApiException {
        this.sendEmailCampaignNowWithHttpInfo(campaignId);
    }

    public ApiResponse<Void> sendEmailCampaignNowWithHttpInfo(Long campaignId) throws ApiException {
        Call call = this.sendEmailCampaignNowValidateBeforeCall(campaignId, null, null);
        return this.apiClient.execute(call);
    }

    public Call sendEmailCampaignNowAsync(Long campaignId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.sendEmailCampaignNowValidateBeforeCall(campaignId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call sendReportCall(Long campaignId, SendReport sendReport, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SendReport localVarPostBody = sendReport;
        String localVarPath = "/emailCampaigns/{campaignId}/sendReport".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(campaignId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call sendReportValidateBeforeCall(Long campaignId, SendReport sendReport, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (campaignId == null) {
            throw new ApiException("Missing the required parameter 'campaignId' when calling sendReport(Async)");
        }
        if (sendReport == null) {
            throw new ApiException("Missing the required parameter 'sendReport' when calling sendReport(Async)");
        }
        Call call = this.sendReportCall(campaignId, sendReport, progressListener, progressRequestListener);
        return call;
    }

    public void sendReport(Long campaignId, SendReport sendReport) throws ApiException {
        this.sendReportWithHttpInfo(campaignId, sendReport);
    }

    public ApiResponse<Void> sendReportWithHttpInfo(Long campaignId, SendReport sendReport) throws ApiException {
        Call call = this.sendReportValidateBeforeCall(campaignId, sendReport, null, null);
        return this.apiClient.execute(call);
    }

    public Call sendReportAsync(Long campaignId, SendReport sendReport, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.sendReportValidateBeforeCall(campaignId, sendReport, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call sendTestEmailCall(Long campaignId, SendTestEmail emailTo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SendTestEmail localVarPostBody = emailTo;
        String localVarPath = "/emailCampaigns/{campaignId}/sendTest".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(campaignId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call sendTestEmailValidateBeforeCall(Long campaignId, SendTestEmail emailTo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (campaignId == null) {
            throw new ApiException("Missing the required parameter 'campaignId' when calling sendTestEmail(Async)");
        }
        if (emailTo == null) {
            throw new ApiException("Missing the required parameter 'emailTo' when calling sendTestEmail(Async)");
        }
        Call call = this.sendTestEmailCall(campaignId, emailTo, progressListener, progressRequestListener);
        return call;
    }

    public void sendTestEmail(Long campaignId, SendTestEmail emailTo) throws ApiException {
        this.sendTestEmailWithHttpInfo(campaignId, emailTo);
    }

    public ApiResponse<Void> sendTestEmailWithHttpInfo(Long campaignId, SendTestEmail emailTo) throws ApiException {
        Call call = this.sendTestEmailValidateBeforeCall(campaignId, emailTo, null, null);
        return this.apiClient.execute(call);
    }

    public Call sendTestEmailAsync(Long campaignId, SendTestEmail emailTo, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.sendTestEmailValidateBeforeCall(campaignId, emailTo, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call updateCampaignStatusCall(Long campaignId, UpdateCampaignStatus status, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdateCampaignStatus localVarPostBody = status;
        String localVarPath = "/emailCampaigns/{campaignId}/status".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(campaignId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateCampaignStatusValidateBeforeCall(Long campaignId, UpdateCampaignStatus status, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (campaignId == null) {
            throw new ApiException("Missing the required parameter 'campaignId' when calling updateCampaignStatus(Async)");
        }
        if (status == null) {
            throw new ApiException("Missing the required parameter 'status' when calling updateCampaignStatus(Async)");
        }
        Call call = this.updateCampaignStatusCall(campaignId, status, progressListener, progressRequestListener);
        return call;
    }

    public void updateCampaignStatus(Long campaignId, UpdateCampaignStatus status) throws ApiException {
        this.updateCampaignStatusWithHttpInfo(campaignId, status);
    }

    public ApiResponse<Void> updateCampaignStatusWithHttpInfo(Long campaignId, UpdateCampaignStatus status) throws ApiException {
        Call call = this.updateCampaignStatusValidateBeforeCall(campaignId, status, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateCampaignStatusAsync(Long campaignId, UpdateCampaignStatus status, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateCampaignStatusValidateBeforeCall(campaignId, status, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call updateEmailCampaignCall(Long campaignId, UpdateEmailCampaign emailCampaign, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdateEmailCampaign localVarPostBody = emailCampaign;
        String localVarPath = "/emailCampaigns/{campaignId}".replaceAll("\\{campaignId\\}", this.apiClient.escapeString(campaignId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateEmailCampaignValidateBeforeCall(Long campaignId, UpdateEmailCampaign emailCampaign, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (campaignId == null) {
            throw new ApiException("Missing the required parameter 'campaignId' when calling updateEmailCampaign(Async)");
        }
        if (emailCampaign == null) {
            throw new ApiException("Missing the required parameter 'emailCampaign' when calling updateEmailCampaign(Async)");
        }
        Call call = this.updateEmailCampaignCall(campaignId, emailCampaign, progressListener, progressRequestListener);
        return call;
    }

    public void updateEmailCampaign(Long campaignId, UpdateEmailCampaign emailCampaign) throws ApiException {
        this.updateEmailCampaignWithHttpInfo(campaignId, emailCampaign);
    }

    public ApiResponse<Void> updateEmailCampaignWithHttpInfo(Long campaignId, UpdateEmailCampaign emailCampaign) throws ApiException {
        Call call = this.updateEmailCampaignValidateBeforeCall(campaignId, emailCampaign, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateEmailCampaignAsync(Long campaignId, UpdateEmailCampaign emailCampaign, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateEmailCampaignValidateBeforeCall(campaignId, emailCampaign, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call uploadImageToGalleryCall(UploadImageToGallery uploadImage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UploadImageToGallery localVarPostBody = uploadImage;
        String localVarPath = "/emailCampaigns/images";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call uploadImageToGalleryValidateBeforeCall(UploadImageToGallery uploadImage, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (uploadImage == null) {
            throw new ApiException("Missing the required parameter 'uploadImage' when calling uploadImageToGallery(Async)");
        }
        Call call = this.uploadImageToGalleryCall(uploadImage, progressListener, progressRequestListener);
        return call;
    }

    public void uploadImageToGallery(UploadImageToGallery uploadImage) throws ApiException {
        this.uploadImageToGalleryWithHttpInfo(uploadImage);
    }

    public ApiResponse<Void> uploadImageToGalleryWithHttpInfo(UploadImageToGallery uploadImage) throws ApiException {
        Call call = this.uploadImageToGalleryValidateBeforeCall(uploadImage, null, null);
        return this.apiClient.execute(call);
    }

    public Call uploadImageToGalleryAsync(UploadImageToGallery uploadImage, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.uploadImageToGalleryValidateBeforeCall(uploadImage, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

