/*
 * Decompiled with CFR 0.152.
 */
package de.intension.keycloak.sendinblue.internal;

import de.intension.keycloak.sendinblue.LogId;
import java.util.Arrays;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.email.EmailException;
import org.keycloak.models.UserModel;
import sendinblue.ApiClient;
import sendinblue.ApiException;
import sendinblue.Configuration;
import sendinblue.auth.ApiKeyAuth;
import sibApi.TransactionalEmailsApi;
import sibModel.SendSmtpEmail;
import sibModel.SendSmtpEmailTo;

public class SendinblueSender {
    private static final Logger LOGGER = Logger.getLogger(SendinblueSender.class);
    private ApiClient apiClient;

    public static SendinblueSender create() {
        return new SendinblueSender();
    }

    public void postToSendinblue(UserModel user, long templateId, Map<String, String> params) throws EmailException {
        TransactionalEmailsApi apiInstance = new TransactionalEmailsApi(this.apiClient);
        SendSmtpEmailTo recipient = new SendSmtpEmailTo().name(user.getFirstName() + " " + user.getLastName()).email(user.getEmail());
        SendSmtpEmail sendSmtpEmail = new SendSmtpEmail().templateId(templateId).params(params).to(Arrays.asList(recipient));
        try {
            apiInstance.getSmtpTemplate(templateId);
            apiInstance.sendTransacEmail(sendSmtpEmail);
        }
        catch (ApiException e) {
            LOGGER.errorf("[%s] Unable to send transactional mail for user '%s'", (Object)LogId.KCSIB0002, (Object)user.getEmail());
            throw new EmailException(e.getMessage(), (Throwable)e);
        }
    }

    public SendinblueSender setApiKey(String apiKey) {
        LOGGER.infof("setApiKey(apiKey='*******') has been invoked", new Object[0]);
        this.apiClient = Configuration.getDefaultApiClient();
        ApiKeyAuth apiKeyAuth = (ApiKeyAuth)this.apiClient.getAuthentication("api-key");
        apiKeyAuth.setApiKey(apiKey);
        return this;
    }
}

