/*
 * Decompiled with CFR 0.152.
 */
package de.intension.keycloak.sendinblue;

import de.intension.keycloak.sendinblue.LogId;
import de.intension.keycloak.sendinblue.internal.SendinblueSender;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailSenderProvider;
import org.keycloak.models.UserModel;

public class SendinblueEmailProvider
implements EmailSenderProvider {
    private static final Logger LOGGER = Logger.getLogger(SendinblueEmailProvider.class);
    private SendinblueSender sendinblueSender = SendinblueSender.create();

    public SendinblueEmailProvider() {
        LOGGER.infof("Instantiated %s", (Object)this.getClass().getSimpleName());
    }

    public void close() {
    }

    public void send(Map<String, String> config, UserModel user, String subject, String textBody, String htmlBody) throws EmailException {
        String templateIdConfigValue = config.get("templateId");
        if (templateIdConfigValue == null) {
            LOGGER.errorf("[%s] templateID not provided. Unable to send email.", (Object)LogId.KCSIB0001);
            throw new EmailException("Config is missing template ID.");
        }
        long templateId = Long.parseLong(templateIdConfigValue);
        this.sendinblueSender.postToSendinblue(user, templateId, config);
    }

    public SendinblueEmailProvider setApiKey(String apiKey) {
        this.sendinblueSender.setApiKey(apiKey);
        return this;
    }
}

