/*
 * Decompiled with CFR 0.152.
 */
package de.intension.keycloak.sendinblue;

import de.intension.keycloak.sendinblue.ConfigParameter;
import de.intension.keycloak.sendinblue.LogId;
import de.intension.keycloak.sendinblue.SendinblueEmailProvider;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.email.EmailSenderProvider;
import org.keycloak.email.EmailSenderProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

public class SendinblueEmailProviderFactory
implements EmailSenderProviderFactory {
    private static final Logger LOGGER = Logger.getLogger(SendinblueEmailProviderFactory.class);
    private static final String PROVIDER_ID = "sendinblue-email-provider";
    private SendinblueEmailProvider sendinblueEmailProvider = new SendinblueEmailProvider();

    public EmailSenderProvider create(KeycloakSession session) {
        return this.sendinblueEmailProvider;
    }

    public void init(Config.Scope config) {
        String apiKey = config.get(ConfigParameter.API_KEY.asString());
        if (apiKey == null) {
            LOGGER.errorf("[%s] Unable to set API key", (Object)LogId.KCSIB0003);
        } else {
            this.sendinblueEmailProvider.setApiKey(apiKey);
        }
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

