/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reflect;

import de.intarsys.tools.component.IInitializeable;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.reflect.FieldAccessException;
import de.intarsys.tools.reflect.FieldException;
import de.intarsys.tools.reflect.IBasicAccessSupport;
import de.intarsys.tools.reflect.IBasicInvocationSupport;
import de.intarsys.tools.reflect.IBasicRegistrySupport;
import de.intarsys.tools.reflect.MethodException;
import de.intarsys.tools.reflect.MethodInvocationException;
import de.intarsys.tools.reflect.MethodNotFoundException;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ObjectTools {
    private static final Object[] EMPTY_PARAMETERS = new Object[0];
    private static final Class[] EMPTY_PARAMETERTYPES = new Class[0];
    public static final String GET_PREFIX = "get";
    public static final String IS_PREFIX = "is";
    private static final Map<String, Class> PRIMITIVE_CLASSES = new HashMap<String, Class>();
    private static final Map<Class, Class> PRIMITIVE_WRAPPER = new HashMap<Class, Class>();

    static {
        PRIMITIVE_CLASSES.put("int", Integer.TYPE);
        PRIMITIVE_CLASSES.put("long", Long.TYPE);
        PRIMITIVE_CLASSES.put("double", Double.TYPE);
        PRIMITIVE_CLASSES.put("float", Float.TYPE);
        PRIMITIVE_CLASSES.put("bool", Boolean.TYPE);
        PRIMITIVE_CLASSES.put("char", Character.TYPE);
        PRIMITIVE_CLASSES.put("byte", Byte.TYPE);
        PRIMITIVE_CLASSES.put("void", Void.TYPE);
        PRIMITIVE_CLASSES.put("short", Short.TYPE);
        PRIMITIVE_WRAPPER.put(Integer.TYPE, Integer.class);
        PRIMITIVE_WRAPPER.put(Long.TYPE, Long.class);
        PRIMITIVE_WRAPPER.put(Double.TYPE, Double.class);
        PRIMITIVE_WRAPPER.put(Float.TYPE, Float.class);
        PRIMITIVE_WRAPPER.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_WRAPPER.put(Character.TYPE, Character.class);
        PRIMITIVE_WRAPPER.put(Byte.TYPE, Byte.class);
        PRIMITIVE_WRAPPER.put(Void.TYPE, Void.class);
        PRIMITIVE_WRAPPER.put(Short.TYPE, Short.class);
    }

    public static Object basicGet(Object object, String string) throws FieldException {
        if (object instanceof IBasicAccessSupport) {
            return ((IBasicAccessSupport)object).basicGetValue(string);
        }
        try {
            Method method = ObjectTools.findGetter(object, string);
            return method.invoke(object, null);
        }
        catch (Exception exception) {
            try {
                Field field = object.getClass().getField(string);
                return field.get(object);
            }
            catch (Exception exception2) {
                try {
                    Method method = object.getClass().getMethod(string, null);
                    return method.invoke(object, null);
                }
                catch (Exception exception3) {
                    throw new FieldAccessException(string, exception3);
                }
            }
        }
    }

    public static Object basicInsert(Object object, String string, Object object2) throws FieldException {
        try {
            Method method = ObjectTools.findInserter(object, string, object2);
            return method.invoke(object, object2);
        }
        catch (Exception exception) {
            Object object3 = ObjectTools.get(object, string);
            if (object3 instanceof Collection) {
                if (((Collection)object3).add(object2)) {
                    return object2;
                }
                return null;
            }
            throw new FieldAccessException(string, "can't insert in " + string);
        }
    }

    public static Object basicInvoke(Object object, String string, Object ... objectArray) throws MethodException {
        if (object instanceof IBasicInvocationSupport) {
            return ((IBasicInvocationSupport)object).basicInvoke(string, objectArray);
        }
        Method method = ObjectTools.findMethod(object, string, objectArray);
        try {
            return method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            throw new MethodInvocationException(string, exception);
        }
    }

    public static Object basicRemove(Object object, String string, Object object2) throws FieldException {
        try {
            Method method = ObjectTools.findRemover(object, string, object2);
            return method.invoke(object, object2);
        }
        catch (Exception exception) {
            Object object3 = ObjectTools.get(object, string);
            if (object3 instanceof Collection) {
                if (((Collection)object3).remove(object2)) {
                    return object2;
                }
                return null;
            }
            throw new FieldAccessException(string, "can't remove from " + string);
        }
    }

    public static Object basicSet(Object object, String string, Object object2) throws FieldException {
        if (object instanceof IBasicAccessSupport) {
            return ((IBasicAccessSupport)object).basicSetValue(string, object2);
        }
        try {
            Method method = ObjectTools.findSetter(object, string, object2);
            return method.invoke(object, object2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new FieldAccessException(string, invocationTargetException.getCause());
        }
        catch (Exception exception) {
            try {
                Field field = object.getClass().getField(string);
                Object object3 = field.get(object);
                field.set(object, object2);
                return object3;
            }
            catch (Exception exception2) {
                throw new FieldAccessException(string, exception2);
            }
        }
    }

    protected static boolean checkCandidate(Method method, String string, Class[] classArray) {
        if (!method.getName().equals(string)) {
            return false;
        }
        Class[] classArray2 = method.getParameterTypes();
        return ObjectTools.checkCandidateClasses(classArray2, classArray);
    }

    protected static boolean checkCandidateClasses(Class[] classArray, Class[] classArray2) {
        if (classArray.length != classArray2.length) {
            return false;
        }
        int n = 0;
        while (n < classArray.length) {
            if (!ObjectTools.isAssignable(classArray[n], classArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static Object convert(Object object, String string, ClassLoader classLoader) throws ObjectCreationException {
        if (string == null) {
            return object;
        }
        Class<Object> clazz = ClassTools.createClass(string, Object.class, classLoader);
        try {
            return ConverterRegistry.get().convert(object, clazz);
        }
        catch (ConversionException conversionException) {
            throw new ObjectCreationException(conversionException);
        }
    }

    public static <T> T createObject(Class clazz, Class<T> clazz2) throws ObjectCreationException {
        return ObjectTools.createObject(clazz, clazz2, EMPTY_PARAMETERTYPES, EMPTY_PARAMETERS);
    }

    public static <T> T createObject(Class clazz, Class<T> clazz2, Class[] classArray, Object[] objectArray) throws ObjectCreationException {
        if (clazz == null) {
            throw new ObjectCreationException("class missing");
        }
        try {
            Object t;
            if (objectArray == EMPTY_PARAMETERS) {
                t = clazz.newInstance();
            } else {
                Constructor constructor = clazz.getConstructor(classArray);
                t = constructor.newInstance(objectArray);
            }
            if (t instanceof IInitializeable) {
                ((IInitializeable)t).initializeAfterCreation();
            }
            return t;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can't be instantiated", noClassDefFoundError);
        }
        catch (InstantiationException instantiationException) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can't be instantiated", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can't be instantiated", illegalAccessException);
        }
        catch (SecurityException securityException) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can't be instantiated", securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can't be instantiated", noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can't be instantiated", illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can't be instantiated", invocationTargetException);
        }
        catch (Exception exception) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can't be instantiated", exception);
        }
    }

    public static <T> T createObject(String string, Class<T> clazz, ClassLoader classLoader) throws ObjectCreationException {
        Class<T> clazz2 = ClassTools.createClass(string, clazz, classLoader);
        return ObjectTools.createObject(clazz2, clazz);
    }

    public static Method findGetter(Object object, String string) throws MethodException {
        try {
            String string2 = GET_PREFIX + Character.toUpperCase(string.charAt(0)) + string.substring(1);
            return object.getClass().getMethod(string2, null);
        }
        catch (Exception exception) {
            String string3 = IS_PREFIX + Character.toUpperCase(string.charAt(0)) + string.substring(1);
            try {
                return object.getClass().getMethod(string3, null);
            }
            catch (Exception exception2) {
                throw new MethodNotFoundException(string);
            }
        }
    }

    public static Method findInserter(Object object, String string, Object object2) throws MethodException {
        Method method;
        try {
            String string2 = "add" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
            method = ObjectTools.findMethod(object, string2, object2);
        }
        catch (Exception exception) {
            try {
                String string3 = "insert" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
                method = ObjectTools.findMethod(object, string3, object2);
            }
            catch (Exception exception2) {
                String string4 = "register" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
                method = ObjectTools.findMethod(object, string4, object2);
            }
        }
        return method;
    }

    protected static Method findMatchingMethod(Class clazz, String string, Class[] classArray) throws MethodException {
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            if (ObjectTools.checkCandidate(method, string, classArray)) {
                return method;
            }
            ++n;
        }
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (Exception exception) {
            throw new MethodNotFoundException(string);
        }
    }

    public static Method findMethod(Object object, String string, Object ... objectArray) throws MethodException {
        Class<?> clazz = object.getClass();
        Class[] classArray = new Class[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            classArray[n] = objectArray[n].getClass();
            ++n;
        }
        Method method = null;
        try {
            method = ObjectTools.findMethodFast(clazz, string, classArray);
        }
        catch (Exception exception) {
            method = ObjectTools.findMethodNamed(clazz, string, false, classArray);
        }
        return method;
    }

    protected static Method findMethodFast(Class clazz, String string, Class ... classArray) throws MethodException {
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (Exception exception) {
            throw new MethodNotFoundException(string);
        }
    }

    protected static Method findMethodNamed(Class clazz, String string, boolean bl, Class ... classArray) throws MethodException {
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            if (!(bl ? !method.getName().startsWith(string) : !method.getName().equals(string))) {
                boolean bl2 = true;
                Class<?>[] classArray2 = method.getParameterTypes();
                int n2 = 0;
                while (n2 < classArray2.length) {
                    Class<?> clazz2 = classArray2[n2];
                    Class clazz3 = classArray[n2];
                    if (!ObjectTools.isAssignable(clazz2, clazz3)) {
                        bl2 = false;
                        break;
                    }
                    ++n2;
                }
                if (bl2) {
                    return method;
                }
            }
            ++n;
        }
        throw new MethodNotFoundException(string);
    }

    public static Method findMethodPrefixed(Object object, String string, Object ... objectArray) throws MethodException {
        Class<?> clazz = object.getClass();
        Class[] classArray = new Class[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            classArray[n] = objectArray[n].getClass();
            ++n;
        }
        Method method = null;
        method = ObjectTools.findMethodNamed(clazz, string, true, classArray);
        return method;
    }

    public static Method findRegister(Object object, Object object2) throws MethodException {
        String string = "register";
        return ObjectTools.findMethodPrefixed(object, string, object2);
    }

    public static Method findRemover(Object object, String string, Object object2) throws MethodException {
        String string2 = "remove" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
        return ObjectTools.findMethod(object, string2, object2);
    }

    public static Method findSetter(Object object, String string, Object object2) throws MethodException {
        String string2 = "set" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
        return ObjectTools.findMethod(object, string2, object2);
    }

    public static Object get(Object object, String string) throws FieldException {
        String string2 = string;
        int n = string2.indexOf(46);
        if (n == -1) {
            return ObjectTools.basicGet(object, string);
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        Object object2 = ObjectTools.basicGet(object, string3);
        return ObjectTools.get(object2, string4);
    }

    public static Object insert(Object object, String string, Object object2) throws FieldException {
        int n;
        String string2 = string.replace('[', '.');
        if (string2 != string) {
            string2 = string2.replace(']', ' ');
        }
        if ((n = string2.indexOf(46)) == -1) {
            return ObjectTools.basicInsert(object, string, object2);
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        Object object3 = ObjectTools.basicGet(object, string3);
        return ObjectTools.insert(object3, string4, object2);
    }

    public static Object invoke(Object object, String string, Object ... objectArray) throws MethodException {
        Object object2;
        int n;
        String string2 = string.replace('[', '.');
        if (string2 != string) {
            string2 = string2.replace(']', ' ');
        }
        if ((n = string2.indexOf(46)) == -1) {
            return ObjectTools.basicInvoke(object, string, objectArray);
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        try {
            object2 = ObjectTools.basicGet(object, string3);
        }
        catch (FieldException fieldException) {
            throw new MethodInvocationException(string, fieldException);
        }
        return ObjectTools.invoke(object2, string4, objectArray);
    }

    public static boolean isAssignable(Class clazz, Class clazz2) {
        if (clazz.isAssignableFrom(clazz2)) {
            return true;
        }
        if (clazz.isPrimitive()) {
            return PRIMITIVE_WRAPPER.get(clazz).isAssignableFrom(clazz2);
        }
        if (clazz2.isPrimitive()) {
            return clazz.isAssignableFrom(PRIMITIVE_WRAPPER.get(clazz2));
        }
        return false;
    }

    public static Object register(Object object, Object object2) throws MethodException {
        if (object instanceof IBasicRegistrySupport) {
            return ((IBasicRegistrySupport)object).basicRegister(object2);
        }
        Method method = ObjectTools.findRegister(object, object2);
        try {
            return method.invoke(object, object2);
        }
        catch (Exception exception) {
            throw new MethodInvocationException("register", exception.getCause());
        }
    }

    public static Object remove(Object object, String string, Object object2) throws FieldException {
        int n;
        String string2 = string.replace('[', '.');
        if (string2 != string) {
            string2 = string2.replace(']', ' ');
        }
        if ((n = string2.indexOf(46)) == -1) {
            return ObjectTools.basicRemove(object, string, object2);
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        Object object3 = ObjectTools.basicGet(object, string3);
        return ObjectTools.remove(object3, string4, object2);
    }

    public static Object set(Object object, String string, Object object2) throws FieldException {
        int n;
        String string2 = string.replace('[', '.');
        if (string2 != string) {
            string2 = string2.replace(']', ' ');
        }
        if ((n = string2.indexOf(46)) == -1) {
            return ObjectTools.basicSet(object, string, object2);
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        Object object3 = ObjectTools.basicGet(object, string3);
        return ObjectTools.set(object3, string4, object2);
    }
}

