/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.factory;

import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.Outlet;
import de.intarsys.tools.factory.PACKAGE;
import de.intarsys.tools.reflect.ObjectTools;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FactoryTools {
    private static final Logger Log = PACKAGE.Log;

    public static IFactory lookupFactory(Class clazz) {
        String string = clazz.getName();
        IFactory iFactory = Outlet.get().lookupFactory(string);
        if (iFactory == null) {
            try {
                iFactory = ObjectTools.createObject(clazz, IFactory.class);
                Outlet.get().registerFactory(iFactory);
                Log.log(Level.INFO, "created default factory '" + string + "'");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return iFactory;
    }

    public static IFactory lookupFactory(String string, ClassLoader classLoader) {
        IFactory iFactory = Outlet.get().lookupFactory(string);
        if (iFactory == null) {
            try {
                iFactory = ObjectTools.createObject(string, IFactory.class, classLoader);
                Outlet.get().registerFactory(iFactory);
                Log.log(Level.INFO, "created default factory '" + string + "'");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return iFactory;
    }

    public static IFactory lookupFactoryFor(Class clazz) {
        IFactory<T>[] iFactoryArray = Outlet.get().lookupFactories(clazz);
        if (iFactoryArray.length > 0) {
            return iFactoryArray[0];
        }
        String string = String.valueOf(clazz.getName()) + "Factory";
        IFactory iFactory = Outlet.get().lookupFactory(string);
        if (iFactory == null) {
            try {
                iFactory = ObjectTools.createObject(string, IFactory.class, clazz.getClassLoader());
                Outlet.get().registerFactory(iFactory);
                Log.log(Level.INFO, "created default factory '" + string + "'");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return iFactory;
    }
}

