/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.swt.image;

import de.intarsys.cwt.swt.image.ComponentOrder;
import de.intarsys.cwt.swt.image.IImageConverter;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import org.eclipse.swt.graphics.ImageData;

public class ICComponentRGBByteOpaqueToSame
implements IImageConverter {
    @Override
    public boolean accept(BufferedImage image) {
        ColorModel colorModel = image.getColorModel();
        if (!(colorModel instanceof ComponentColorModel)) {
            return false;
        }
        if (!colorModel.getColorSpace().isCS_sRGB()) {
            return false;
        }
        if (colorModel.getTransparency() != 1) {
            return false;
        }
        DataBuffer dataBuffer = image.getRaster().getDataBuffer();
        if (!(dataBuffer instanceof DataBufferByte)) {
            return false;
        }
        ComponentSampleModel sampleModel = (ComponentSampleModel)image.getSampleModel();
        return Arrays.equals(ComponentOrder.PlatformInstance.getBandOffsets(), sampleModel.getBandOffsets());
    }

    @Override
    public ImageData createImageData(BufferedImage srcImage) {
        byte[] srcData;
        int srcWidth = srcImage.getWidth();
        int srcHeight = srcImage.getHeight();
        WritableRaster srcRaster = srcImage.getRaster();
        byte[] data = srcData = ((DataBufferByte)srcRaster.getDataBuffer()).getData();
        ImageData imageData = new ImageData(srcWidth, srcHeight, 24, ComponentOrder.PlatformInstance.getPaletteData(), 3, data);
        return imageData;
    }
}

