/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.swt.image;

import de.intarsys.cwt.swt.image.ComponentOrder;
import de.intarsys.cwt.swt.image.IImageConverter;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.eclipse.swt.graphics.ImageData;

public class ICAnyToPlatform
implements IImageConverter {
    @Override
    public boolean accept(BufferedImage image) {
        return true;
    }

    @Override
    public ImageData createImageData(BufferedImage srcImage) {
        byte[] data;
        int[] bandOffsets;
        ColorConvertOp colorConvertOp = new ColorConvertOp(null);
        ColorSpace destColorSpace = ColorSpace.getInstance(1000);
        ColorModel srcColorModel = srcImage.getColorModel();
        int srcTransparency = srcColorModel.getTransparency();
        boolean srcHasAlpha = srcTransparency != 1;
        ComponentColorModel destColorModel = new ComponentColorModel(destColorSpace, srcHasAlpha, false, srcTransparency, 0);
        int srcWidth = srcImage.getWidth();
        int srcHeight = srcImage.getHeight();
        if (srcHasAlpha) {
            bandOffsets = new int[4];
            bandOffsets[3] = 3;
        } else {
            bandOffsets = new int[3];
        }
        ComponentOrder.PlatformInstance.fillBandOffsets(bandOffsets);
        WritableRaster destRaster = Raster.createInterleavedRaster(0, srcWidth, srcHeight, srcWidth * bandOffsets.length, bandOffsets.length, bandOffsets, new Point(0, 0));
        BufferedImage destImage = new BufferedImage(destColorModel, destRaster, false, null);
        colorConvertOp.filter(srcImage, destImage);
        byte[] destData = ((DataBufferByte)destRaster.getDataBuffer()).getData();
        byte[] alphaData = null;
        if (srcHasAlpha) {
            data = new byte[srcWidth * srcHeight * 3];
            alphaData = new byte[srcWidth * srcHeight];
            int index = 0;
            while (index < alphaData.length) {
                data[index * 3] = destData[index * 4];
                data[index * 3 + 1] = destData[index * 4 + 1];
                data[index * 3 + 2] = destData[index * 4 + 2];
                alphaData[index] = destData[index * 4 + 3];
                ++index;
            }
        } else {
            data = destData;
        }
        ImageData imageData = new ImageData(srcWidth, srcHeight, 24, ComponentOrder.PlatformInstance.getPaletteData(), 3, data);
        imageData.alphaData = alphaData;
        return imageData;
    }
}

