/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.truetype;

import de.intarsys.cwt.font.FontStyle;
import de.intarsys.cwt.font.truetype.TTFontHeader;
import de.intarsys.cwt.font.truetype.TTFontParser;
import de.intarsys.cwt.font.truetype.TTFontSerializer;
import de.intarsys.cwt.font.truetype.TTHorizontalHeader;
import de.intarsys.cwt.font.truetype.TTMetrics;
import de.intarsys.cwt.font.truetype.TTNaming;
import de.intarsys.cwt.font.truetype.TTPostScriptInformation;
import de.intarsys.cwt.font.truetype.TTTable;
import de.intarsys.cwt.font.truetype.TrueTypeException;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

public class TTFont {
    public static final int ARG_1_AND_2_ARE_WORDS = 1;
    public static final int MORE_COMPONENTS = 32;
    public static final int SFNT_TRUETYPE = 65536;
    public static final byte[] TABLE_CMAP = "cmap".getBytes();
    public static final byte[] TABLE_CVT = "cvt ".getBytes();
    public static final byte[] TABLE_FGPM = "fpgm".getBytes();
    public static final byte[] TABLE_GLYF = "glyf".getBytes();
    public static final byte[] TABLE_HEAD = "head".getBytes();
    public static final byte[] TABLE_HHEA = "hhea".getBytes();
    public static final byte[] TABLE_HMTX = "hmtx".getBytes();
    public static final byte[] TABLE_LOCA = "loca".getBytes();
    public static final byte[] TABLE_MAXP = "maxp".getBytes();
    public static final byte[] TABLE_NAME = "name".getBytes();
    public static final byte[] TABLE_OS2 = "OS/2".getBytes();
    public static final byte[] TABLE_POST = "post".getBytes();
    public static final byte[] TABLE_PREP = "prep".getBytes();
    public static final int WE_HAVE_A_SCALE = 8;
    public static final int WE_HAVE_A_TWO_BY_TWO = 128;
    public static final int WE_HAVE_AN_X_AND_Y_SCALE = 64;
    private Map cmaps;
    private String fontFamilyName = null;
    private TTFontHeader fontHeader;
    private FontStyle fontStyle = FontStyle.REGULAR;
    private int[] glyphWidths;
    private TTHorizontalHeader horizontalHeader;
    private ILocator locator;
    private TTMetrics metrics;
    private TTNaming naming;
    private TTPostScriptInformation postScriptInformation;
    private String psName = null;
    private int sfntVersion;
    private TTTable[] tables;

    public static int align(int newLength) {
        return newLength + 3 & 0xFFFFFFFC;
    }

    public static TTFont createFromLocator(ILocator locator) throws IOException {
        TTFont result = new TTFont();
        result.setLocator(locator);
        result.initializeFromLocator();
        return result;
    }

    protected TTFont() {
    }

    public Map getCMaps() throws TrueTypeException {
        if (this.cmaps == null) {
            TTFontParser parser = new TTFontParser();
            try {
                this.cmaps = parser.parseTable_cmap(this.getTable(TABLE_CMAP));
            }
            catch (IOException e) {
                throw new TrueTypeException(e.getMessage());
            }
        }
        return this.cmaps;
    }

    public Map getCMapsAt(int platformID, int platformSpecificID) throws TrueTypeException {
        String key = platformID + ":" + platformSpecificID;
        Object result = this.getCMaps().get(key);
        if (result instanceof TTTable) {
            TTFontParser parser = new TTFontParser();
            try {
                Map submap = parser.parseTable_cmap_subtable((TTTable)result);
                this.getCMaps().put(key, submap);
                result = submap;
            }
            catch (IOException e) {
                throw new TrueTypeException(e.getMessage());
            }
        }
        return (Map)result;
    }

    public String getFontFamilyName() {
        return this.fontFamilyName;
    }

    public TTFontHeader getFontHeader() throws TrueTypeException {
        if (this.fontHeader == null) {
            TTFontParser parser = new TTFontParser();
            try {
                this.fontHeader = parser.parseTable_head(this.getTable(TABLE_HEAD));
            }
            catch (IOException e) {
                throw new TrueTypeException(e.getMessage());
            }
        }
        return this.fontHeader;
    }

    public String getFontName() {
        return this.getPsName();
    }

    public FontStyle getFontStyle() {
        return this.fontStyle;
    }

    public int getGlyphWidth(int codePoint) throws TrueTypeException {
        if (codePoint < this.getGlyphWidths().length) {
            return this.getGlyphWidths()[codePoint];
        }
        return this.getGlyphWidths()[this.getGlyphWidths().length - 1];
    }

    protected int[] getGlyphWidths() throws TrueTypeException {
        if (this.glyphWidths == null) {
            TTFontParser parser = new TTFontParser();
            try {
                this.glyphWidths = parser.parseTable_hmtx(this.getTable(TABLE_HMTX), this.getHorizontalHeader().getNumberOfHMetrics());
            }
            catch (IOException e) {
                throw new TrueTypeException(e.getMessage());
            }
        }
        return this.glyphWidths;
    }

    public TTHorizontalHeader getHorizontalHeader() throws TrueTypeException {
        if (this.horizontalHeader == null) {
            TTFontParser parser = new TTFontParser();
            try {
                this.horizontalHeader = parser.parseTable_hhea(this.getTable(TABLE_HHEA));
            }
            catch (IOException e) {
                throw new TrueTypeException(e.getMessage());
            }
        }
        return this.horizontalHeader;
    }

    public ILocator getLocator() {
        return this.locator;
    }

    public TTMetrics getMetrics() throws TrueTypeException {
        if (this.metrics == null) {
            TTFontParser parser = new TTFontParser();
            try {
                this.metrics = parser.parseTable_os2(this.getTable(TABLE_OS2));
            }
            catch (IOException e) {
                throw new TrueTypeException(e.getMessage());
            }
        }
        return this.metrics;
    }

    public TTNaming getNaming() throws TrueTypeException {
        if (this.naming == null) {
            TTFontParser parser = new TTFontParser();
            try {
                TTTable table = this.getTable(TABLE_NAME);
                if (table != null) {
                    this.naming = parser.parseTable_name(table);
                }
            }
            catch (IOException e) {
                throw new TrueTypeException(e.getMessage());
            }
        }
        return this.naming;
    }

    public TTPostScriptInformation getPostScriptInformation() throws TrueTypeException {
        if (this.postScriptInformation == null) {
            TTFontParser parser = new TTFontParser();
            try {
                this.postScriptInformation = parser.parseTable_post(this.getTable(TABLE_POST));
            }
            catch (IOException e) {
                throw new TrueTypeException(e.getMessage());
            }
        }
        return this.postScriptInformation;
    }

    public String getPsName() {
        return this.psName;
    }

    public int getSfntVersion() {
        return this.sfntVersion;
    }

    public TTTable getTable(byte[] name) {
        int i = 0;
        while (i < this.getTables().length) {
            TTTable current = this.tables[i];
            if (Arrays.equals(current.getName(), name)) {
                return current;
            }
            ++i;
        }
        return null;
    }

    public TTTable[] getTables() {
        return this.tables;
    }

    protected void initializeFromLocator() throws IOException {
        IRandomAccess random = null;
        try {
            random = this.getLocator().getRandomAccess();
            TTFontParser parser = new TTFontParser();
            parser.parseTables(this);
            try {
                this.setFontName(this);
            }
            catch (TrueTypeException e) {
                throw new IOException(e.getMessage());
            }
        }
        finally {
            StreamTools.close((IRandomAccess)random);
        }
    }

    public void removeCMapsAt(int platformID, int platformSpecificID) throws TrueTypeException, IOException {
        TTTable data = this.getTable(TABLE_CMAP);
        if (data == null) {
            return;
        }
        IRandomAccess random = data.getRandomAccess();
        TTFontSerializer serializer = new TTFontSerializer();
        TTFontParser parser = new TTFontParser();
        try {
            random.seek(0L);
            short version = parser.readShort(random);
            int count = parser.readUShort(random);
            int i = 0;
            long readPos = random.getOffset();
            long writePos = random.getOffset();
            while (i < count) {
                random.seek(readPos);
                int tempPlatformID = parser.readUShort(random);
                int tempPlatformSpecificID = parser.readUShort(random);
                int offset = parser.readInt(random);
                if (platformID != tempPlatformID || platformSpecificID != tempPlatformSpecificID) {
                    if (readPos != writePos) {
                        random.seek(writePos);
                        serializer.writeShort(random, tempPlatformID);
                        serializer.writeShort(random, tempPlatformSpecificID);
                        serializer.writeInt(random, offset);
                    }
                    writePos += 8L;
                }
                readPos += 8L;
                ++i;
            }
            if (readPos != writePos) {
                random.seek(writePos);
                serializer.writeShort(random, 0);
                serializer.writeShort(random, 0);
                serializer.writeInt(random, 0);
                random.seek(0L);
                random.seekBy(2L);
                serializer.writeShort(random, count - 1);
            }
        }
        finally {
            StreamTools.close((IRandomAccess)random);
        }
        this.cmaps = null;
    }

    protected void setFontFamilyName(String string) {
        this.fontFamilyName = string;
    }

    protected void setFontName(TTFont font) throws TrueTypeException {
        TTNaming tempNaming = font.getNaming();
        if (tempNaming != null) {
            font.setFontFamilyName(tempNaming.getValue(1));
            String styleName = tempNaming.getValue(2);
            font.setFontStyle(FontStyle.getFontStyle(styleName));
            font.setPsName(tempNaming.getValue(6));
            if (font.getPsName() == null) {
                font.setPsName(String.valueOf(font.getFontFamilyName()) + "-" + font.getFontStyle().getId());
            }
        }
    }

    protected void setFontStyle(FontStyle fontStyle) {
        this.fontStyle = fontStyle;
    }

    protected void setLocator(ILocator locator) {
        this.locator = locator;
    }

    public void setPsName(String string) {
        this.psName = string;
    }

    protected void setSfntVersion(int sfntVersion) {
        this.sfntVersion = sfntVersion;
    }

    protected void setTables(TTTable[] tables) {
        this.tables = tables;
    }
}

