/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font;

import de.intarsys.cwt.font.FontStyle;
import de.intarsys.cwt.font.FontTools;
import de.intarsys.cwt.font.IFontQuery;

public class FontQuery
implements IFontQuery {
    private String fontType = null;
    private String fontFamilyName;
    private String fontName;
    private FontStyle fontStyle;

    public FontQuery() {
    }

    public FontQuery(String fontName) {
        this.setFontName(fontName);
    }

    public FontQuery(String family, FontStyle style) {
        this.setFontFamilyName(family);
        this.setFontStyle(style);
    }

    public FontQuery(String family, String style) {
        this.setFontFamilyName(family);
        this.setFontStyle(FontStyle.getFontStyle(style));
    }

    @Override
    public String getFontFamilyName() {
        if (this.fontFamilyName == null) {
            return FontTools.getFontFamilyName(this.fontName);
        }
        return this.fontFamilyName;
    }

    @Override
    public String getFontName() {
        return this.fontName;
    }

    @Override
    public Object getFontNameCanonical() {
        String tempFamilyName = this.getFontFamilyName();
        FontStyle tempStyle = null;
        tempStyle = this.getFontStyle() == null ? FontTools.getFontStyle(this.fontName) : this.getFontStyle();
        return FontTools.createCanonicalName(tempFamilyName, tempStyle.getId());
    }

    @Override
    public FontStyle getFontStyle() {
        return this.fontStyle;
    }

    @Override
    public String getFontType() {
        return this.fontType;
    }

    public void setFontFamilyName(String fontFamilyName) {
        this.fontFamilyName = fontFamilyName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public void setFontStyle(FontStyle fontStyle) {
        this.fontStyle = fontStyle;
    }

    public void setFontType(String fontType) {
        this.fontType = fontType;
    }
}

