/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.type.INativeObject;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeStruct;
import de.intarsys.nativec.type.NativeStructType;

public class StructMember {
    private final INativeType memberType;
    protected final String name;
    protected final int index;
    private final int offset;
    private final NativeStructType structType;

    protected StructMember(NativeStructType structType, String name, int index, INativeType memberType, int offset) {
        this.structType = structType;
        this.name = name;
        this.index = index;
        this.memberType = memberType;
        this.offset = offset;
    }

    public byte getByte(NativeStruct struct, int index) {
        return struct.handle.getByte(this.offset + index);
    }

    public byte[] getByteArray(NativeStruct struct, int index, int count) {
        return struct.handle.getByteArray(this.offset + index, count);
    }

    public long getCLong(NativeStruct struct, int index) {
        return struct.handle.getCLong(this.offset + index);
    }

    public float getFloat(NativeStruct struct, int index) {
        return struct.handle.getFloat(this.offset + index);
    }

    public int getInt(NativeStruct struct, int index) {
        return struct.handle.getInt(this.offset + index);
    }

    public long getLong(NativeStruct struct, int index) {
        return struct.handle.getLong(this.offset + index);
    }

    protected INativeType getMemberType() {
        return this.memberType;
    }

    public String getName() {
        return this.name;
    }

    public INativeHandle getNativeHandle(NativeStruct struct, int index) {
        return struct.handle.getNativeHandle(this.offset + index);
    }

    public synchronized INativeObject getNativeObject(NativeStruct struct) {
        INativeObject result;
        if (struct.values == null) {
            struct.values = new INativeObject[this.structType.getFieldsSize()];
        }
        if ((result = struct.values[this.index]) == null) {
            struct.values[this.index] = result = this.memberType.createNative(struct.getNativeHandle().offset(this.offset));
        }
        return result;
    }

    protected int getOffset() {
        return this.offset;
    }

    public short getShort(NativeStruct struct, int index) {
        return struct.handle.getShort(this.offset + index);
    }

    public String getString(NativeStruct struct, int index) {
        return struct.handle.getString(this.offset + index);
    }

    public Object getValue(NativeStruct struct) {
        return this.getNativeObject(struct).getValue();
    }

    public String getWideString(NativeStruct struct, int index) {
        return struct.handle.getWideString(this.offset + index);
    }

    public void setByte(NativeStruct struct, int index, byte value) {
        struct.handle.setByte(this.offset + index, value);
    }

    public void setByteArray(NativeStruct struct, int index, byte[] value, int valueOffset, int valueCount) {
        struct.handle.setByteArray(this.offset + index, value, valueOffset, valueCount);
    }

    public void setCLong(NativeStruct struct, int index, long value) {
        struct.handle.setCLong(this.offset + index, value);
    }

    public void setInt(NativeStruct struct, int index, int value) {
        struct.handle.setInt(this.offset + index, value);
    }

    public void setLong(NativeStruct struct, int index, long value) {
        struct.handle.setLong(this.offset + index, value);
    }

    public void setNativeHandle(NativeStruct struct, int index, INativeHandle value) {
        struct.handle.setNativeHandle(this.offset + index, value);
    }

    public void setShort(NativeStruct struct, int index, short value) {
        struct.handle.setShort(this.offset + index, value);
    }

    public void setString(NativeStruct struct, int index, String value) {
        struct.handle.setString(this.offset + index, value);
    }

    public void setValue(NativeStruct struct, Object value) {
        this.getNativeObject(struct).setValue(value);
    }

    public void setWideString(NativeStruct struct, int index, String value) {
        struct.handle.setWideString(this.offset + index, value);
    }

    public String toString() {
        return "[" + this.getName() + "]";
    }
}

