/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.type.INativeObject;
import de.intarsys.nativec.type.NativeGenericStruct;
import de.intarsys.nativec.type.NativeObject;
import de.intarsys.nativec.type.NativeStructType;
import de.intarsys.nativec.type.NativeType;
import de.intarsys.nativec.type.StructMember;

public abstract class NativeStruct
extends NativeObject {
    public static final NativeStructType META = new NativeStructType();
    protected INativeObject[] values;

    public NativeStruct() {
    }

    public NativeStruct(INativeHandle handle) {
        super(handle);
    }

    @Override
    public int getByteCount() {
        return this.getNativeType().getByteCount();
    }

    public INativeObject getNativeObject(String name) {
        return this.getStructType().getNativeObject(this, name);
    }

    protected StructMember getStructField(String name) {
        return this.getStructType().getField(name);
    }

    public NativeStructType getStructType() {
        return (NativeStructType)this.getNativeType();
    }

    @Override
    public Object getValue() {
        throw new UnsupportedOperationException("getValue not implemented for NativeStruct");
    }

    @Override
    public void setValue(Object value) {
        throw new UnsupportedOperationException("getValue not implemented for NativeStruct");
    }

    @Override
    public String toNestedString() {
        return "Struct " + this.getClass().getName();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("\n");
        for (StructMember field : this.getStructType().getFields()) {
            sb.append(field.getName());
            sb.append("=");
            try {
                sb.append(this.getNativeObject(field.getName()).toString());
            }
            catch (RuntimeException e) {
                sb.append("**error**");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    static {
        NativeType.register(NativeGenericStruct.class, META);
    }
}

