/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.NativeTools;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeFloatType;
import de.intarsys.nativec.type.NativeNumber;

public class NativeFloat
extends NativeNumber {
    public static final NativeFloatType META = new NativeFloatType();

    public static NativeFloat createFromAddress(long address) {
        return (NativeFloat)META.createNative(NativeTools.toHandle(address));
    }

    public NativeFloat() {
        this.allocate();
    }

    protected NativeFloat(INativeHandle handle) {
        super(handle);
    }

    public NativeFloat(float value) {
        this.allocate();
        this.setValue(value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.floatValue();
    }

    @Override
    public INativeType getNativeType() {
        return META;
    }

    @Override
    public float floatValue() {
        return this.handle.getFloat(0);
    }

    @Override
    public Object getValue() {
        return Float.valueOf(this.floatValue());
    }

    @Override
    public int intValue() {
        return (int)this.floatValue();
    }

    @Override
    public long longValue() {
        return (long)this.floatValue();
    }

    @Override
    public void setValue(Object value) {
        this.setValue(((Number)value).floatValue());
    }

    public void setValue(float value) {
        this.handle.setFloat(0, value);
    }

    @Override
    public short shortValue() {
        return (short)this.floatValue();
    }

    public String toString() {
        if (this.getNativeHandle() == null) {
            return "nope - no handle";
        }
        if (this.getNativeHandle().getAddress() == 0L) {
            return "nope - null pointer";
        }
        return String.valueOf(this.floatValue());
    }
}

