/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.NativeInterface;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeBufferType;
import de.intarsys.nativec.type.NativeObject;
import de.intarsys.nativec.type.NativeType;
import java.nio.ByteBuffer;

public class NativeBuffer
extends NativeObject {
    public static final NativeBufferType META = new NativeBufferType();
    private NativeBufferType type;

    public NativeBuffer(byte[] bytes) {
        this.type = new NativeBufferType(bytes.length);
        this.handle = NativeInterface.get().allocate(bytes.length);
        this.handle.setByteArray(0, bytes, 0, bytes.length);
    }

    protected NativeBuffer(INativeHandle handle) {
        super(handle);
    }

    public NativeBuffer(int pSize) {
        this.type = new NativeBufferType(pSize);
        this.handle = NativeInterface.get().allocate(pSize);
    }

    @Override
    public int getByteCount() {
        return this.type.getByteCount();
    }

    @Override
    public INativeType getNativeType() {
        return META;
    }

    public int getSize() {
        return this.type.getByteCount();
    }

    @Override
    public Object getValue() {
        return this.getBytes();
    }

    public void setSize(int size) {
        this.type = new NativeBufferType(size);
        this.handle.setSize(this.getByteCount());
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof byte[]) {
            byte[] data = (byte[])value;
            this.setByteArray(0, data, 0, data.length);
        } else if (value instanceof ByteBuffer) {
            byte[] data = new byte[this.getSize()];
            ((ByteBuffer)value).get(data);
            this.setByteArray(0, data, 0, data.length);
        }
    }

    static {
        NativeType.register(NativeBuffer.class, META);
    }
}

