/*
 * Decompiled with CFR 0.152.
 */
package de.informaticum.xjc.util;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.model.CAttributePropertyInfo;
import com.sun.tools.xjc.model.CElementPropertyInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CReferencePropertyInfo;
import com.sun.tools.xjc.model.CValuePropertyInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.CustomizableOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.outline.PackageOutline;
import de.informaticum.xjc.util.CodeModelAnalysis;
import de.informaticum.xjc.util.Lenience;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.OptionalAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum OutlineAnalysis {

    private static final Logger LOG = LoggerFactory.getLogger(OutlineAnalysis.class);
    private static final String MISSING_JAVA_DEFAULT_VALUE = "Lexical Java representation of the existing XSD default value for [{}#{}] is [{}]!";
    private static boolean DEFAULT_BOOLEAN;
    private static byte DEFAULT_BYTE;
    private static char DEFAULT_CHAR;
    private static double DEFAULT_DOUBLE;
    private static float DEFAULT_FLOAT;
    private static int DEFAULT_INT;
    private static long DEFAULT_LONG;
    private static short DEFAULT_SHORT;
    public static final String CREATE = "create";
    public static final String BUILDER = "Builder";
    public static final String GET = "get";
    public static final String IS = "is";
    public static final String SET = "set";
    public static final String WITH = "with";
    public static final String WITHOUT = "without";
    public static final String ADD = "add";
    public static final String REMOVE = "remove";
    private static final String WITH_ADDITIONAL = "withAdditional";
    private static final String WITHOUT_SPECIFIC = "withoutSpecific";

    public static final String fullNameOf(PackageOutline pakkage) {
        return pakkage._package().name();
    }

    public static final String fullNameOf(CustomizableOutline type) {
        return type.getImplClass().fullName();
    }

    public static final String javadocNameOf(CustomizableOutline type) {
        return CodeModelAnalysis.javadocNameOf((JType)type.getImplClass());
    }

    public static final boolean isRequired(FieldOutline field) {
        CPropertyInfo property = field.getPropertyInfo();
        if (property instanceof CElementPropertyInfo) {
            return ((CElementPropertyInfo)property).isRequired();
        }
        if (property instanceof CReferencePropertyInfo) {
            return ((CReferencePropertyInfo)property).isRequired();
        }
        if (property instanceof CAttributePropertyInfo) {
            return ((CAttributePropertyInfo)property).isRequired();
        }
        if (property instanceof CValuePropertyInfo) {
            return false;
        }
        return false;
    }

    public static final boolean isOptional(FieldOutline field) {
        return !OutlineAnalysis.isRequired(field);
    }

    public static final Optional<JExpression> defaultExpressionFor(FieldOutline field, boolean initCollections, boolean unmodifiableCollections) {
        JType $raw;
        Outline outline = field.parent().parent();
        JCodeModel $model = outline.getCodeModel();
        CPropertyInfo property = field.getPropertyInfo();
        if (property.defaultValue != null) {
            Assertions.assertThat((boolean)property.isCollection()).isFalse();
            JExpression $default = property.defaultValue.compute(outline);
            if ($default != null) {
                return Optional.of($default);
            }
            LOG.error(MISSING_JAVA_DEFAULT_VALUE, new Object[]{field.parent().getImplClass().fullName(), property.getName(false), $default});
            if (!Lenience.LENIENT) {
                ((ObjectAssert)Assertions.assertThat((Object)$default).withFailMessage(Lenience.LENIENT_BREAKPOINT_MESSAGE, new Object[0])).isNotNull();
            }
        }
        if (($raw = field.getRawType()).equals($model.BOOLEAN)) {
            return Optional.of(JExpr.lit((boolean)DEFAULT_BOOLEAN));
        }
        if ($raw.equals($model.BYTE)) {
            return Optional.of(JExpr.lit((int)DEFAULT_BYTE));
        }
        if ($raw.equals($model.CHAR)) {
            return Optional.of(JExpr.lit((char)DEFAULT_CHAR));
        }
        if ($raw.equals($model.DOUBLE)) {
            return Optional.of(JExpr.lit((double)DEFAULT_DOUBLE));
        }
        if ($raw.equals($model.FLOAT)) {
            return Optional.of(JExpr.lit((float)DEFAULT_FLOAT));
        }
        if ($raw.equals($model.INT)) {
            return Optional.of(JExpr.lit((int)DEFAULT_INT));
        }
        if ($raw.equals($model.LONG)) {
            return Optional.of(JExpr.lit((long)DEFAULT_LONG));
        }
        if ($raw.equals($model.SHORT)) {
            return Optional.of(JExpr.lit((int)DEFAULT_SHORT));
        }
        if (property.isCollection() && initCollections) {
            return Optional.of(unmodifiableCollections ? CodeModelAnalysis.emptyImmutableInstanceOf($raw) : CodeModelAnalysis.emptyModifiableInstanceOf($raw));
        }
        return Optional.empty();
    }

    public static final String guessGetterName(FieldOutline field) {
        boolean isBoolean = field.parent().parent().getCodeModel().BOOLEAN.equals(field.getRawType().boxify().getPrimitiveType());
        if (field.parent().parent().getModel().options.enableIntrospection) {
            return (field.getRawType().isPrimitive() && isBoolean ? IS : GET) + field.getPropertyInfo().getName(true);
        }
        return (isBoolean ? IS : GET) + field.getPropertyInfo().getName(true);
    }

    public static final String guessSetterName(FieldOutline field) {
        return SET + field.getPropertyInfo().getName(true);
    }

    public static final String guessWitherName(FieldOutline field) {
        return WITH + field.getPropertyInfo().getName(true);
    }

    public static final String guessWithouterName(FieldOutline field) {
        return WITHOUT + field.getPropertyInfo().getName(true);
    }

    public static final String guessAdderName(FieldOutline field) {
        return ADD + field.getPropertyInfo().getName(true);
    }

    public static final String guessRemoverName(FieldOutline field) {
        return REMOVE + field.getPropertyInfo().getName(true);
    }

    public static final String guessWithAdditionalName(FieldOutline field) {
        return WITH_ADDITIONAL + field.getPropertyInfo().getName(true);
    }

    public static final String guessWithoutSpecificName(FieldOutline field) {
        return WITHOUT_SPECIFIC + field.getPropertyInfo().getName(true);
    }

    public static final String guessFactoryName(ClassOutline clazz) {
        return CREATE + clazz.target.getSqueezedName();
    }

    public static final String guessBuilderName(ClassOutline clazz) {
        String prefix = BUILDER.equals(clazz.getImplClass().name()) ? clazz.getImplClass().name() : "";
        return prefix + BUILDER;
    }

    private static final LinkedHashMap<FieldOutline, JFieldVar> declaredPropertiesOf(ClassOutline clazz) {
        LinkedHashMap<FieldOutline, JFieldVar> properties = new LinkedHashMap<FieldOutline, JFieldVar>();
        if (clazz == null) {
            return properties;
        }
        for (FieldOutline field : clazz.getDeclaredFields()) {
            String name = field.getPropertyInfo().getName(false);
            JFieldVar $field = (JFieldVar)clazz.getImplClass().fields().get(name);
            if ($field == null) {
                LOG.warn("There is no according Java field in class [{}] for declared outline field [{}].", (Object)clazz.getImplClass().fullName(), (Object)name);
            }
            properties.put(field, $field);
        }
        if (clazz.getImplClass().fields().size() - properties.size() != 0) {
            HashMap $fields = new HashMap(clazz.getImplClass().fields());
            $fields.values().removeAll(properties.values());
            LOG.warn("Java class [{}] contains fields that are not caused by declared outline fields: {}", (Object)clazz.getImplClass().fullName(), $fields.keySet());
        }
        return properties;
    }

    public static final LinkedHashMap<FieldOutline, JFieldVar> generatedPropertiesOf(ClassOutline clazz) {
        LinkedHashMap<FieldOutline, JFieldVar> properties = OutlineAnalysis.declaredPropertiesOf(clazz);
        properties.entrySet().removeIf(property -> property.getValue() == null);
        return properties;
    }

    private static final LinkedHashMap<FieldOutline, JFieldVar> superAndDeclaredPropertiesOf(ClassOutline clazz) {
        LinkedHashMap<FieldOutline, JFieldVar> properties = new LinkedHashMap<FieldOutline, JFieldVar>();
        if (clazz != null) {
            properties.putAll(OutlineAnalysis.superAndDeclaredPropertiesOf(clazz.getSuperClass()));
            properties.putAll(OutlineAnalysis.declaredPropertiesOf(clazz));
        }
        return properties;
    }

    public static final LinkedHashMap<FieldOutline, JFieldVar> superAndGeneratedPropertiesOf(ClassOutline clazz) {
        LinkedHashMap<FieldOutline, JFieldVar> properties = OutlineAnalysis.superAndDeclaredPropertiesOf(clazz);
        properties.entrySet().removeIf(property -> property.getValue() == null);
        return properties;
    }

    public static final <K, M extends Map<? extends K, ?>> M filter(M all, Predicate<? super K> filter) {
        all.entrySet().removeIf(e -> filter.negate().test(e.getKey()));
        return all;
    }

    public static final Optional<JMethod> getConstructor(ClassOutline clazz) {
        return CodeModelAnalysis.getConstructor(clazz.getImplClass());
    }

    public static final Optional<JMethod> getConstructor(ClassOutline clazz, ClassOutline ... argumentTypes) {
        JType[] $types = (JType[])Arrays.stream(argumentTypes).map(ClassOutline::getImplClass).toArray(JType[]::new);
        return CodeModelAnalysis.getConstructor(clazz.getImplClass(), $types);
    }

    public static final Optional<JMethod> getConstructor(ClassOutline clazz, Class<?> ... argumentTypes) {
        JType[] $types = (JType[])Arrays.stream(argumentTypes).map(arg_0 -> ((JCodeModel)clazz.parent().getCodeModel()).ref(arg_0)).toArray(JType[]::new);
        return CodeModelAnalysis.getConstructor(clazz.getImplClass(), $types);
    }

    public static final Optional<JMethod> getConstructor(ClassOutline clazz, JVar ... $argumentTypes) {
        JType[] $types = (JType[])Arrays.stream($argumentTypes).map(JVar::type).toArray(JType[]::new);
        return CodeModelAnalysis.getConstructor(clazz.getImplClass(), $types);
    }

    public static final Optional<JMethod> getConstructor(ClassOutline clazz, JType ... $argumentTypes) {
        return CodeModelAnalysis.getConstructor(clazz.getImplClass(), $argumentTypes);
    }

    public static final Optional<JMethod> getConstructor(ClassOutline clazz, LinkedHashMap<? extends FieldOutline, ? extends JFieldVar> properties) {
        JType[] $types = (JType[])properties.values().stream().map(JVar::type).toArray(JType[]::new);
        return CodeModelAnalysis.getConstructor(clazz.getImplClass(), $types);
    }

    public static final List<JMethod> getConstructors(ClassOutline clazz, Predicate<? super JMethod> filter) {
        return CodeModelAnalysis.getConstructors(clazz.getImplClass(), filter);
    }

    public static final Optional<JMethod> getMethod(ClassOutline clazz, String name) {
        return CodeModelAnalysis.getMethod(clazz.getImplClass(), name);
    }

    public static final Optional<JMethod> getMethod(ClassOutline clazz, String name, ClassOutline ... argumentTypes) {
        JType[] $types = (JType[])Arrays.stream(argumentTypes).map(ClassOutline::getImplClass).toArray(JType[]::new);
        return CodeModelAnalysis.getMethod(clazz.getImplClass(), name, $types);
    }

    public static final Optional<JMethod> getMethod(ClassOutline clazz, String name, Class<?> ... argumentTypes) {
        JType[] $types = (JType[])Arrays.stream(argumentTypes).map(arg_0 -> ((JCodeModel)clazz.parent().getCodeModel()).ref(arg_0)).toArray(JType[]::new);
        return CodeModelAnalysis.getMethod(clazz.getImplClass(), name, $types);
    }

    public static final Optional<JMethod> getMethod(ClassOutline clazz, String name, JVar ... $argumentTypes) {
        JType[] $types = (JType[])Arrays.stream($argumentTypes).map(JVar::type).toArray(JType[]::new);
        return CodeModelAnalysis.getMethod(clazz.getImplClass(), name, $types);
    }

    public static final Optional<JMethod> getMethod(ClassOutline clazz, String name, JType ... $argumentTypes) {
        return CodeModelAnalysis.getMethod(clazz.getImplClass(), name, $argumentTypes);
    }

    public static final Optional<JMethod> getMethod(ClassOutline clazz, String name, LinkedHashMap<? extends FieldOutline, ? extends JFieldVar> properties) {
        JType[] $types = (JType[])properties.values().stream().map(JVar::type).toArray(JType[]::new);
        return CodeModelAnalysis.getMethod(clazz.getImplClass(), name, $types);
    }

    public static final List<JMethod> getMethods(ClassOutline clazz, Predicate<? super JMethod> filter) {
        return CodeModelAnalysis.getMethods(clazz.getImplClass(), filter);
    }

    public static final LinkedHashMap<FieldOutline, Map.Entry<JFieldVar, JMethod>> generatedGettersOf(ClassOutline clazz) {
        LinkedHashMap<FieldOutline, Map.Entry<JFieldVar, JMethod>> getters = new LinkedHashMap<FieldOutline, Map.Entry<JFieldVar, JMethod>>();
        for (Map.Entry<FieldOutline, JFieldVar> property : OutlineAnalysis.generatedPropertiesOf(clazz).entrySet()) {
            FieldOutline field = property.getKey();
            JFieldVar $field = property.getValue();
            String getterName = OutlineAnalysis.guessGetterName(field);
            Optional<JMethod> $getterLookup = OutlineAnalysis.getMethod(clazz, getterName);
            if ($getterLookup.isPresent()) {
                JMethod $getter = $getterLookup.get();
                Assertions.assertThat(($getter.type().boxify().equals($field.type().boxify()) || CodeModelAnalysis.deoptionalisedTypeFor($getter.type().boxify()).isPresent() && CodeModelAnalysis.deoptionalisedTypeFor($getter.type().boxify()).get().boxify().equals($field.type().boxify()) ? 1 : 0) != 0).isTrue();
                getters.put(field, new AbstractMap.SimpleImmutableEntry<JFieldVar, JMethod>($field, $getter));
                continue;
            }
            LOG.error("Unexpectedly, there is no getter method [#{}()] for declared field {} of class [{}].", new Object[]{getterName, $field.name(), clazz.getImplClass().fullName()});
            if (Lenience.LENIENT) continue;
            ((OptionalAssert)Assertions.assertThat($getterLookup).withFailMessage(Lenience.LENIENT_BREAKPOINT_MESSAGE, new Object[0])).isNotEmpty();
        }
        return getters;
    }

    public static final LinkedHashMap<FieldOutline, Map.Entry<JFieldVar, JMethod>> generatedSettersOf(ClassOutline clazz) {
        LinkedHashMap<FieldOutline, Map.Entry<JFieldVar, JMethod>> setters = new LinkedHashMap<FieldOutline, Map.Entry<JFieldVar, JMethod>>();
        for (Map.Entry<FieldOutline, JFieldVar> property : OutlineAnalysis.generatedPropertiesOf(clazz).entrySet()) {
            FieldOutline field = property.getKey();
            JFieldVar $field = property.getValue();
            String setterName = OutlineAnalysis.guessSetterName(field);
            Optional<JMethod> $setterLookup = OutlineAnalysis.getMethod(clazz, setterName, $field.type());
            if ($setterLookup.isPresent()) {
                JMethod $setter = $setterLookup.get();
                Assertions.assertThat((Comparable)$setter.type()).isEqualByComparingTo((Comparable)clazz.getImplClass().owner().VOID);
                setters.put(field, new AbstractMap.SimpleImmutableEntry<JFieldVar, JMethod>($field, $setter));
                continue;
            }
            if (field.getPropertyInfo().isCollection()) {
                LOG.info("Expectedly, there is no setter method [{}#{}({})] for declared collection field [{}].", new Object[]{clazz.getImplClass().fullName(), setterName, $field.type(), $field.name()});
                continue;
            }
            LOG.error("Unexpectedly, there is no setter method [{}#{}({})] for declared field [{}].", new Object[]{clazz.getImplClass().fullName(), setterName, $field.type(), $field.name()});
            if (Lenience.LENIENT) continue;
            ((OptionalAssert)Assertions.assertThat($setterLookup).withFailMessage(Lenience.LENIENT_BREAKPOINT_MESSAGE, new Object[0])).isNotEmpty();
        }
        return setters;
    }

    public static final Optional<JDefinedClass> getEmbeddedClass(ClassOutline clazz, String name) {
        return CodeModelAnalysis.getEmbeddedClass(clazz.getImplClass(), name);
    }
}

