/*
 * Decompiled with CFR 0.152.
 */
package de.informaticum.xjc.util;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import de.informaticum.xjc.util.CodeModelAnalysis;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;

public enum CodeRetrofit {

    static final String ANNOTATION_MEMBERS = "memberValues";
    static final String BODY_FIELD = "body";
    private static final String JAVADOC_HARD_BREAK = String.format("%n%n", new Object[0]);
    private static final String JAVADOC_SOFT_BREAK = String.format("%n", new Object[0]);
    public static final String COPY_JAVADOC = "###-Copy-Javadoc-Marker-###";

    public static final <JCP extends JCommentPart> JCP eraseJavadoc(JCP $javadoc) {
        $javadoc.clear();
        return $javadoc;
    }

    public static final JDocComment javadocSection(JDocCommentable $javadoc) {
        return CodeRetrofit.javadocSection($javadoc.javadoc());
    }

    public static final JCommentPart javadocSection(JCommentPart $javadoc) {
        return $javadoc.isEmpty() ? $javadoc : $javadoc.append((Object)JAVADOC_HARD_BREAK);
    }

    public static final JDocComment javadocSection(JDocComment $javadoc) {
        return $javadoc.isEmpty() ? $javadoc : $javadoc.append((Object)JAVADOC_HARD_BREAK);
    }

    public static final JDocComment javadocBreak(JDocCommentable $javadoc) {
        return CodeRetrofit.javadocBreak($javadoc.javadoc());
    }

    public static final JCommentPart javadocBreak(JCommentPart $javadoc) {
        return $javadoc.isEmpty() ? $javadoc : $javadoc.append((Object)JAVADOC_SOFT_BREAK);
    }

    public static final JDocComment javadocBreak(JDocComment $javadoc) {
        return $javadoc.isEmpty() ? $javadoc : $javadoc.append((Object)JAVADOC_SOFT_BREAK);
    }

    public static final JBlock eraseBody(JMethod $method) {
        try {
            Field internalBodyField = JMethod.class.getDeclaredField(BODY_FIELD);
            internalBodyField.setAccessible(true);
            internalBodyField.set($method, null);
            return $method.body();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException seriousProblem) {
            throw new RuntimeException(seriousProblem);
        }
    }

    public static final void relayThrows(JMethod $origin, JMethod $caller) {
        CodeRetrofit.relayThrows($origin, $caller, null);
    }

    public static final void relayThrows(JMethod $origin, JMethod $caller, String reason) {
        Map<JClass, JCommentPart> javadocThrows = CodeModelAnalysis.allJavadocThrows($origin);
        for (JClass $throwable : CodeModelAnalysis.allThrows($origin)) {
            $caller._throws($throwable);
            if (reason == null) continue;
            if (COPY_JAVADOC.equals(reason)) {
                Assertions.assertThat(javadocThrows).containsKey((Object)$throwable);
                $caller.javadoc().addThrows($throwable).addAll((Collection)$origin.javadoc().addThrows($throwable));
                continue;
            }
            $caller.javadoc().addThrows($throwable).append((Object)reason);
        }
    }

    public static final void relayParamDoc(JMethod $origin, JMethod $caller, JVar $param) {
        Map<String, JCommentPart> javadocParams = CodeModelAnalysis.allJavadocParams($origin);
        Assertions.assertThat(javadocParams).containsKey((Object)$param.name());
        $caller.javadoc().addParam($param).addAll((Collection)$origin.javadoc().addParam($param));
    }

    public static final JAnnotationUse copyAnnotation(JAnnotationUse $annotation, JAnnotatable $target) {
        JAnnotationUse $copy = $target.annotate($annotation.getAnnotationClass());
        $copy.getAnnotationMembers();
        try {
            Field internalMembersField = JAnnotationUse.class.getDeclaredField(ANNOTATION_MEMBERS);
            internalMembersField.setAccessible(true);
            Map $members = (Map)internalMembersField.get($copy);
            if ($members == null) {
                internalMembersField.set($copy, new LinkedHashMap());
                $members = (Map)internalMembersField.get($copy);
            }
            Assertions.assertThat((Map)$members).isNotNull();
            $members.putAll($annotation.getAnnotationMembers());
            return $copy;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException seriousProblem) {
            throw new RuntimeException(seriousProblem);
        }
    }
}

