/*
 * Decompiled with CFR 0.152.
 */
package de.informaticum.xjc.util;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JGenerable;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JMods;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.SortedSet;
import java.util.Spliterators;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.xml.bind.JAXBElement;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.OptionalAssert;
import org.assertj.core.api.OptionalDoubleAssert;
import org.assertj.core.api.OptionalIntAssert;
import org.assertj.core.api.OptionalLongAssert;

public enum CodeModelAnalysis {

    static final String ATTHROWS_FIELD = "atThrows";
    static final String ATPARAMS_FIELD = "atParams";
    static final String GETTHROWS_METHOD = "getThrows";
    static final String JDOC_FIELD = "jdoc";
    static final String OUTER_FIELD = "outer";
    private static final Class<?>[] DIAMOND = new Class[0];
    private static final String UNEXPECTED_MODIFICATION = "WTF! The long-time existing constructor/factory-method has been modified ;-(";
    public static final JExpression $super = JExpr._super();
    public static final JExpression $this = JExpr._this();
    public static final JExpression $null = JExpr._null();

    private static boolean hasModifier(JMods mods, int lookup) {
        return (mods.getValue() & lookup) != 0;
    }

    public static boolean isPublic(JMods mods) {
        return CodeModelAnalysis.hasModifier(mods, 1);
    }

    public static boolean isProtected(JMods mods) {
        return CodeModelAnalysis.hasModifier(mods, 2);
    }

    public static boolean isPrivate(JMods mods) {
        return CodeModelAnalysis.hasModifier(mods, 4);
    }

    public static boolean isFinal(JMods mods) {
        return CodeModelAnalysis.hasModifier(mods, 8);
    }

    public static boolean isStatic(JMods mods) {
        return CodeModelAnalysis.hasModifier(mods, 16);
    }

    public static boolean isTransient(JMods mods) {
        return CodeModelAnalysis.hasModifier(mods, 256);
    }

    public static boolean isVolatile(JMods mods) {
        return CodeModelAnalysis.hasModifier(mods, 512);
    }

    public static JType[] erasure(JType ... $types) {
        return (JType[])Arrays.stream($types).map(JType::erasure).toArray(JType[]::new);
    }

    public static final boolean isPrimitiveOptionalType(JType $type) {
        JCodeModel $model = $type.owner();
        JType $raw = $type.erasure();
        return $model.ref(OptionalDouble.class).equals($raw) || $model.ref(OptionalInt.class).equals($raw) || $model.ref(OptionalLong.class).equals($raw);
    }

    public static final boolean isOptionalType(JType $type) {
        JCodeModel $model = $type.owner();
        JType $raw = $type.erasure();
        return CodeModelAnalysis.isPrimitiveOptionalType($type) || $model.ref(Optional.class).equals($raw);
    }

    public static final JClass optionalTypeFor(JType $type) {
        JCodeModel $model = $type.owner();
        JType $primitive = $type.unboxify();
        if ($model.DOUBLE.equals($primitive)) {
            ((OptionalDoubleAssert)Assertions.assertThat((OptionalDouble)OptionalDouble.empty()).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).isNotPresent();
            ((OptionalDoubleAssert)Assertions.assertThat((OptionalDouble)OptionalDouble.of(0.0)).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).hasValue(0.0);
            return $model.ref(OptionalDouble.class);
        }
        if ($model.INT.equals($primitive)) {
            ((OptionalIntAssert)Assertions.assertThat((OptionalInt)OptionalInt.empty()).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).isNotPresent();
            ((OptionalIntAssert)Assertions.assertThat((OptionalInt)OptionalInt.of(0)).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).hasValue(0);
            return $model.ref(OptionalInt.class);
        }
        if ($model.LONG.equals($primitive)) {
            ((OptionalLongAssert)Assertions.assertThat((OptionalLong)OptionalLong.empty()).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).isNotPresent();
            ((OptionalLongAssert)Assertions.assertThat((OptionalLong)OptionalLong.of(0L)).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).hasValue(0L);
            return $model.ref(OptionalLong.class);
        }
        ((OptionalAssert)Assertions.assertThat(Optional.empty()).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).isNotPresent();
        ((OptionalAssert)Assertions.assertThat(Optional.of("")).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).hasValue((Object)"");
        return $model.ref(Optional.class).narrow($type.boxify());
    }

    public static final Optional<JType> deoptionalisedTypeFor(JClass $Class) {
        JCodeModel $model = $Class.owner();
        JClass $Raw = $Class.erasure();
        if ($model.ref(OptionalDouble.class).equals($Raw)) {
            return Optional.of($model.DOUBLE);
        }
        if ($model.ref(OptionalInt.class).equals($Raw)) {
            return Optional.of($model.INT);
        }
        if ($model.ref(OptionalLong.class).equals($Raw)) {
            return Optional.of($model.LONG);
        }
        if ($model.ref(Optional.class).equals($Raw)) {
            List $Narrowed = $Class.getTypeParameters();
            if ($Narrowed.isEmpty()) {
                return Optional.of($model.ref(Object.class));
            }
            Assertions.assertThat(($Narrowed.size() == 1 ? 1 : 0) != 0);
            return Optional.of((JType)$Narrowed.get(0));
        }
        return Optional.empty();
    }

    public static final boolean isCollectionType(JType $type) {
        JCodeModel $model = $type.owner();
        JClass $Raw = $type.boxify().erasure();
        return $model.ref(Collection.class).isAssignableFrom($Raw);
    }

    public static final JClass typeParameterOf(JClass $Class) {
        JCodeModel $model = $Class.owner();
        List $Narrowed = $Class.getTypeParameters();
        if ($Narrowed.isEmpty()) {
            return $model.ref(Object.class);
        }
        return (JClass)$Narrowed.get(0);
    }

    public static final JType pecsProducerTypeOf(JType $type) {
        JCodeModel $model = $type.owner();
        JClass $JAXBElement = $model.ref(JAXBElement.class);
        JClass $Class = $type.boxify();
        List typeParameters = $Class.getTypeParameters();
        if (typeParameters.isEmpty()) {
            return $type;
        }
        if ($JAXBElement.isAssignableFrom($Class.erasure())) {
            return $type;
        }
        return $Class.erasure().narrow(typeParameters.stream().map(JClass::wildcard).collect(Collectors.toList()));
    }

    public static final JInvocation emptyImmutableInstanceOf(JType $type) throws IllegalArgumentException {
        JCodeModel $model = $type.owner();
        JClass $Collections = $model.ref(Collections.class);
        JClass $Raw = $type.boxify().erasure();
        if ($model.ref(NavigableSet.class).isAssignableFrom($Raw)) {
            ((AbstractCollectionAssert)Assertions.assertThat(Collections.emptyNavigableSet()).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).isEmpty();
            return $Collections.staticInvoke("emptyNavigableSet");
        }
        if ($model.ref(SortedSet.class).isAssignableFrom($Raw)) {
            ((AbstractCollectionAssert)Assertions.assertThat(Collections.emptySortedSet()).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).isEmpty();
            return $Collections.staticInvoke("emptySortedSet");
        }
        if ($model.ref(Set.class).isAssignableFrom($Raw)) {
            ((AbstractCollectionAssert)Assertions.assertThat(Collections.emptySet()).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).isEmpty();
            return $Collections.staticInvoke("emptySet");
        }
        if ($model.ref(List.class).isAssignableFrom($Raw)) {
            ((ListAssert)Assertions.assertThat(Collections.emptyList()).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).isEmpty();
            return $Collections.staticInvoke("emptyList");
        }
        if ($model.ref(Collection.class).isAssignableFrom($Raw)) {
            ((ListAssert)Assertions.assertThat(Collections.emptyList()).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).isEmpty();
            return $Collections.staticInvoke("emptyList");
        }
        throw new IllegalArgumentException("There is no empty-collection instance of type " + $type);
    }

    public static final JInvocation emptyModifiableInstanceOf(JType $type) throws IllegalArgumentException {
        JCodeModel model = $type.owner();
        JClass $Raw = $type.boxify().erasure();
        if (model.ref(NavigableSet.class).isAssignableFrom($Raw)) {
            ((AbstractCollectionAssert)Assertions.assertThat(new TreeSet()).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).isEmpty();
            return JExpr._new((JClass)model.ref(TreeSet.class).narrow((Class[])DIAMOND));
        }
        if (model.ref(SortedSet.class).isAssignableFrom($Raw)) {
            ((AbstractCollectionAssert)Assertions.assertThat(new TreeSet()).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).isEmpty();
            return JExpr._new((JClass)model.ref(TreeSet.class).narrow((Class[])DIAMOND));
        }
        if (model.ref(Set.class).isAssignableFrom($Raw)) {
            ((AbstractCollectionAssert)Assertions.assertThat(new HashSet()).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).isEmpty();
            return JExpr._new((JClass)model.ref(HashSet.class).narrow((Class[])DIAMOND));
        }
        if (model.ref(List.class).isAssignableFrom($Raw)) {
            ((ListAssert)Assertions.assertThat(new ArrayList()).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).isEmpty();
            return JExpr._new((JClass)model.ref(ArrayList.class).narrow((Class[])DIAMOND));
        }
        if (model.ref(Collection.class).isAssignableFrom($Raw)) {
            ((ListAssert)Assertions.assertThat(new ArrayList()).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).isEmpty();
            return JExpr._new((JClass)model.ref(ArrayList.class).narrow((Class[])DIAMOND));
        }
        throw new IllegalArgumentException("There is no default-collection instance of type " + $type);
    }

    public static final JInvocation copyFactoryFor(JType $type) throws IllegalArgumentException {
        JCodeModel model = $type.owner();
        JClass $Raw = $type.boxify().erasure();
        if (model.ref(NavigableSet.class).isAssignableFrom($Raw)) {
            ((AbstractCollectionAssert)Assertions.assertThat(new TreeSet(Collections.emptySortedSet())).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).isEmpty();
            return JExpr._new((JClass)model.ref(TreeSet.class).narrow((Class[])DIAMOND));
        }
        if (model.ref(SortedSet.class).isAssignableFrom($Raw)) {
            ((AbstractCollectionAssert)Assertions.assertThat(new TreeSet(Collections.emptySortedSet())).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).isEmpty();
            return JExpr._new((JClass)model.ref(TreeSet.class).narrow((Class[])DIAMOND));
        }
        if (model.ref(Set.class).isAssignableFrom($Raw)) {
            ((AbstractCollectionAssert)Assertions.assertThat(new HashSet(Collections.emptySet())).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).isEmpty();
            return JExpr._new((JClass)model.ref(HashSet.class).narrow((Class[])DIAMOND));
        }
        if (model.ref(List.class).isAssignableFrom($Raw)) {
            ((ListAssert)Assertions.assertThat(new ArrayList(Collections.emptyList())).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).isEmpty();
            return JExpr._new((JClass)model.ref(ArrayList.class).narrow((Class[])DIAMOND));
        }
        if (model.ref(Collection.class).isAssignableFrom($Raw)) {
            ((ListAssert)Assertions.assertThat(new ArrayList(Collections.emptyList())).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).isEmpty();
            return JExpr._new((JClass)model.ref(ArrayList.class).narrow((Class[])DIAMOND));
        }
        throw new IllegalArgumentException("There is no copy-collection factory for type " + $type);
    }

    public static final JInvocation unmodifiableViewFactoryFor(JType $type) throws IllegalArgumentException {
        JCodeModel model = $type.owner();
        JClass $Collections = model.ref(Collections.class);
        JClass $Raw = $type.boxify().erasure();
        if (model.ref(NavigableSet.class).isAssignableFrom($Raw)) {
            ((AbstractCollectionAssert)Assertions.assertThat(Collections.unmodifiableNavigableSet(Collections.emptyNavigableSet())).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).isEmpty();
            return $Collections.staticInvoke("unmodifiableNavigableSet");
        }
        if (model.ref(SortedSet.class).isAssignableFrom($Raw)) {
            ((AbstractCollectionAssert)Assertions.assertThat(Collections.unmodifiableSortedSet(Collections.emptySortedSet())).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).isEmpty();
            return $Collections.staticInvoke("unmodifiableSortedSet");
        }
        if (model.ref(Set.class).isAssignableFrom($Raw)) {
            ((AbstractCollectionAssert)Assertions.assertThat(Collections.unmodifiableSet(Collections.emptySet())).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).isEmpty();
            return $Collections.staticInvoke("unmodifiableSet");
        }
        if (model.ref(List.class).isAssignableFrom($Raw)) {
            ((ListAssert)Assertions.assertThat(Collections.unmodifiableList(Collections.emptyList())).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).isEmpty();
            return $Collections.staticInvoke("unmodifiableList");
        }
        if (model.ref(Collection.class).isAssignableFrom($Raw)) {
            ((AbstractCollectionAssert)Assertions.assertThat(Collections.unmodifiableCollection(Collections.emptyList())).withFailMessage(UNEXPECTED_MODIFICATION, new Object[0])).isEmpty();
            return $Collections.staticInvoke("unmodifiableCollection");
        }
        throw new IllegalArgumentException("There is no unmodifiable-view-collection factory for type " + $type);
    }

    public static final Optional<JExpression> cloneExpressionFor(JType $type, JExpression $expression, boolean unmodifiableCollections) {
        if ($type.isArray()) {
            return Optional.of(JExpr.cast((JType)$type, (JExpression)$expression.invoke("clone")));
        }
        if ($type.owner().ref(Cloneable.class).isAssignableFrom($type.boxify())) {
            return Optional.of(JExpr.cast((JType)$type, (JExpression)$expression.invoke("clone")));
        }
        if (CodeModelAnalysis.isCollectionType($type)) {
            return Optional.of(unmodifiableCollections ? CodeModelAnalysis.unmodifiableViewFactoryFor($type).arg($expression) : CodeModelAnalysis.copyFactoryFor($type).arg($expression));
        }
        return Optional.empty();
    }

    public static final Optional<JMethod> getConstructor(JDefinedClass $Class) {
        JType[] $types = new JType[]{};
        return CodeModelAnalysis.getConstructor($Class, $types);
    }

    public static final Optional<JMethod> getConstructor(JDefinedClass $Class, Class<?> ... argumentTypes) {
        JType[] $types = (JType[])Arrays.stream(argumentTypes).map(arg_0 -> ((JCodeModel)$Class.owner()).ref(arg_0)).toArray(JType[]::new);
        return CodeModelAnalysis.getConstructor($Class, $types);
    }

    public static final Optional<JMethod> getConstructor(JDefinedClass $Class, JVar ... $argumentTypes) {
        JType[] $types = (JType[])Arrays.stream($argumentTypes).map(JVar::type).toArray(JType[]::new);
        return CodeModelAnalysis.getConstructor($Class, $types);
    }

    public static final Optional<JMethod> getConstructor(JDefinedClass $Class, Collection<? extends JVar> $argumentTypes) {
        JType[] $types = (JType[])$argumentTypes.stream().map(JVar::type).toArray(JType[]::new);
        return CodeModelAnalysis.getConstructor($Class, $types);
    }

    public static final Optional<JMethod> getConstructor(JDefinedClass $Class, JType ... $argumentTypes) {
        JMethod $constructor = $Class.getConstructor($argumentTypes);
        if ($constructor == null) {
            $constructor = $Class.getConstructor(CodeModelAnalysis.erasure($argumentTypes));
        }
        return Optional.ofNullable($constructor);
    }

    public static final List<JMethod> getConstructors(JDefinedClass $Class, Predicate<? super JMethod> filter) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize($Class.constructors(), 257), false).filter(filter).collect(Collectors.toList());
    }

    public static final Optional<JMethod> getMethod(JDefinedClass $Class, String name) {
        JType[] $types = new JType[]{};
        return CodeModelAnalysis.getMethod($Class, name, $types);
    }

    public static final Optional<JMethod> getMethod(JDefinedClass $Class, String name, Class<?> ... argumentTypes) {
        JType[] $types = (JType[])Arrays.stream(argumentTypes).map(arg_0 -> ((JCodeModel)$Class.owner()).ref(arg_0)).toArray(JType[]::new);
        return CodeModelAnalysis.getMethod($Class, name, $types);
    }

    public static final Optional<JMethod> getMethod(JDefinedClass $Class, String name, JVar ... $argumentTypes) {
        JType[] $types = (JType[])Arrays.stream($argumentTypes).map(JVar::type).toArray(JType[]::new);
        return CodeModelAnalysis.getMethod($Class, name, $types);
    }

    public static final Optional<JMethod> getMethod(JDefinedClass $Class, String name, Collection<? extends JVar> $argumentTypes) {
        JType[] $types = (JType[])$argumentTypes.stream().map(JVar::type).toArray(JType[]::new);
        return CodeModelAnalysis.getMethod($Class, name, $types);
    }

    public static final Optional<JMethod> getMethod(JDefinedClass $Class, String name, JType ... $argumentTypes) {
        JMethod $method = $Class.getMethod(name, $argumentTypes);
        if ($method == null) {
            $method = $Class.getMethod(name, CodeModelAnalysis.erasure($argumentTypes));
        }
        return Optional.ofNullable($method);
    }

    public static final List<JMethod> getMethods(JDefinedClass $Class, Predicate<? super JMethod> filter) {
        return $Class.methods().stream().filter(filter).collect(Collectors.toList());
    }

    public static final Optional<JDefinedClass> getEmbeddedClass(JDefinedClass $Class, String name) {
        List embedded = StreamSupport.stream(Spliterators.spliteratorUnknownSize($Class.classes(), 257), false).filter(c -> name.equals(c.name())).collect(Collectors.toList());
        Assertions.assertThat(embedded).hasSizeBetween(0, 1);
        return embedded.isEmpty() ? Optional.empty() : Optional.of((JDefinedClass)embedded.get(0));
    }

    public static final boolean isOptionalMethod(JMethod $method) {
        return CodeModelAnalysis.isOptionalType($method.type());
    }

    public static final boolean isCollectionMethod(JMethod $method) {
        return CodeModelAnalysis.isCollectionType($method.type());
    }

    public static final JDefinedClass enclosingClass(JMethod $method) {
        try {
            Field internalOuter = JMethod.class.getDeclaredField(OUTER_FIELD);
            internalOuter.setAccessible(true);
            return (JDefinedClass)internalOuter.get($method);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException seriousProblem) {
            throw new RuntimeException(seriousProblem);
        }
    }

    public static final Set<JClass> allThrows(JMethod $method) {
        try {
            Method internalThrowsSet = JMethod.class.getDeclaredMethod(GETTHROWS_METHOD, new Class[0]);
            internalThrowsSet.setAccessible(true);
            Set $throws = (Set)internalThrowsSet.invoke((Object)$method, new Object[0]);
            return Collections.unmodifiableSet($throws);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException seriousProblem) {
            throw new RuntimeException(seriousProblem);
        }
    }

    public static final boolean doesThrow(JMethod $method, JClass exception) {
        return CodeModelAnalysis.allThrows($method).contains(exception);
    }

    public static final Optional<JDocComment> currentJavadoc(JMethod $method) {
        try {
            Field internalJavadoc = JMethod.class.getDeclaredField(JDOC_FIELD);
            internalJavadoc.setAccessible(true);
            JDocComment $javadoc = (JDocComment)internalJavadoc.get($method);
            return Optional.ofNullable($javadoc);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException seriousProblem) {
            throw new RuntimeException(seriousProblem);
        }
    }

    public static final Map<String, JCommentPart> allJavadocParams(JMethod $method) {
        Optional<JDocComment> javadoc = CodeModelAnalysis.currentJavadoc($method);
        if (javadoc.isPresent()) {
            try {
                Field internalJavadocParams = JDocComment.class.getDeclaredField(ATPARAMS_FIELD);
                internalJavadocParams.setAccessible(true);
                Map $javadocParams = (Map)internalJavadocParams.get(javadoc.get());
                return Collections.unmodifiableMap($javadocParams);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException seriousProblem) {
                throw new RuntimeException(seriousProblem);
            }
        }
        return Collections.emptyMap();
    }

    public static final Map<JClass, JCommentPart> allJavadocThrows(JMethod $method) {
        Optional<JDocComment> javadoc = CodeModelAnalysis.currentJavadoc($method);
        if (javadoc.isPresent()) {
            try {
                Field internalJavadocParams = JDocComment.class.getDeclaredField(ATTHROWS_FIELD);
                internalJavadocParams.setAccessible(true);
                Map $javadocParams = (Map)internalJavadocParams.get(javadoc.get());
                return Collections.unmodifiableMap($javadocParams);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException seriousProblem) {
                throw new RuntimeException(seriousProblem);
            }
        }
        return Collections.emptyMap();
    }

    public static final String render(JGenerable $component) {
        StringWriter out = new StringWriter();
        $component.generate(new JFormatter((Writer)out));
        return out.toString();
    }

    public static final String javadocNameOf(JType $type) {
        return $type.erasure().fullName();
    }

    public static final String javadocSimpleNameOf(JType $type) {
        return $type.erasure().name();
    }

    public static final String javadocNameOf(JMethod $method) {
        return $method.name() + "(" + String.join((CharSequence)",", Arrays.stream($method.listParamTypes()).map(CodeModelAnalysis::javadocNameOf).collect(Collectors.toList())) + ")";
    }

    public static final String javadocNameOf(JVar $var) {
        return $var.name();
    }
}

