/*
 * Decompiled with CFR 0.152.
 */
package de.informaticum.xjc.plugins;

import com.sun.codemodel.JDefinedClass;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.CustomizableOutline;
import com.sun.tools.xjc.outline.ElementOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.PackageOutline;
import de.informaticum.xjc.api.BasePlugin;
import de.informaticum.xjc.plugins.i18n.TracePluginMessages;
import de.informaticum.xjc.util.OutlineAnalysis;
import java.util.AbstractMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TracePlugin
extends BasePlugin {
    private static final Logger LOG = LoggerFactory.getLogger(TracePlugin.class);
    private static final String CURRENT_ENTITY = "Current {} is [{}].";
    private static final String OPTION_NAME = "informaticum-xjc-trace";

    @Override
    public final Map.Entry<String, String> getOptionEntry() {
        return new AbstractMap.SimpleImmutableEntry<String, String>(OPTION_NAME, TracePluginMessages.OPTION_DESCRIPTION.text());
    }

    @Override
    protected final boolean runPackage(PackageOutline pakkage) {
        LOG.trace(CURRENT_ENTITY, (Object)"Package", (Object)OutlineAnalysis.fullNameOf(pakkage));
        return true;
    }

    @Override
    protected final boolean runObjectFactory(JDefinedClass $Factory) {
        LOG.trace(CURRENT_ENTITY, (Object)"Object-Factory", (Object)$Factory.fullName());
        return true;
    }

    @Override
    protected final boolean runClass(ClassOutline clazz) {
        LOG.trace(CURRENT_ENTITY, (Object)"Class", (Object)OutlineAnalysis.fullNameOf((CustomizableOutline)clazz));
        return true;
    }

    @Override
    protected final boolean runEnum(EnumOutline enumeration) {
        LOG.trace(CURRENT_ENTITY, (Object)"Enum", (Object)OutlineAnalysis.fullNameOf((CustomizableOutline)enumeration));
        return true;
    }

    @Override
    protected final boolean runElement(ElementOutline element) {
        LOG.trace(CURRENT_ENTITY, (Object)"Element (with its own class)", (Object)OutlineAnalysis.fullNameOf((CustomizableOutline)element));
        return true;
    }

    @Override
    protected final boolean runElementInfo(CElementInfo info) {
        LOG.trace(CURRENT_ENTITY, (Object)"Element (without its own class)", (Object)info.fullName());
        return true;
    }
}

