/*
 * Decompiled with CFR 0.152.
 */
package de.informaticum.xjc.plugins;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JFieldVar;
import de.informaticum.xjc.api.CommandLineArgument;
import de.informaticum.xjc.api.XjcOption;
import de.informaticum.xjc.plugins.AdoptAnnotationsPlugin;
import de.informaticum.xjc.plugins.i18n.ReusePluginMessages;
import de.informaticum.xjc.util.CodeRetrofit;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReusePlugin
extends AdoptAnnotationsPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ReusePlugin.class);
    private static final String PUBLIC_QNAME = "Modify accessibility of QName [{}#{}] to [public].";
    private static final String OPTION_NAME = "informaticum-xjc-reuse";
    private static final CommandLineArgument REUSE_QNAMES = new CommandLineArgument("reuse-qnames", ReusePluginMessages.REUSE_QNAMES_DESCRIPTION.text(), new String[0]);

    @Override
    public final Map.Entry<String, String> getOptionEntry() {
        return new AbstractMap.SimpleImmutableEntry<String, String>(OPTION_NAME, ReusePluginMessages.OPTION_DESCRIPTION.text());
    }

    @Override
    public final List<XjcOption> getPluginArguments() {
        return Arrays.asList(REUSE_QNAMES);
    }

    @Override
    protected final boolean runObjectFactory(JDefinedClass $Factory) {
        REUSE_QNAMES.doOnActivation(this::setQNamesPublic, $Factory);
        return true;
    }

    private final void setQNamesPublic(JDefinedClass $Factory) {
        JClass $QName = this.reference(QName.class);
        Collection $fields = $Factory.fields().values();
        Stream<JFieldVar> $qNameFields = $fields.stream().filter($f -> $QName.isAssignableFrom($f.type().boxify()));
        $qNameFields.forEach($q -> {
            LOG.info(PUBLIC_QNAME, (Object)$Factory.fullName(), (Object)$q.name());
            this.appendGeneratedAnnotation((JAnnotatable)$Factory, (JAnnotatable)$q, ReusePluginMessages.PUBLIC_QNAMES_COMMENT.format(ReusePlugin.class.getName()));
            CodeRetrofit.javadocSection((JDocCommentable)$q).append((Object)ReusePluginMessages.PUBLIC_QNAMES_IMPLNOTE.text());
            $q.mods().setPublic();
        });
    }
}

