/*
 * Decompiled with CFR 0.152.
 */
package de.informaticum.xjc.plugins;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JGenerable;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.CustomizableOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import de.informaticum.xjc.api.CommandLineArgument;
import de.informaticum.xjc.api.XjcOption;
import de.informaticum.xjc.plugins.AssignmentPlugin;
import de.informaticum.xjc.plugins.GetterBricks;
import de.informaticum.xjc.plugins.GetterRefactoring;
import de.informaticum.xjc.plugins.PropertyAccessor;
import de.informaticum.xjc.plugins.i18n.PropertyPluginMessages;
import de.informaticum.xjc.util.CodeModelAnalysis;
import de.informaticum.xjc.util.CodeRetrofit;
import de.informaticum.xjc.util.OutlineAnalysis;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyPlugin
extends AssignmentPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyPlugin.class);
    private static final String MODIFY_PROPERTY = "Modify {} of property [{}#{}] to [{}].";
    private static final String REFACTOR_JUST_STRAIGHT = "Refactor [{}#{}()]: return value straightly";
    private static final String REFACTOR_AS_DEFAULTED = "Refactor [{}#{}()]: return default value if 'null'";
    private static final String REFACTOR_AS_OPTIONAL = "Refactor [{}#{}()]: return OptionalDouble, OptionalInt, OptionalLong, or Optional<X> for optional field";
    private static final String REFACTOR_AS_UNMODIFIABLE = "Refactor [{}#{}()]: return unmodifiable view";
    private static final String REFACTOR_AS_UNMODIFIABLE_AND_DEFAULTED = "Refactor [{}#{}()]: return unmodifiable view or default value if 'null'";
    private static final String REFACTOR_AS_UNMODIFIABLE_AND_OPTIONAL = "Refactor [{}#{}()]: return Optional<X> of unmodifiable view for optional field";
    private static final String MODIFY_METHOD = "Modify {} of method [{}#{}] to [{}].";
    private static final String GENERATE_ORDEFAULT = "Generate getter method [{}#{}({})] for property [{}].";
    private static final String SKIP_ORDEFAULT = "Skip creation of getter method [{}#{}({})] for property [{}] because {}.";
    private static final String BECAUSE_NO_DEFAULT_EXISTS = "there is no according default value";
    private static final String GENERATE_SETTER = "Generate setter method [{}#{}({})] for property [{}].";
    private static final String SKIP_SETTER = "Skip creation of setter method [{}#{}({})] for property [{}] because {}.";
    private static final String REMOVE_SETTER = "Remove setter method [{}#{}(...)].";
    private static final String OPTION_NAME = "informaticum-xjc-properties";
    private static final CommandLineArgument FINAL_GETTERS = new CommandLineArgument("properties-final-getters", PropertyPluginMessages.FINAL_GETTERS_DESCRIPTION.text(), new String[0]);
    private static final CommandLineArgument FINAL_SETTERS = new CommandLineArgument("properties-final-setters", PropertyPluginMessages.FINAL_SETTERS_DESCRIPTION.text(), new String[0]);
    private static final CommandLineArgument STRAIGHT_GETTERS = new CommandLineArgument("properties-straight-getters", PropertyPluginMessages.STRAIGHT_GETTERS_DESCRIPTION.text(), new String[0]);
    private static final CommandLineArgument OPTIONAL_GETTERS = new CommandLineArgument("properties-optional-getters", PropertyPluginMessages.OPTIONAL_GETTERS_DESCRIPTION.format(STRAIGHT_GETTERS), new String[0]);
    private static final CommandLineArgument OPTIONAL_ORDEFAULT = new CommandLineArgument("properties-optional-ordefault", PropertyPluginMessages.OPTIONAL_ORDEFAULT_DESCRIPTION.format(OPTIONAL_GETTERS), new String[0]);
    private static final CommandLineArgument COLLECTION_SETTERS = new CommandLineArgument("properties-collection-setters", PropertyPluginMessages.COLLECTION_SETTERS_DESCRIPTION.text(), new String[0]);
    private static final CommandLineArgument REMOVE_SETTERS = new CommandLineArgument("properties-remove-setters", PropertyPluginMessages.REMOVE_SETTERS_DESCRIPTION.format(FINAL_SETTERS, COLLECTION_SETTERS), new String[0]);
    private static final CommandLineArgument PRIVATE_FIELDS = new CommandLineArgument("properties-private-fields", PropertyPluginMessages.PRIVATE_FIELDS_DESCRIPTION.text(), new String[0]);
    private static final CommandLineArgument FINAL_FIELDS = new CommandLineArgument("properties-final-fields", PropertyPluginMessages.FINAL_FIELDS_DESCRIPTION.format(STRAIGHT_GETTERS), new String[0]);

    @Override
    public final Map.Entry<String, String> getOptionEntry() {
        return new AbstractMap.SimpleImmutableEntry<String, String>(OPTION_NAME, PropertyPluginMessages.OPTION_DESCRIPTION.text());
    }

    @Override
    public final List<XjcOption> getPluginArguments() {
        final List<CommandLineArgument> args = Arrays.asList(PRIVATE_FIELDS, FINAL_FIELDS, STRAIGHT_GETTERS, OPTIONAL_GETTERS, OPTIONAL_ORDEFAULT, FINAL_GETTERS, COLLECTION_SETTERS, FINAL_SETTERS, REMOVE_SETTERS);
        return new ArrayList<XjcOption>(super.getPluginArguments()){
            {
                super(arg0);
                this.addAll(args);
            }
        };
    }

    public final void onActivated(Options options) throws BadCommandLineException {
        super.onActivated(options);
    }

    @Override
    public final boolean prepareRun() {
        boolean result = super.prepareRun();
        FINAL_FIELDS.activates(STRAIGHT_GETTERS);
        OPTIONAL_GETTERS.activates(STRAIGHT_GETTERS);
        REMOVE_SETTERS.deactivates(FINAL_SETTERS, COLLECTION_SETTERS);
        return result;
    }

    @Override
    protected final boolean runClass(ClassOutline clazz) {
        PRIVATE_FIELDS.doOnActivation(this::setFieldsPrivate, clazz);
        FINAL_FIELDS.doOnActivation(this::setFieldsFinal, clazz);
        STRAIGHT_GETTERS.doOnActivation(this::refactorGetter, clazz);
        FINAL_GETTERS.doOnActivation(this::setGettersFinal, clazz);
        OPTIONAL_ORDEFAULT.doOnActivation(this::generateOrDefaultGetters, clazz);
        REMOVE_SETTERS.doOnActivation(this::removeSetter, clazz);
        COLLECTION_SETTERS.doOnActivation(this::generateCollectionSetters, clazz);
        FINAL_SETTERS.doOnActivation(this::setSettersFinal, clazz);
        return true;
    }

    private final void setFieldsPrivate(ClassOutline clazz) {
        JDefinedClass $ImplClass = clazz.getImplClass();
        for (JFieldVar $field : OutlineAnalysis.generatedPropertiesOf(clazz).values()) {
            LOG.info(MODIFY_PROPERTY, new Object[]{"accessibility", OutlineAnalysis.fullNameOf((CustomizableOutline)clazz), $field.name(), "private"});
            this.appendGeneratedAnnotation((JAnnotatable)$ImplClass, (JAnnotatable)$field, PropertyPluginMessages.PRIVATE_FIELD_COMMENT.format(PropertyPlugin.class.getName()));
            CodeRetrofit.javadocSection((JDocCommentable)$field).append((Object)PropertyPluginMessages.PRIVATE_FIELD_IMPLNOTE.text());
            $field.mods().setPrivate();
        }
    }

    private final void setFieldsFinal(ClassOutline clazz) {
        JDefinedClass $ImplClass = clazz.getImplClass();
        for (JFieldVar $field : OutlineAnalysis.generatedPropertiesOf(clazz).values()) {
            LOG.info(MODIFY_PROPERTY, new Object[]{"mutability", OutlineAnalysis.fullNameOf((CustomizableOutline)clazz), $field.name(), "final"});
            this.appendGeneratedAnnotation((JAnnotatable)$ImplClass, (JAnnotatable)$field, PropertyPluginMessages.FINAL_FIELD_COMMENT.format(PropertyPlugin.class.getName()));
            CodeRetrofit.javadocSection((JDocCommentable)$field).append((Object)PropertyPluginMessages.FINAL_FIELD_IMPLNOTE.text());
            $field.mods().setFinal(true);
        }
    }

    private final void setGettersFinal(ClassOutline clazz) {
        JDefinedClass $ImplClass = clazz.getImplClass();
        for (Map.Entry<JFieldVar, JMethod> getter : OutlineAnalysis.generatedGettersOf(clazz).values()) {
            JMethod $getter = getter.getValue();
            LOG.info(MODIFY_METHOD, new Object[]{"mutability", OutlineAnalysis.fullNameOf((CustomizableOutline)clazz), $getter, "final"});
            this.appendGeneratedAnnotation((JAnnotatable)$ImplClass, (JAnnotatable)$getter, PropertyPluginMessages.FINAL_GETTER_COMMENT.format(PropertyPlugin.class.getName()));
            CodeRetrofit.javadocSection((JDocCommentable)$getter).append((Object)PropertyPluginMessages.FINAL_GETTER_IMPLNOTE.text());
            $getter.mods().setFinal(true);
        }
    }

    private final void setSettersFinal(ClassOutline clazz) {
        JDefinedClass $ImplClass = clazz.getImplClass();
        for (Map.Entry<JFieldVar, JMethod> setter : OutlineAnalysis.generatedSettersOf(clazz).values()) {
            JMethod $setter = setter.getValue();
            LOG.info(MODIFY_METHOD, new Object[]{"mutability", OutlineAnalysis.fullNameOf((CustomizableOutline)clazz), $setter, "final"});
            this.appendGeneratedAnnotation((JAnnotatable)$ImplClass, (JAnnotatable)$setter, PropertyPluginMessages.FINAL_SETTER_COMMENT.format(PropertyPlugin.class.getName()));
            CodeRetrofit.javadocSection((JDocCommentable)$setter).append((Object)PropertyPluginMessages.FINAL_SETTER_IMPLNOTE.text());
            $setter.mods().setFinal(true);
        }
    }

    private final void removeSetter(ClassOutline clazz) {
        JDefinedClass $ImplClass = clazz.getImplClass();
        LinkedHashMap<FieldOutline, Map.Entry<JFieldVar, JMethod>> setters = OutlineAnalysis.generatedSettersOf(clazz);
        if (!setters.isEmpty()) {
            this.appendGeneratedAnnotation((JAnnotatable)$ImplClass, (JAnnotatable)$ImplClass, PropertyPluginMessages.REMOVED_SETTERS_COMMENT.format(PropertyPlugin.class.getName()));
            CodeRetrofit.javadocSection((JDocCommentable)$ImplClass).append((Object)PropertyPluginMessages.REMOVED_SETTERS_IMPLNOTE.text());
            for (Map.Entry<JFieldVar, JMethod> setter : setters.values()) {
                JMethod $setter = setter.getValue();
                LOG.info(REMOVE_SETTER, (Object)OutlineAnalysis.fullNameOf((CustomizableOutline)clazz), (Object)$setter.name());
                $ImplClass.methods().remove($setter);
            }
        }
    }

    private final void refactorGetter(ClassOutline clazz) {
        for (Map.Entry<FieldOutline, Map.Entry<JFieldVar, JMethod>> getter : OutlineAnalysis.generatedGettersOf(clazz).entrySet()) {
            GetterBricks bricks = new GetterBricks(new PropertyAccessor(getter));
            ArrayList originJavadoc = new ArrayList(bricks.$getter.javadoc());
            this.hijackGeneratedAnnotation((JAnnotatable)bricks.$ImplClass, (JAnnotatable)bricks.$getter, PropertyPlugin.class, PropertyPluginMessages.GETTER_COMMENT.text());
            if (bricks.$field.type().isPrimitive()) {
                Assertions.assertThat((Object)bricks.$getter).matches(Predicate.not(CodeModelAnalysis::isCollectionMethod));
                Assertions.assertThat((boolean)CodeModelAnalysis.isOptionalMethod(bricks.$getter)).isFalse();
                Assertions.assertThat((boolean)bricks.$returnType.isPrimitive()).isTrue();
                Assertions.assertThat((boolean)bricks.$returnType.isReference()).isFalse();
                LOG.info(REFACTOR_JUST_STRAIGHT, (Object)OutlineAnalysis.fullNameOf((CustomizableOutline)bricks.clazz), (Object)bricks.$getter.name());
                GetterRefactoring.PRIMITIVE_PROPERTY.supersedeGetter(bricks);
            } else if (bricks.info.isCollection()) {
                Assertions.assertThat((Object)bricks.$getter).matches(CodeModelAnalysis::isCollectionMethod);
                Assertions.assertThat((boolean)CodeModelAnalysis.isOptionalMethod(bricks.$getter)).isFalse();
                Assertions.assertThat((boolean)bricks.$returnType.isPrimitive()).isFalse();
                Assertions.assertThat((boolean)bricks.$returnType.isReference()).isTrue();
                if (bricks.$default.isPresent() && UNMODIFIABLE_COLLECTIONS.isActivated()) {
                    LOG.info(REFACTOR_AS_UNMODIFIABLE_AND_DEFAULTED, (Object)OutlineAnalysis.fullNameOf((CustomizableOutline)bricks.clazz), (Object)bricks.$getter.name());
                    GetterRefactoring.DEFAULTED_UNMODIFIABLE_COLLECTION_PROPERTY.supersedeGetter(bricks);
                } else if (bricks.$default.isPresent()) {
                    Assertions.assertThat((boolean)UNMODIFIABLE_COLLECTIONS.isActivated()).isFalse();
                    LOG.info(REFACTOR_AS_DEFAULTED, (Object)OutlineAnalysis.fullNameOf((CustomizableOutline)bricks.clazz), (Object)bricks.$getter.name());
                    GetterRefactoring.DEFAULTED_MODIFIABLE_COLLECTION_PROPERTY.supersedeGetter(bricks);
                } else if (OPTIONAL_GETTERS.isActivated() && OutlineAnalysis.isOptional(bricks.field) && UNMODIFIABLE_COLLECTIONS.isActivated()) {
                    LOG.info(REFACTOR_AS_UNMODIFIABLE_AND_OPTIONAL, (Object)OutlineAnalysis.fullNameOf((CustomizableOutline)bricks.clazz), (Object)bricks.$getter.name());
                    GetterRefactoring.OPTIONAL_UNMODIFIABLE_COLLECTION_PROPERTY.supersedeGetter(bricks);
                } else if (OPTIONAL_GETTERS.isActivated() && OutlineAnalysis.isOptional(bricks.field)) {
                    Assertions.assertThat((boolean)UNMODIFIABLE_COLLECTIONS.isActivated()).isFalse();
                    LOG.info(REFACTOR_AS_OPTIONAL, (Object)OutlineAnalysis.fullNameOf((CustomizableOutline)bricks.clazz), (Object)bricks.$getter.name());
                    GetterRefactoring.OPTIONAL_MODIFIABLE_COLLECTION_PROPERTY.supersedeGetter(bricks);
                } else if (UNMODIFIABLE_COLLECTIONS.isActivated()) {
                    LOG.info(REFACTOR_AS_UNMODIFIABLE, (Object)OutlineAnalysis.fullNameOf((CustomizableOutline)bricks.clazz), (Object)bricks.$getter.name());
                    GetterRefactoring.UNMODIFIABLE_COLLECTION_PROPERTY.supersedeGetter(bricks);
                } else {
                    Assertions.assertThat((boolean)UNMODIFIABLE_COLLECTIONS.isActivated()).isFalse();
                    LOG.info(REFACTOR_JUST_STRAIGHT, (Object)OutlineAnalysis.fullNameOf((CustomizableOutline)bricks.clazz), (Object)bricks.$getter.name());
                    GetterRefactoring.MODIFIABLE_COLLECTION_PROPERTY.supersedeGetter(bricks);
                }
            } else {
                Assertions.assertThat((Object)bricks.$getter).matches(Predicate.not(CodeModelAnalysis::isCollectionMethod));
                Assertions.assertThat((boolean)CodeModelAnalysis.isOptionalMethod(bricks.$getter)).isFalse();
                if (bricks.$default.isPresent()) {
                    LOG.info(REFACTOR_AS_DEFAULTED, (Object)OutlineAnalysis.fullNameOf((CustomizableOutline)bricks.clazz), (Object)bricks.$getter.name());
                    GetterRefactoring.DEFAULTED_PROPERTY.supersedeGetter(bricks);
                } else if (OPTIONAL_GETTERS.isActivated() && OutlineAnalysis.isOptional(bricks.field)) {
                    ((AbstractBooleanAssert)Assertions.assertThat((boolean)CodeModelAnalysis.isOptionalMethod(bricks.$getter)).withFailMessage("This case is not considered yet ;-(", new Object[0])).isFalse();
                    LOG.info(REFACTOR_AS_OPTIONAL, (Object)OutlineAnalysis.fullNameOf((CustomizableOutline)bricks.clazz), (Object)bricks.$getter.name());
                    GetterRefactoring.OPTIONAL_PROPERTY.supersedeGetter(bricks);
                } else {
                    LOG.info(REFACTOR_JUST_STRAIGHT, (Object)OutlineAnalysis.fullNameOf((CustomizableOutline)bricks.clazz), (Object)bricks.$getter.name());
                    GetterRefactoring.STRAIGHT_PROPERTY.supersedeGetter(bricks);
                }
            }
            CodeRetrofit.javadocSection((JDocCommentable)bricks.$getter).append((Object)PropertyPluginMessages.REFACTORED_GETTER_IMPLNOTE_INTRO.text());
            bricks.$getter.javadoc().addAll(originJavadoc);
            bricks.$getter.javadoc().append((Object)PropertyPluginMessages.REFACTORED_GETTER_IMPLNOTE_OUTRO.text());
        }
    }

    private final void generateOrDefaultGetters(ClassOutline clazz) {
        for (Map.Entry<FieldOutline, Map.Entry<JFieldVar, JMethod>> getter : OutlineAnalysis.generatedGettersOf(clazz).entrySet()) {
            if (!CodeModelAnalysis.isOptionalMethod(getter.getValue().getValue())) continue;
            PropertyAccessor accessor = new PropertyAccessor(getter);
            JMethod $getOrDefault = this.generateOrDefaultGetter(accessor);
            this.generateOrBuiltinGetter(accessor, $getOrDefault);
        }
    }

    private final JMethod generateOrDefaultGetter(PropertyAccessor accessor) {
        JType $type;
        String methodName = accessor.$method.name() + "OrDefault";
        Optional<JMethod> $lookup = OutlineAnalysis.getMethod(accessor.clazz, methodName, $type = CodeModelAnalysis.deoptionalisedTypeFor(accessor.$method.type().boxify()).orElse(accessor.$field.type()));
        if ($lookup.isPresent()) {
            LOG.warn(SKIP_ORDEFAULT, new Object[]{OutlineAnalysis.fullNameOf((CustomizableOutline)accessor.clazz), methodName, $type, accessor.$field.name(), "such method already exists"});
            return $lookup.get();
        }
        Assertions.assertThat($lookup).isNotPresent();
        LOG.info(GENERATE_ORDEFAULT, new Object[]{OutlineAnalysis.fullNameOf((CustomizableOutline)accessor.clazz), methodName, $type, accessor.$field.name()});
        int methodMods = accessor.$method.mods().getValue();
        JMethod $getOrDefault = accessor.$ImplClass.method(methodMods, $type, methodName);
        JVar $defaultValue = $getOrDefault.param(8, PropertyPlugin.parameterTypeOf($type), "defaultValue");
        this.hijackGeneratedAnnotation((JAnnotatable)accessor.$ImplClass, (JAnnotatable)$getOrDefault, PropertyPlugin.class, PropertyPluginMessages.ORDEFAULT_COMMENT.text());
        CodeRetrofit.javadocSection((JDocCommentable)$getOrDefault).append((Object)PropertyPluginMessages.ORDEFAULT_JAVADOC.format(OutlineAnalysis.javadocNameOf((CustomizableOutline)accessor.clazz), CodeModelAnalysis.javadocNameOf(accessor.$method), $defaultValue.name()));
        CodeRetrofit.javadocSection((JDocCommentable)$getOrDefault).append((Object)PropertyPluginMessages.ORDEFAULT_IMPLNOTE.text());
        CodeRetrofit.javadocSection($getOrDefault.javadoc().addParam($defaultValue)).append((Object)PropertyPluginMessages.ORDEFAULT_PARAM.format(OutlineAnalysis.javadocNameOf((CustomizableOutline)accessor.clazz), CodeModelAnalysis.javadocNameOf(accessor.$method)));
        CodeRetrofit.javadocSection($getOrDefault.javadoc().addReturn()).append((Object)PropertyPluginMessages.ORDEFAULT_RETURN.format(OutlineAnalysis.javadocNameOf((CustomizableOutline)accessor.clazz), CodeModelAnalysis.javadocNameOf(accessor.$method), $defaultValue.name()));
        JVar other = $type.isPrimitive() ? $defaultValue : JOp.cond((JExpression)$defaultValue.eq(CodeModelAnalysis.$null), (JExpression)CodeModelAnalysis.$null, (JExpression)PropertyPlugin.effectiveExpressionForNonNull($type, (JExpression)$defaultValue));
        $getOrDefault.body()._return((JExpression)CodeModelAnalysis.$this.invoke(accessor.$method).invoke("orElse").arg((JExpression)other));
        return $getOrDefault;
    }

    private final Optional<JMethod> generateOrBuiltinGetter(PropertyAccessor accessor, JMethod $getOrDefault) {
        Object methodName = CodeModelAnalysis.isCollectionMethod($getOrDefault) ? accessor.$method.name() + "OrEmpty" : $getOrDefault.name();
        Optional<JMethod> $lookup = OutlineAnalysis.getMethod(accessor.clazz, (String)methodName);
        if ($lookup.isPresent()) {
            LOG.warn(SKIP_ORDEFAULT, new Object[]{OutlineAnalysis.fullNameOf((CustomizableOutline)accessor.clazz), methodName, "", accessor.$field.name(), "such method already exists"});
            return $lookup;
        }
        Optional<JExpression> $default = OutlineAnalysis.defaultExpressionFor(accessor.field, true, UNMODIFIABLE_COLLECTIONS.isActivated());
        if ($default.isEmpty()) {
            LOG.info(SKIP_ORDEFAULT, new Object[]{OutlineAnalysis.fullNameOf((CustomizableOutline)accessor.clazz), methodName, "", accessor.$field.name(), BECAUSE_NO_DEFAULT_EXISTS});
            return Optional.empty();
        }
        Assertions.assertThat($lookup).isNotPresent();
        Assertions.assertThat($default).isPresent();
        LOG.info(GENERATE_ORDEFAULT, new Object[]{OutlineAnalysis.fullNameOf((CustomizableOutline)accessor.clazz), methodName, "", accessor.$field.name()});
        int methodMods = $getOrDefault.mods().getValue();
        JType $type = $getOrDefault.type();
        JMethod $getOrBuiltin = accessor.$ImplClass.method(methodMods, $type, (String)methodName);
        JExpression $builtin = $default.get();
        this.hijackGeneratedAnnotation((JAnnotatable)accessor.$ImplClass, (JAnnotatable)$getOrBuiltin, PropertyPlugin.class, PropertyPluginMessages.ORBUILTIN_COMMENT.text());
        CodeRetrofit.javadocSection((JDocCommentable)$getOrBuiltin).append((Object)PropertyPluginMessages.ORBUILTIN_JAVADOC.format(OutlineAnalysis.javadocNameOf((CustomizableOutline)accessor.clazz), CodeModelAnalysis.javadocNameOf(accessor.$method), CodeModelAnalysis.render((JGenerable)$builtin)));
        CodeRetrofit.javadocSection((JDocCommentable)$getOrBuiltin).append((Object)PropertyPluginMessages.ORBUILTIN_IMPLNOTE.text());
        CodeRetrofit.javadocSection($getOrBuiltin.javadoc().addReturn()).append((Object)PropertyPluginMessages.ORBUILTIN_RETURN.format(OutlineAnalysis.javadocNameOf((CustomizableOutline)accessor.clazz), CodeModelAnalysis.javadocNameOf(accessor.$method), CodeModelAnalysis.render((JGenerable)$builtin)));
        $getOrBuiltin.body()._return((JExpression)CodeModelAnalysis.$this.invoke($getOrDefault).arg($builtin));
        return Optional.of($getOrBuiltin);
    }

    private final void generateCollectionSetters(ClassOutline clazz) {
        for (Map.Entry<FieldOutline, JFieldVar> property : OutlineAnalysis.filter(OutlineAnalysis.generatedPropertiesOf(clazz), k -> k.getPropertyInfo().isCollection()).entrySet()) {
            FieldOutline field = property.getKey();
            JFieldVar $field = property.getValue();
            Assertions.assertThat((boolean)CodeModelAnalysis.isCollectionType($field.type())).isTrue();
            String setterName = OutlineAnalysis.guessSetterName(field);
            Optional<JMethod> $lookup = OutlineAnalysis.getMethod(clazz, setterName, $field.type());
            if ($lookup.isPresent()) {
                LOG.warn(SKIP_SETTER, new Object[]{OutlineAnalysis.fullNameOf((CustomizableOutline)clazz), setterName, $field.type(), $field.name(), "such method already exists"});
                return;
            }
            Assertions.assertThat($lookup).isNotPresent();
            LOG.info(GENERATE_SETTER, new Object[]{OutlineAnalysis.fullNameOf((CustomizableOutline)clazz), setterName, $field.type(), $field.name()});
            JDefinedClass $ImplClass = clazz.getImplClass();
            JMethod $setter = $ImplClass.method(1, (JType)this.codeModel().VOID, setterName);
            JVar $param = $setter.param(8, PropertyPlugin.parameterTypeOf((JVar)$field), $field.name());
            this.hijackGeneratedAnnotation((JAnnotatable)$ImplClass, (JAnnotatable)$setter, PropertyPlugin.class, PropertyPluginMessages.COLLECTION_SETTER_COMMENT.text());
            CodeRetrofit.javadocSection((JDocCommentable)$setter).append((Object)PropertyPluginMessages.COLLECTION_SETTER_JAVADOC.format(CodeModelAnalysis.javadocNameOf((JVar)$field)));
            CodeRetrofit.javadocSection((JDocCommentable)$setter).append((Object)PropertyPluginMessages.COLLECTION_SETTER_IMPLNOTE.text());
            PropertyPlugin.accordingAssignmentAndJavadoc(property, $setter, (JExpression)$param);
        }
    }
}

