/*
 * Decompiled with CFR 0.152.
 */
package de.informaticum.xjc.plugins;

import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JGenerable;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import de.informaticum.xjc.api.ResourceBundleEntry;
import de.informaticum.xjc.plugins.GetterBricks;
import de.informaticum.xjc.plugins.i18n.PropertyPluginMessages;
import de.informaticum.xjc.util.CodeModelAnalysis;
import de.informaticum.xjc.util.CodeRetrofit;
import de.informaticum.xjc.util.OutlineAnalysis;
import java.util.Optional;
import java.util.function.Function;
import org.assertj.core.api.Assertions;

enum GetterRefactoring {
    PRIMITIVE_PROPERTY(PropertyPluginMessages.STRAIGHT_GETTER_JAVADOC_BEGIN, PropertyPluginMessages.GETTER_JAVADOC_END, PropertyPluginMessages.STRAIGHT_VALUE_RETURN){

        @Override
        final JExpression returnExpression(GetterBricks $) {
            return $.$nonNull;
        }

        @Override
        final ResourceBundleEntry[] notes(GetterBricks $) {
            return new ResourceBundleEntry[]{DECLARATION_TYPE.apply($)};
        }
    }
    ,
    DEFAULTED_UNMODIFIABLE_COLLECTION_PROPERTY(PropertyPluginMessages.STRAIGHT_GETTER_JAVADOC_BEGIN, PropertyPluginMessages.GETTER_JAVADOC_END, PropertyPluginMessages.UNMODIFIABLE_COLLECTION_OR_EMPTY_RETURN){

        @Override
        final JExpression returnExpression(GetterBricks $) {
            Assertions.assertThat($.$default).isPresent();
            Assertions.assertThat((Comparable)$.$returnType).matches(CodeModelAnalysis::isCollectionType);
            return JOp.cond((JExpression)$.$prop.eq(CodeModelAnalysis.$null), (JExpression)$.$default.get(), (JExpression)$.$view());
        }

        @Override
        final ResourceBundleEntry[] notes(GetterBricks $) {
            return new ResourceBundleEntry[]{DECLARATION_TYPE.apply($), PropertyPluginMessages.NOTE_DEFAULTED_UNMODIFIABLE_COLLECTION, PropertyPluginMessages.HINT_DEFAULTED_UNMODIFIABLE_COLLECTION, PropertyPluginMessages.NOTE_UNMODIFIABLE_COLLECTION, PropertyPluginMessages.HINT_UNMODIFIABLE_COLLECTION};
        }
    }
    ,
    DEFAULTED_MODIFIABLE_COLLECTION_PROPERTY(PropertyPluginMessages.STRAIGHT_GETTER_JAVADOC_BEGIN, PropertyPluginMessages.GETTER_JAVADOC_END, PropertyPluginMessages.STRAIGHT_COLLECTION_OR_EMPTY_RETURN){

        @Override
        final JExpression returnExpression(GetterBricks $) {
            Assertions.assertThat($.$default).isPresent();
            return JOp.cond((JExpression)$.$prop.eq(CodeModelAnalysis.$null), (JExpression)$.$default.get(), (JExpression)$.$nonNull);
        }

        @Override
        final ResourceBundleEntry[] notes(GetterBricks $) {
            return new ResourceBundleEntry[]{DECLARATION_TYPE.apply($), PropertyPluginMessages.NOTE_DEFAULTED_COLLECTION, PropertyPluginMessages.HINT_DEFAULTED_COLLECTION, NOTE_REFERENCE.apply($), HINT_REFERENCE.apply($)};
        }
    }
    ,
    OPTIONAL_UNMODIFIABLE_COLLECTION_PROPERTY(PropertyPluginMessages.OPTIONAL_UNMODIFIABLE_GETTER_JAVADOC_BEGIN, PropertyPluginMessages.GETTER_JAVADOC_END, PropertyPluginMessages.OPTIONAL_UNMODIFIABLE_COLLECTION_RETURN){

        @Override
        final JExpression returnExpression(GetterBricks $) {
            Assertions.assertThat((Comparable)$.$returnType).matches(CodeModelAnalysis::isCollectionType);
            return JOp.cond((JExpression)$.$prop.eq(CodeModelAnalysis.$null), (JExpression)$.$optionalEmpty, (JExpression)$.$optionalOf.arg((JExpression)$.$view()));
        }

        @Override
        final Optional<JType> returnType(GetterBricks $) {
            return Optional.of($.$OptionalType);
        }

        @Override
        final ResourceBundleEntry[] notes(GetterBricks $) {
            return new ResourceBundleEntry[]{DECLARATION_TYPE.apply($), PropertyPluginMessages.NOTE_EMPTY_CONTAINER, PropertyPluginMessages.HINT_EMPTY_COLLECTION_CONTAINER, PropertyPluginMessages.NOTE_UNMODIFIABLE_COLLECTION_CONTAINER, PropertyPluginMessages.HINT_UNMODIFIABLE_COLLECTION};
        }

        @Override
        void supersedeJavadoc(GetterBricks $) {
            this.supersedeJavadoc($, CodeModelAnalysis.javadocSimpleNameOf((JType)$.$OptionalType));
        }
    }
    ,
    OPTIONAL_MODIFIABLE_COLLECTION_PROPERTY(PropertyPluginMessages.OPTIONAL_GETTER_JAVADOC_BEGIN, PropertyPluginMessages.GETTER_JAVADOC_END, PropertyPluginMessages.OPTIONAL_COLLECTION_RETURN){

        @Override
        final JExpression returnExpression(GetterBricks $) {
            return JOp.cond((JExpression)$.$prop.eq(CodeModelAnalysis.$null), (JExpression)$.$optionalEmpty, (JExpression)$.$optionalOf.arg($.$nonNull));
        }

        @Override
        final Optional<JType> returnType(GetterBricks $) {
            return Optional.of($.$OptionalType);
        }

        @Override
        final ResourceBundleEntry[] notes(GetterBricks $) {
            return new ResourceBundleEntry[]{DECLARATION_TYPE.apply($), PropertyPluginMessages.NOTE_EMPTY_CONTAINER, PropertyPluginMessages.HINT_EMPTY_COLLECTION_CONTAINER, NOTE_REFERENCE_CONTAINER.apply($), HINT_REFERENCE.apply($)};
        }

        @Override
        void supersedeJavadoc(GetterBricks $) {
            this.supersedeJavadoc($, CodeModelAnalysis.javadocSimpleNameOf((JType)$.$OptionalType));
        }
    }
    ,
    UNMODIFIABLE_COLLECTION_PROPERTY(PropertyPluginMessages.UNMODIFIABLE_GETTER_JAVADOC_BEGIN, PropertyPluginMessages.GETTER_JAVADOC_END, PropertyPluginMessages.UNMODIFIABLE_COLLECTION_RETURN){

        @Override
        final JExpression returnExpression(GetterBricks $) {
            Assertions.assertThat((Comparable)$.$returnType).matches(CodeModelAnalysis::isCollectionType);
            return JOp.cond((JExpression)$.$prop.eq(CodeModelAnalysis.$null), (JExpression)CodeModelAnalysis.$null, (JExpression)$.$view());
        }

        @Override
        final ResourceBundleEntry[] notes(GetterBricks $) {
            return new ResourceBundleEntry[]{DECLARATION_TYPE.apply($), PropertyPluginMessages.NOTE_NULLABLE_VALUE, PropertyPluginMessages.HINT_NULLABLE_VALUE, PropertyPluginMessages.NOTE_UNMODIFIABLE_COLLECTION, PropertyPluginMessages.HINT_UNMODIFIABLE_COLLECTION};
        }
    }
    ,
    MODIFIABLE_COLLECTION_PROPERTY(PropertyPluginMessages.STRAIGHT_GETTER_JAVADOC_BEGIN, PropertyPluginMessages.GETTER_JAVADOC_END, PropertyPluginMessages.STRAIGHT_COLLECTION_RETURN){

        @Override
        final ResourceBundleEntry[] notes(GetterBricks $) {
            return new ResourceBundleEntry[]{DECLARATION_TYPE.apply($), PropertyPluginMessages.NOTE_NULLABLE_VALUE, PropertyPluginMessages.HINT_NULLABLE_VALUE, NOTE_REFERENCE.apply($), HINT_REFERENCE.apply($)};
        }
    }
    ,
    DEFAULTED_PROPERTY(PropertyPluginMessages.STRAIGHT_GETTER_JAVADOC_BEGIN, PropertyPluginMessages.GETTER_JAVADOC_END, PropertyPluginMessages.STRAIGHT_DEFAULTED_VALUE_RETURN){

        @Override
        final JExpression returnExpression(GetterBricks $) {
            Assertions.assertThat($.$default).isPresent();
            return JOp.cond((JExpression)$.$prop.eq(CodeModelAnalysis.$null), (JExpression)$.$default.get(), (JExpression)$.$nonNull);
        }

        @Override
        final ResourceBundleEntry[] notes(GetterBricks $) {
            return new ResourceBundleEntry[]{DECLARATION_TYPE.apply($), PropertyPluginMessages.NOTE_DEFAULTED_VALUE};
        }

        @Override
        void supersedeJavadoc(GetterBricks $) {
            Assertions.assertThat($.$default).isPresent();
            this.supersedeJavadoc($, CodeModelAnalysis.render((JGenerable)$.$default.get()));
        }
    }
    ,
    OPTIONAL_PROPERTY(PropertyPluginMessages.OPTIONAL_GETTER_JAVADOC_BEGIN, PropertyPluginMessages.GETTER_JAVADOC_END, PropertyPluginMessages.OPTIONAL_VALUE_RETURN){

        @Override
        final JExpression returnExpression(GetterBricks $) {
            return JOp.cond((JExpression)$.$prop.eq(CodeModelAnalysis.$null), (JExpression)$.$optionalEmpty, (JExpression)$.$optionalOf.arg($.$nonNull));
        }

        @Override
        final Optional<JType> returnType(GetterBricks $) {
            return Optional.of($.$OptionalType);
        }

        @Override
        final ResourceBundleEntry[] notes(GetterBricks $) {
            return new ResourceBundleEntry[]{DECLARATION_TYPE.apply($), PropertyPluginMessages.NOTE_EMPTY_CONTAINER};
        }

        @Override
        void supersedeJavadoc(GetterBricks $) {
            this.supersedeJavadoc($, CodeModelAnalysis.javadocSimpleNameOf((JType)$.$OptionalType));
        }
    }
    ,
    STRAIGHT_PROPERTY(PropertyPluginMessages.STRAIGHT_GETTER_JAVADOC_BEGIN, PropertyPluginMessages.GETTER_JAVADOC_END, PropertyPluginMessages.STRAIGHT_VALUE_RETURN){

        @Override
        final ResourceBundleEntry[] notes(GetterBricks $) {
            return new ResourceBundleEntry[]{DECLARATION_TYPE.apply($), PropertyPluginMessages.NOTE_NULLABLE_VALUE, PropertyPluginMessages.HINT_NULLABLE_VALUE};
        }
    };

    private static final Function<GetterBricks, PropertyPluginMessages> DECLARATION_TYPE;
    private static final Function<GetterBricks, PropertyPluginMessages> NOTE_REFERENCE;
    private static final Function<GetterBricks, PropertyPluginMessages> HINT_REFERENCE;
    private static final Function<GetterBricks, PropertyPluginMessages> NOTE_REFERENCE_CONTAINER;
    private final ResourceBundleEntry introJavadoc;
    private final ResourceBundleEntry outroJavadoc;
    private final ResourceBundleEntry returnJavadoc;

    private GetterRefactoring(ResourceBundleEntry introJavadoc, ResourceBundleEntry outroJavadoc, ResourceBundleEntry returnJavadoc) {
        this.introJavadoc = introJavadoc;
        this.outroJavadoc = outroJavadoc;
        this.returnJavadoc = returnJavadoc;
    }

    JExpression returnExpression(GetterBricks bricks) {
        if (CodeModelAnalysis.render((JGenerable)bricks.$prop).equals(CodeModelAnalysis.render((JGenerable)bricks.$nonNull))) {
            return bricks.$prop;
        }
        return JOp.cond((JExpression)bricks.$prop.eq(CodeModelAnalysis.$null), (JExpression)CodeModelAnalysis.$null, (JExpression)bricks.$nonNull);
    }

    Optional<JType> returnType(GetterBricks bricks) {
        return Optional.empty();
    }

    abstract ResourceBundleEntry[] notes(GetterBricks var1);

    void supersedeJavadoc(GetterBricks bricks) {
        this.supersedeJavadoc(bricks, CodeModelAnalysis.javadocSimpleNameOf(bricks.$returnType));
    }

    final void supersedeJavadoc(GetterBricks bricks, String noteArg) {
        JDocComment $javadoc = bricks.$getter.javadoc();
        CodeRetrofit.eraseJavadoc($javadoc).append((Object)this.introJavadoc.format(CodeModelAnalysis.javadocNameOf((JType)bricks.field.parent().getImplClass()), CodeModelAnalysis.javadocNameOf((JVar)bricks.$field)));
        for (ResourceBundleEntry note : this.notes(bricks)) {
            CodeRetrofit.javadocBreak($javadoc).append((Object)note.format(noteArg));
        }
        CodeRetrofit.javadocBreak($javadoc).append((Object)this.outroJavadoc.text());
        JCommentPart $return = bricks.$getter.javadoc().addReturn();
        CodeRetrofit.eraseJavadoc($return).append((Object)this.returnJavadoc.format(CodeModelAnalysis.javadocNameOf((JType)bricks.field.parent().getImplClass()), CodeModelAnalysis.javadocNameOf((JVar)bricks.$field), noteArg));
    }

    final void supersedeGetter(GetterBricks bricks) {
        CodeRetrofit.eraseBody(bricks.$getter)._return(this.returnExpression(bricks));
        this.returnType(bricks).ifPresent(t -> bricks.$getter.type(t));
        this.supersedeJavadoc(bricks);
    }

    static {
        DECLARATION_TYPE = b -> OutlineAnalysis.isRequired(b.field) ? PropertyPluginMessages.NOTE_REQUIRED_VALUE : PropertyPluginMessages.NOTE_OPTIONAL_VALUE;
        NOTE_REFERENCE = b -> b.$prop == b.$nonNull ? PropertyPluginMessages.NOTE_LIVE_REFERENCE : PropertyPluginMessages.NOTE_DEFENSIVE_COPY_COLLECTION;
        HINT_REFERENCE = b -> b.$prop == b.$nonNull ? PropertyPluginMessages.HINT_LIVE_REFERENCE : PropertyPluginMessages.HINT_DEFENSIVE_COPY_COLLECTION;
        NOTE_REFERENCE_CONTAINER = b -> b.$prop == b.$nonNull ? PropertyPluginMessages.NOTE_LIVE_REFERENCE_CONTAINER : PropertyPluginMessages.NOTE_DEFENSIVE_COPY_COLLECTION_CONTAINER;
    }
}

