/*
 * Decompiled with CFR 0.152.
 */
package de.informaticum.xjc.plugins;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.CustomizableOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import de.informaticum.xjc.api.CommandLineArgument;
import de.informaticum.xjc.api.XjcOption;
import de.informaticum.xjc.plugins.AssignmentPlugin;
import de.informaticum.xjc.plugins.i18n.ConstructionPluginMessages;
import de.informaticum.xjc.util.CodeModelAnalysis;
import de.informaticum.xjc.util.CodeRetrofit;
import de.informaticum.xjc.util.OutlineAnalysis;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConstructionPlugin
extends AssignmentPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ConstructionPlugin.class);
    private static final String GENERATE_CONSTRUCTOR = "Generate {} constructor for [{}].";
    private static final String SKIP_CONSTRUCTOR = "Skip creation of {} constructor for [{}] because {}.";
    private static final String BECAUSE_CONSTRUCTOR_ALREADY_EXISTS = "such constructor (coincidentally?) already exists";
    private static final String HIDE_CONSTRUCTOR = "Hide {} constructor of [{}].";
    private static final String SKIP_HIDING_OF_MISSING = "Skip hiding of {} constructor for [{}] because such constructor does not exist.";
    private static final String SKIP_HIDING_OF_SIMILAR = "Skip hiding of {} constructor for [{}] because it is similar to the {} constructor.";
    private static final String ABORT_HIDING_OF = "Abort hiding of {} constructor for [{}] because {}.";
    private static final String BECAUSE_NO_ALTERNATIVE_EXISTS = "there is no alternative to create an instance";
    private static final String ADD_INTERFACE = "Add [{}] interface extension for [{}].";
    private static final String SKIP_INTERFACE = "Skip [{}] interface extension for [{}] because interface is already implemented.";
    private static final String GENERATE_NESTED_BUILDER = "Generate nested builder class for [{}].";
    private static final String SKIP_NESTED_BUILDER = "Skip creation of nested builder class for [{}] because {}.";
    private static final String BECAUSE_NESTED_BUILDER_ALREADY_EXISTS = "such builder (coincidentally?) already exists";
    private static final String MODIFY_FACTORY = "Set {} of factory method [{}#{}(...)] onto [{}].";
    private static final String REMOVE_FACTORY = "Remove factory method [{}#{}(...)].";
    private static final String defoult = "default";
    private static final String required_values = "required-values";
    private static final String all_values = "all-values";
    private static final String copy = "copy";
    private static final String blueprint = "blueprint";
    private static final String clone = "clone";
    private static final String CLONE_SIGNATURE = String.format("#%s()", "clone");
    private static final String builder = "builder";
    private static final String BUILDER_METHOD_SIGNATURE = String.format("#%s()", "builder");
    private static final String toBuilder = "toBuilder";
    private static final String TOBUILDER_METHOD_SIGNATURE = String.format("#%s()", "toBuilder");
    private static final String build = "build";
    private static final String BUILD_SIGNATURE = String.format("#%s()", "build");
    private static final String OPTION_NAME = "informaticum-xjc-construction";
    private static final CommandLineArgument GENERATE_DEFAULT_CONSTRUCTOR = new CommandLineArgument("construction-default-constructor", ConstructionPluginMessages.DEFAULT_CONSTRUCTOR_DESCRIPTION.text(), new String[0]);
    private static final CommandLineArgument GENERATE_BASIC_CONSTRUCTOR = new CommandLineArgument("construction-basic-constructor", ConstructionPluginMessages.BASIC_CONSTRUCTOR_DESCRIPTION.format(GENERATE_DEFAULT_CONSTRUCTOR), new String[0]);
    private static final CommandLineArgument GENERATE_VALUES_CONSTRUCTOR = new CommandLineArgument("construction-values-constructor", ConstructionPluginMessages.VALUES_CONSTRUCTOR_DESCRIPTION.format(GENERATE_DEFAULT_CONSTRUCTOR), new String[0]);
    private static final CommandLineArgument GENERATE_COPY_CONSTRUCTOR = new CommandLineArgument("construction-copy-constructor", ConstructionPluginMessages.COPY_CONSTRUCTOR_DESCRIPTION.format(GENERATE_DEFAULT_CONSTRUCTOR), new String[0]);
    private static final CommandLineArgument PROTECTED_DEFAULT_CONSTRUCTOR = new CommandLineArgument("construction-hide-default-constructor", ConstructionPluginMessages.PROTECTED_DEFAULT_CONSTRUCTOR_DESCRIPTION.format(GENERATE_DEFAULT_CONSTRUCTOR), new String[0]);
    private static final CommandLineArgument GENERATE_CLONE = new CommandLineArgument("construction-clone", ConstructionPluginMessages.CLONE_DESCRIPTION.format(CLONE_SIGNATURE), new String[0]);
    private static final CommandLineArgument GENERATE_BUILDER = new CommandLineArgument("construction-builder", ConstructionPluginMessages.BUILDER_DESCRIPTION.format(GENERATE_VALUES_CONSTRUCTOR), new String[0]);
    private static final CommandLineArgument GENERATE_FACTORY_WITHER = new CommandLineArgument("construction-factory-withers", ConstructionPluginMessages.FACTORY_WITHER_DESCRIPTION.format(GENERATE_BUILDER), new String[0]);
    private static final CommandLineArgument GENERATE_ADDITIONAL_WITHER = new CommandLineArgument("construction-additional-withers", ConstructionPluginMessages.ADDITIONAL_WITHER_DESCRIPTION.format(GENERATE_BUILDER, GENERATE_FACTORY_WITHER), new String[0]);
    private static final CommandLineArgument HIDE_DEFAULT_FACTORIES = new CommandLineArgument("construction-hide-default-factories", ConstructionPluginMessages.HIDDEN_FACTORIES_DESCRIPTION.text(), new String[0]);
    private static final CommandLineArgument REMOVE_DEFAULT_FACTORIES = new CommandLineArgument("construction-remove-default-factories", ConstructionPluginMessages.REMOVE_FACTORIES_DESCRIPTION.format(HIDE_DEFAULT_FACTORIES), new String[0]);
    private static final boolean WITH_UNMODIFIABLE_COLLECTION = true;
    private static final boolean WITH_MODIFIABLE_COLLECTION = false;
    private static final Optional<JExpression> WITHOUT_DEFAULT_VALUE = Optional.empty();
    private static final Predicate<FieldOutline> DEFAULT_CONSTRUCTOR_PARAMETER_FILTER = any -> false;
    private static final Predicate<FieldOutline> MINIMUM_CONSTRUCTOR_PARAMETER_FILTER = OutlineAnalysis::isRequired;
    private static final Predicate<FieldOutline> VALUES_CONSTRUCTOR_PARAMETER_FILTER = any -> true;

    @Override
    public final Map.Entry<String, String> getOptionEntry() {
        return new AbstractMap.SimpleImmutableEntry<String, String>(OPTION_NAME, ConstructionPluginMessages.OPTION_DESCRIPTION.text());
    }

    @Override
    public final List<XjcOption> getPluginArguments() {
        final List<CommandLineArgument> args = Arrays.asList(GENERATE_DEFAULT_CONSTRUCTOR, PROTECTED_DEFAULT_CONSTRUCTOR, GENERATE_VALUES_CONSTRUCTOR, GENERATE_BASIC_CONSTRUCTOR, GENERATE_COPY_CONSTRUCTOR, GENERATE_CLONE, GENERATE_BUILDER, GENERATE_FACTORY_WITHER, GENERATE_ADDITIONAL_WITHER, HIDE_DEFAULT_FACTORIES, REMOVE_DEFAULT_FACTORIES);
        return new ArrayList<XjcOption>(super.getPluginArguments()){
            {
                super(arg0);
                this.addAll(args);
            }
        };
    }

    @Override
    public final boolean prepareRun() {
        boolean result = super.prepareRun();
        GENERATE_FACTORY_WITHER.activates(GENERATE_BUILDER);
        GENERATE_BUILDER.activates(GENERATE_VALUES_CONSTRUCTOR);
        GENERATE_VALUES_CONSTRUCTOR.activates(GENERATE_DEFAULT_CONSTRUCTOR);
        GENERATE_BASIC_CONSTRUCTOR.activates(GENERATE_DEFAULT_CONSTRUCTOR);
        GENERATE_COPY_CONSTRUCTOR.activates(GENERATE_DEFAULT_CONSTRUCTOR);
        PROTECTED_DEFAULT_CONSTRUCTOR.activates(GENERATE_DEFAULT_CONSTRUCTOR);
        REMOVE_DEFAULT_FACTORIES.deactivates(HIDE_DEFAULT_FACTORIES);
        GENERATE_CLONE.doOnActivation(() -> this.outline().getClasses().forEach(c -> this.addInterface((ClassOutline)c, Cloneable.class)));
        return result;
    }

    @Override
    protected final boolean runClass(ClassOutline clazz) {
        Optional<JMethod> $defCtor = GENERATE_DEFAULT_CONSTRUCTOR.doOnActivation(c -> this.generateConstructor((ClassOutline)c, defoult, (Predicate<? super FieldOutline>)DEFAULT_CONSTRUCTOR_PARAMETER_FILTER), clazz);
        Optional<JMethod> $reqCtor = GENERATE_BASIC_CONSTRUCTOR.doOnActivation(c -> this.generateConstructor((ClassOutline)c, required_values, (Predicate<? super FieldOutline>)MINIMUM_CONSTRUCTOR_PARAMETER_FILTER), clazz);
        Optional<JMethod> $valCtor = GENERATE_VALUES_CONSTRUCTOR.doOnActivation(c -> this.generateConstructor((ClassOutline)c, all_values, (Predicate<? super FieldOutline>)VALUES_CONSTRUCTOR_PARAMETER_FILTER), clazz);
        GENERATE_COPY_CONSTRUCTOR.doOnActivation(this::generateCopyConstructor, clazz);
        GENERATE_CLONE.doOnActivation(this::generateClone, clazz);
        Optional<JDefinedClass> $builder = GENERATE_BUILDER.doOnActivation(c -> $valCtor.map($vc -> this.generateBuilder((ClassOutline)c, (JMethod)$vc)).orElse(null), clazz);
        GENERATE_FACTORY_WITHER.doOnActivation(c -> $builder.ifPresent($b -> this.generateWithers((ClassOutline)c, (JDefinedClass)$b)), clazz);
        PROTECTED_DEFAULT_CONSTRUCTOR.doOnActivation(c -> $defCtor.ifPresent($dc -> this.hideDefaultConstructor((ClassOutline)c, (JMethod)$dc, (Optional<? extends JMethod>)$reqCtor, (Optional<? extends JMethod>)$valCtor, (Optional<? extends JDefinedClass>)$builder)), clazz);
        HIDE_DEFAULT_FACTORIES.doOnActivation(c -> this.hideDefaultFactory((ClassOutline)c, (Optional<? extends JDefinedClass>)$builder), clazz);
        REMOVE_DEFAULT_FACTORIES.doOnActivation(this::removeDefaultFactory, clazz);
        return true;
    }

    private final void addInterface(ClassOutline clazz, Class<?> interfaceClass) {
        JDefinedClass $ImplClass = clazz.getImplClass();
        JClass $InterfaceClass = this.reference(interfaceClass);
        Assertions.assertThat(interfaceClass).isInterface();
        if ($InterfaceClass.isAssignableFrom((JClass)$ImplClass)) {
            LOG.warn(SKIP_INTERFACE, interfaceClass, (Object)OutlineAnalysis.fullNameOf((CustomizableOutline)clazz));
        } else {
            LOG.info(ADD_INTERFACE, interfaceClass, (Object)OutlineAnalysis.fullNameOf((CustomizableOutline)clazz));
            CodeRetrofit.javadocSection((JDocCommentable)$ImplClass).append((Object)ConstructionPluginMessages.IMPLEMENTS_IMPLNOTE.format(CodeModelAnalysis.javadocNameOf((JType)$InterfaceClass)));
            $ImplClass._implements(interfaceClass);
        }
    }

    private final JMethod generateConstructor(ClassOutline clazz, String label, Predicate<? super FieldOutline> passedAsParameter) {
        LinkedHashMap<FieldOutline, JFieldVar> fieldsWithInitialisation;
        Optional<JMethod> $lookup = OutlineAnalysis.getConstructor(clazz, ConstructionPlugin.parameterTypesOf(OutlineAnalysis.filter(OutlineAnalysis.superAndGeneratedPropertiesOf(clazz), passedAsParameter).values()));
        if ($lookup.isPresent()) {
            LOG.info(SKIP_CONSTRUCTOR, new Object[]{label, OutlineAnalysis.fullNameOf((CustomizableOutline)clazz), BECAUSE_CONSTRUCTOR_ALREADY_EXISTS});
            return $lookup.get();
        }
        Assertions.assertThat($lookup).isNotPresent();
        LOG.info(GENERATE_CONSTRUCTOR, (Object)label, (Object)OutlineAnalysis.fullNameOf((CustomizableOutline)clazz));
        Optional<ClassOutline> superClass = Optional.ofNullable(clazz.getSuperClass());
        JDefinedClass $ImplClass = clazz.getImplClass();
        JMethod $constructor = $ImplClass.constructor(1);
        this.hijackGeneratedAnnotation((JAnnotatable)$ImplClass, (JAnnotatable)$constructor, ConstructionPlugin.class, ConstructionPluginMessages.CONSTRUCTOR_COMMENT.format(label));
        CodeRetrofit.javadocSection((JDocCommentable)$constructor).append((Object)ConstructionPluginMessages.CONSTRUCTOR_JAVADOC_BEGIN.text());
        superClass.ifPresent(sc -> $constructor.javadoc().append((Object)ConstructionPluginMessages.CONSTRUCTOR_JAVADOC_SUPER_CLASS.format(label)));
        $constructor.javadoc().append((Object)ConstructionPluginMessages.CONSTRUCTOR_JAVADOC_END.text());
        superClass.ifPresent(sc -> {
            LinkedHashMap<FieldOutline, JFieldVar> fieldsViaSuperConstructor = OutlineAnalysis.filter(OutlineAnalysis.superAndGeneratedPropertiesOf(sc), passedAsParameter);
            if (!fieldsViaSuperConstructor.isEmpty()) {
                $constructor.body().directStatement("// below fields are assigned via super constructor");
                JMethod $superConstructor = CodeModelAnalysis.getConstructor(sc.getImplClass(), ConstructionPlugin.parameterTypesOf(fieldsViaSuperConstructor.values())).get();
                JInvocation $superInvocation = $constructor.body().invoke("super");
                CodeRetrofit.relayThrows($superConstructor, $constructor, "###-Copy-Javadoc-Marker-###");
                for (JFieldVar $field : fieldsViaSuperConstructor.values()) {
                    JVar $parameter = $constructor.param(8, ConstructionPlugin.parameterTypeOf((JVar)$field), $field.name());
                    $superInvocation.arg((JExpression)$parameter);
                    CodeRetrofit.relayParamDoc($superConstructor, $constructor, $parameter);
                }
            }
        });
        Set<Map.Entry<FieldOutline, JFieldVar>> fieldsWithParameter = OutlineAnalysis.filter(OutlineAnalysis.generatedPropertiesOf(clazz), passedAsParameter).entrySet();
        if (!fieldsWithParameter.isEmpty()) {
            $constructor.body().directStatement("// below fields are assigned with their according parameter");
            for (Map.Entry<FieldOutline, JFieldVar> property : fieldsWithParameter) {
                JFieldVar $field = property.getValue();
                JVar $parameter = $constructor.param(8, ConstructionPlugin.parameterTypeOf((JVar)$field), $field.name());
                ConstructionPlugin.accordingAssignmentAndJavadoc(property, $constructor, (JExpression)$parameter);
            }
        }
        if (!(fieldsWithInitialisation = OutlineAnalysis.filter(OutlineAnalysis.generatedPropertiesOf(clazz), Predicate.not(passedAsParameter))).isEmpty()) {
            $constructor.body().directStatement("// below fields are assigned with their according initial value");
            ConstructionPlugin.accordingInitialisationAndJavadoc(fieldsWithInitialisation, $constructor);
        }
        return $constructor;
    }

    private final void generateCopyConstructor(ClassOutline clazz) {
        Optional<JMethod> $lookup = OutlineAnalysis.getConstructor(clazz, clazz);
        if ($lookup.isPresent()) {
            LOG.warn(SKIP_CONSTRUCTOR, new Object[]{copy, OutlineAnalysis.fullNameOf((CustomizableOutline)clazz), BECAUSE_CONSTRUCTOR_ALREADY_EXISTS});
            return;
        }
        Assertions.assertThat($lookup).isNotPresent();
        LOG.info(GENERATE_CONSTRUCTOR, (Object)copy, (Object)OutlineAnalysis.fullNameOf((CustomizableOutline)clazz));
        Optional<ClassOutline> superClass = Optional.ofNullable(clazz.getSuperClass());
        JDefinedClass $ImplClass = clazz.getImplClass();
        JMethod $constructor = $ImplClass.constructor(1);
        JVar $blueprint = $constructor.param(8, (JType)$ImplClass, blueprint);
        this.hijackGeneratedAnnotation((JAnnotatable)$ImplClass, (JAnnotatable)$constructor, ConstructionPlugin.class, ConstructionPluginMessages.CONSTRUCTOR_COMMENT.format(copy));
        CodeRetrofit.javadocSection((JDocCommentable)$constructor).append((Object)ConstructionPluginMessages.CONSTRUCTOR_JAVADOC_BEGIN.text());
        superClass.ifPresent(sc -> $constructor.javadoc().append((Object)ConstructionPluginMessages.CONSTRUCTOR_JAVADOC_SUPER_CLASS.format(copy)));
        $constructor.javadoc().append((Object)ConstructionPluginMessages.CONSTRUCTOR_JAVADOC_END.text());
        CodeRetrofit.javadocSection($constructor.javadoc().addParam($blueprint)).append((Object)ConstructionPluginMessages.CONSTRUCTOR_BLUEPRINT_ARGUMENT.text());
        CodeRetrofit.javadocSection($constructor.javadoc().addThrows(IllegalArgumentException.class)).append((Object)ConstructionPluginMessages.CONSTRUCTOR_ILLEGAL_BLUEPRINT.text());
        $constructor._throws(IllegalArgumentException.class);
        if (superClass.isPresent()) {
            $constructor.body().invoke("super").arg((JExpression)$blueprint);
        } else {
            $constructor.body()._if($blueprint.eq(CodeModelAnalysis.$null))._then()._throw((JExpression)JExpr._new((JClass)this.reference(IllegalArgumentException.class)).arg(JExpr.lit((String)"Required argument 'blueprint' must not be null!")));
        }
        Set<Map.Entry<FieldOutline, JFieldVar>> fields = OutlineAnalysis.generatedPropertiesOf(clazz).entrySet();
        if (!fields.isEmpty()) {
            $constructor.body().directStatement("// below fields are assigned with their according blueprint value");
            for (Map.Entry<FieldOutline, JFieldVar> property : fields) {
                JFieldVar $field = property.getValue();
                JExpression $nonNull = ConstructionPlugin.effectiveExpressionForNonNull($field.type(), (JExpression)$blueprint.ref((JVar)$field));
                ConstructionPlugin.accordingAssignment(property, $constructor, (JExpression)$blueprint.ref((JVar)$field), WITHOUT_DEFAULT_VALUE, $nonNull);
            }
        }
    }

    private final void hideDefaultConstructor(ClassOutline clazz, JMethod $defCtor, Optional<? extends JMethod> $reqCtor, Optional<? extends JMethod> $valCtor, Optional<? extends JDefinedClass> $Builder) {
        boolean anyOtherConstructorExists;
        boolean bl = anyOtherConstructorExists = !OutlineAnalysis.getConstructors(clazz, c -> c.params().size() > 0).isEmpty();
        if ($valCtor.isPresent() && $valCtor.get().params().isEmpty()) {
            LOG.info(SKIP_HIDING_OF_SIMILAR, new Object[]{defoult, OutlineAnalysis.fullNameOf((CustomizableOutline)clazz), all_values});
        } else if ($reqCtor.isPresent() && $reqCtor.get().params().isEmpty()) {
            LOG.info(SKIP_HIDING_OF_SIMILAR, new Object[]{defoult, OutlineAnalysis.fullNameOf((CustomizableOutline)clazz), required_values});
        } else if (!anyOtherConstructorExists && $Builder.isEmpty()) {
            LOG.info(ABORT_HIDING_OF, new Object[]{defoult, OutlineAnalysis.fullNameOf((CustomizableOutline)clazz), BECAUSE_NO_ALTERNATIVE_EXISTS});
        } else {
            LOG.info(HIDE_CONSTRUCTOR, (Object)defoult, (Object)OutlineAnalysis.fullNameOf((CustomizableOutline)clazz));
            this.appendGeneratedAnnotation((JAnnotatable)CodeModelAnalysis.enclosingClass($defCtor), (JAnnotatable)$defCtor, ConstructionPluginMessages.PROTECTED_CONSTRUCTOR_COMMENT.format(ConstructionPlugin.class.getName()));
            if (anyOtherConstructorExists && $Builder.isPresent()) {
                CodeRetrofit.javadocSection((JDocCommentable)$defCtor).append((Object)ConstructionPluginMessages.PROTECTED_CONSTRUCTOR_IMPLNOTE.text()).append((Object)ConstructionPluginMessages.ALTERNATIVE_INSTANTIATION.format(CodeModelAnalysis.javadocNameOf((JType)$Builder.get())));
            } else if (anyOtherConstructorExists) {
                CodeRetrofit.javadocSection((JDocCommentable)$defCtor).append((Object)ConstructionPluginMessages.PROTECTED_CONSTRUCTOR_IMPLNOTE.text()).append((Object)ConstructionPluginMessages.ALTERNATIVE_CONSTRUCTORS.text());
            } else if ($Builder.isPresent()) {
                CodeRetrofit.javadocSection((JDocCommentable)$defCtor).append((Object)ConstructionPluginMessages.PROTECTED_CONSTRUCTOR_IMPLNOTE.text()).append((Object)ConstructionPluginMessages.ALTERNATIVE_BUILDER.format(CodeModelAnalysis.javadocNameOf((JType)$Builder.get())));
            } else {
                CodeRetrofit.javadocSection((JDocCommentable)$defCtor).append((Object)ConstructionPluginMessages.PROTECTED_CONSTRUCTOR_IMPLNOTE.text());
            }
            $defCtor.mods().setProtected();
        }
    }

    private final void generateClone(ClassOutline clazz) {
        JBlock $body;
        Optional<JMethod> $lookup = OutlineAnalysis.getMethod(clazz, clone);
        if ($lookup.isPresent()) {
            LOG.warn("Skip creation of method [{}#{}] because {}.", new Object[]{OutlineAnalysis.fullNameOf((CustomizableOutline)clazz), CLONE_SIGNATURE, "such method already exists"});
            return;
        }
        Assertions.assertThat($lookup).isNotPresent();
        LOG.info("Generate method [{}#{}].", (Object)OutlineAnalysis.fullNameOf((CustomizableOutline)clazz), (Object)CLONE_SIGNATURE);
        JDefinedClass $ImplClass = clazz.getImplClass();
        Assertions.assertThat((boolean)this.reference(Cloneable.class).isAssignableFrom((JClass)$ImplClass)).isTrue();
        JMethod $clone = $ImplClass.method(1, (JType)$ImplClass, clone);
        $clone.annotate(Override.class);
        this.hijackGeneratedAnnotation((JAnnotatable)$ImplClass, (JAnnotatable)$clone, ConstructionPlugin.class, ConstructionPluginMessages.CLONE_COMMENT.text());
        CodeRetrofit.javadocSection((JDocCommentable)$clone).append((Object)ConstructionPluginMessages.CLONE_IMPLNOTE.text());
        if (clazz.getSuperClass() == null) {
            JTryBlock $try = $clone.body()._try();
            $body = $try.body();
            JCatchBlock $catch = $try._catch(this.reference(CloneNotSupportedException.class));
            JVar $bug = $catch.param("bug");
            $bug.mods().setFinal(true);
            $catch.body()._throw((JExpression)JExpr._new((JClass)this.reference(RuntimeException.class)).arg("Seriously?!? Super's #clone() failed, although this class implements the Cloneable interface.").arg((JExpression)$bug));
        } else {
            $body = $clone.body();
        }
        JVar $replica = $body.decl(8, (JType)$ImplClass, "replica", (JExpression)JExpr.cast((JType)$ImplClass, (JExpression)CodeModelAnalysis.$super.invoke(clone)));
        for (JFieldVar $field : OutlineAnalysis.generatedPropertiesOf(clazz).values()) {
            Optional<JExpression> $cloneExpression = CodeModelAnalysis.cloneExpressionFor($field.type(), (JExpression)CodeModelAnalysis.$this.ref((JVar)$field), UNMODIFIABLE_COLLECTIONS.isActivated());
            if ($cloneExpression.isEmpty()) {
                $body.assign((JAssignmentTarget)$replica.ref((JVar)$field), (JExpression)CodeModelAnalysis.$this.ref((JVar)$field));
                continue;
            }
            $body.assign((JAssignmentTarget)$replica.ref((JVar)$field), JOp.cond((JExpression)CodeModelAnalysis.$this.ref((JVar)$field).eq(CodeModelAnalysis.$null), (JExpression)CodeModelAnalysis.$null, (JExpression)$cloneExpression.get()));
        }
        $body._return((JExpression)$replica);
    }

    private final JDefinedClass generateBuilder(ClassOutline clazz, JMethod $valCtor) {
        JFieldVar $field;
        FieldOutline field;
        String builderClassName = OutlineAnalysis.guessBuilderName(clazz);
        Optional<JDefinedClass> $lookup = OutlineAnalysis.getEmbeddedClass(clazz, builderClassName);
        if ($lookup.isPresent()) {
            LOG.info(SKIP_NESTED_BUILDER, (Object)OutlineAnalysis.fullNameOf((CustomizableOutline)clazz), (Object)BECAUSE_NESTED_BUILDER_ALREADY_EXISTS);
            return $lookup.get();
        }
        Assertions.assertThat($lookup).isNotPresent();
        ClassOutline superClazz = clazz.getSuperClass();
        Optional superBuilder = Optional.ofNullable(superClazz).flatMap(s -> OutlineAnalysis.getEmbeddedClass(s, OutlineAnalysis.guessBuilderName(s)));
        JDefinedClass $ImplClass = clazz.getImplClass();
        int modifiers = $ImplClass.mods().getValue() & 0xFFFFFFEF;
        LOG.info(GENERATE_NESTED_BUILDER, (Object)OutlineAnalysis.fullNameOf((CustomizableOutline)clazz));
        JDefinedClass $Builder = this.outline().getClassFactory().createClass((JClassContainer)$ImplClass, modifiers, builderClassName, clazz.target.getLocator());
        this.hijackGeneratedAnnotation((JAnnotatable)$ImplClass, (JAnnotatable)$Builder, ConstructionPlugin.class, ConstructionPluginMessages.BUILDER_COMMENT.text());
        CodeRetrofit.javadocSection((JDocCommentable)$Builder).append((Object)ConstructionPluginMessages.BUILDER_JAVADOC.format(OutlineAnalysis.javadocNameOf((CustomizableOutline)clazz)));
        LOG.debug(GENERATE_CONSTRUCTOR, (Object)defoult, (Object)$Builder.fullName());
        JMethod $builderDefaultConstructor = $Builder.constructor(2);
        this.hijackGeneratedAnnotation((JAnnotatable)$ImplClass, (JAnnotatable)$builderDefaultConstructor, ConstructionPlugin.class, ConstructionPluginMessages.BUILDER_DEFAULT_CONSTRUCTOR_COMMENT.text());
        CodeRetrofit.javadocSection((JDocCommentable)$builderDefaultConstructor).append((Object)ConstructionPluginMessages.BUILDER_DEFAULT_CONSTRUCTOR.text());
        LOG.debug(GENERATE_CONSTRUCTOR, (Object)blueprint, (Object)$Builder.fullName());
        JMethod $builderBlueprintConstructor = $Builder.constructor(2);
        this.hijackGeneratedAnnotation((JAnnotatable)$ImplClass, (JAnnotatable)$builderBlueprintConstructor, ConstructionPlugin.class, ConstructionPluginMessages.BUILDER_BLUEPRINT_CONSTRUCTOR_COMMENT.text());
        CodeRetrofit.javadocSection((JDocCommentable)$builderBlueprintConstructor).append((Object)ConstructionPluginMessages.BUILDER_BLUEPRINT_CONSTRUCTOR.text());
        JVar $blueprintParam = $builderBlueprintConstructor.param(8, (JType)$ImplClass, blueprint);
        CodeRetrofit.javadocSection($builderBlueprintConstructor.javadoc().addParam($blueprintParam)).append((Object)ConstructionPluginMessages.BUILDER_BLUEPRINT_ARGUMENT.text());
        LOG.debug("Generate method [{}#{}].", (Object)$Builder.fullName(), (Object)BUILD_SIGNATURE);
        JMethod $build = $Builder.method(modifiers, (JType)$ImplClass, build);
        CodeRetrofit.javadocSection((JDocCommentable)$build).append((Object)ConstructionPluginMessages.BUILDER_BUILD_JAVADOC.format(OutlineAnalysis.javadocNameOf((CustomizableOutline)clazz)));
        CodeRetrofit.javadocSection($build.javadoc().addReturn()).append((Object)ConstructionPluginMessages.BUILDER_BUILD_RETURN.format(OutlineAnalysis.javadocNameOf((CustomizableOutline)clazz)));
        LOG.info("Generate method [{}#{}].", (Object)OutlineAnalysis.fullNameOf((CustomizableOutline)clazz), (Object)TOBUILDER_METHOD_SIGNATURE);
        JMethod $toBuilder = $ImplClass.method(modifiers, (JType)$Builder, toBuilder);
        CodeRetrofit.javadocSection((JDocCommentable)$toBuilder).append((Object)ConstructionPluginMessages.TOBUILDER_METHOD_JAVADOC.format(CodeModelAnalysis.javadocNameOf((JType)$Builder)));
        CodeRetrofit.javadocSection($toBuilder.javadoc().addReturn()).append((Object)ConstructionPluginMessages.TOBUILDER_METHOD_RETURN.format(CodeModelAnalysis.javadocNameOf((JType)$Builder)));
        if (superClazz != null) {
            $Builder._extends((JClass)superBuilder.get());
            $builderDefaultConstructor.body().invoke("super");
            $builderBlueprintConstructor.body().invoke("super").arg((JExpression)$blueprintParam);
            $build.annotate(Override.class);
            $toBuilder.annotate(Override.class);
        }
        this.hijackGeneratedAnnotation((JAnnotatable)$ImplClass, (JAnnotatable)$toBuilder, ConstructionPlugin.class, ConstructionPluginMessages.TOBUILDER_METHOD_COMMENT.text());
        this.hijackGeneratedAnnotation((JAnnotatable)$ImplClass, (JAnnotatable)$build, ConstructionPlugin.class, ConstructionPluginMessages.BUILDER_BUILD_COMMENT.text());
        if ($Builder.isAbstract()) {
            CodeRetrofit.javadocSection((JDocCommentable)$Builder).append((Object)ConstructionPluginMessages.BUILDER_ABSTRACT_IMPLNOTE.text());
            CodeRetrofit.javadocSection((JDocCommentable)$build).append((Object)ConstructionPluginMessages.BUILDER_BUILD_ABSTRACT_IMPLNOTE.text());
            CodeRetrofit.javadocSection((JDocCommentable)$toBuilder).append((Object)ConstructionPluginMessages.TOBUILDER_METHOD_ABSTRACT_IMPLNOTE.text());
        } else {
            CodeRetrofit.javadocSection((JDocCommentable)$Builder).append((Object)ConstructionPluginMessages.BUILDER_IMPLNOTE.text());
            CodeRetrofit.javadocSection((JDocCommentable)$build).append((Object)ConstructionPluginMessages.BUILDER_BUILD_IMPLNOTE.format(OutlineAnalysis.javadocNameOf((CustomizableOutline)clazz), CodeModelAnalysis.javadocNameOf($valCtor)));
            $build.body()._return((JExpression)OutlineAnalysis.superAndGeneratedPropertiesOf(clazz).values().stream().map($p -> CodeModelAnalysis.$this.ref((JVar)$p)).reduce(JExpr._new((JClass)$ImplClass), JInvocation::arg, JInvocation::arg));
            CodeRetrofit.relayThrows($valCtor, $build, ConstructionPluginMessages.BUILDER_BUILD_RELAY_THROWS.text());
            LOG.info("Generate method [{}#{}].", (Object)OutlineAnalysis.fullNameOf((CustomizableOutline)clazz), (Object)BUILDER_METHOD_SIGNATURE);
            JMethod $builder = $ImplClass.method(modifiers | 0x10, (JType)$Builder, builder);
            this.hijackGeneratedAnnotation((JAnnotatable)$ImplClass, (JAnnotatable)$builder, ConstructionPlugin.class, ConstructionPluginMessages.BUILDER_METHOD_COMMENT.text());
            CodeRetrofit.javadocSection((JDocCommentable)$builder).append((Object)ConstructionPluginMessages.BUILDER_METHOD_JAVADOC.format(CodeModelAnalysis.javadocNameOf((JType)$Builder)));
            CodeRetrofit.javadocSection((JDocCommentable)$builder).append((Object)ConstructionPluginMessages.BUILDER_METHOD_IMPLNOTE.format(CodeModelAnalysis.javadocNameOf((JType)$Builder), CodeModelAnalysis.javadocNameOf($builderDefaultConstructor)));
            CodeRetrofit.javadocSection($builder.javadoc().addReturn()).append((Object)ConstructionPluginMessages.BUILDER_METHOD_RETURN.format(CodeModelAnalysis.javadocNameOf((JType)$Builder)));
            $builder.body()._return((JExpression)JExpr._new((JClass)$Builder));
            CodeRetrofit.javadocSection((JDocCommentable)$toBuilder).append((Object)ConstructionPluginMessages.TOBUILDER_METHOD_IMPLNOTE.format(CodeModelAnalysis.javadocNameOf((JType)$Builder), CodeModelAnalysis.javadocNameOf($builderBlueprintConstructor)));
            $toBuilder.body()._return((JExpression)JExpr._new((JClass)$Builder).arg(CodeModelAnalysis.$this));
            if (!ConstructionPlugin.filterIllegalArgumentExceptionCandidates(OutlineAnalysis.superAndGeneratedPropertiesOf(clazz), false).isEmpty()) {
                $toBuilder._throws(IllegalArgumentException.class);
                CodeRetrofit.javadocSection($toBuilder.javadoc().addThrows(IllegalArgumentException.class)).append((Object)ConstructionPluginMessages.TOBUILDER_ILLEGAL_INSTANCE.format(CodeModelAnalysis.javadocNameOf((JType)$Builder)));
            }
        }
        if (superClazz == null) {
            $builderBlueprintConstructor.body()._if($blueprintParam.eq(CodeModelAnalysis.$null))._then()._throw((JExpression)JExpr._new((JClass)this.reference(IllegalArgumentException.class)).arg(JExpr.lit((String)"Required argument 'blueprint' must not be null!")));
        }
        $builderBlueprintConstructor._throws(IllegalArgumentException.class);
        CodeRetrofit.javadocSection($builderBlueprintConstructor.javadoc().addThrows(IllegalArgumentException.class)).append((Object)ConstructionPluginMessages.BUILDER_ILLEGAL_BLUEPRINT.text());
        for (Map.Entry<FieldOutline, JFieldVar> property : OutlineAnalysis.generatedPropertiesOf(clazz).entrySet()) {
            field = property.getKey();
            $field = property.getValue();
            $Builder.field(2, $field.type(), $field.name(), ConstructionPlugin.defaultExpressionFor(field).orElse(CodeModelAnalysis.$null));
            ConstructionPlugin.accordingAssignment(property, $builderBlueprintConstructor, (JExpression)$blueprintParam.ref((JVar)$field), WITHOUT_DEFAULT_VALUE, CodeModelAnalysis.cloneExpressionFor(property.getValue().type(), (JExpression)$blueprintParam.ref((JVar)$field), false).orElse((JExpression)$blueprintParam.ref((JVar)$field)));
            JMethod $wither = $Builder.method(modifiers & 0xFFFFFFDF, (JType)$Builder, OutlineAnalysis.guessWitherName(field));
            this.hijackGeneratedAnnotation((JAnnotatable)$ImplClass, (JAnnotatable)$wither, ConstructionPlugin.class, ConstructionPluginMessages.BUILDER_WITHER_COMMENT.text());
            CodeRetrofit.javadocSection((JDocCommentable)$wither).append((Object)ConstructionPluginMessages.BUILDER_WITHER_JAVADOC.format(CodeModelAnalysis.javadocNameOf((JType)field.parent().getImplClass()), CodeModelAnalysis.javadocNameOf((JVar)$field)));
            CodeRetrofit.javadocSection($wither.javadoc().addReturn()).append((Object)ConstructionPluginMessages.BUILDER_WITHER_RETURN.text());
            JVar $witherParam = $wither.param(8, ConstructionPlugin.parameterTypeOf((JVar)$field), $field.name());
            ConstructionPlugin.accordingAssignmentAndJavadoc(property, $wither, (JExpression)$witherParam, WITHOUT_DEFAULT_VALUE, CodeModelAnalysis.cloneExpressionFor(property.getValue().type(), (JExpression)$witherParam, false).orElse((JExpression)$witherParam));
            $wither.body()._return(CodeModelAnalysis.$this);
            if (!GENERATE_ADDITIONAL_WITHER.isActivated() || !field.getPropertyInfo().isCollection()) continue;
            JMethod $adder = $Builder.method(modifiers & 0xFFFFFFDF, (JType)$Builder, OutlineAnalysis.guessAdderName(field));
            this.hijackGeneratedAnnotation((JAnnotatable)$ImplClass, (JAnnotatable)$adder, ConstructionPlugin.class, ConstructionPluginMessages.BUILDER_ADDER_COMMENT.text());
            CodeRetrofit.javadocSection((JDocCommentable)$adder).append((Object)ConstructionPluginMessages.BUILDER_ADDER_JAVADOC.format(CodeModelAnalysis.javadocNameOf((JType)field.parent().getImplClass()), CodeModelAnalysis.javadocNameOf((JVar)$field)));
            CodeRetrofit.javadocSection($adder.javadoc().addReturn()).append((Object)ConstructionPluginMessages.BUILDER_ADDER_RETURN.text());
            JVar $adderParam = $adder.param(8, (JType)CodeModelAnalysis.typeParameterOf($field.type().boxify()), $field.name());
            CodeRetrofit.javadocSection($adder.javadoc().addParam($adderParam)).append((Object)ConstructionPluginMessages.BUILDER_ADDER_ARGUMENT.format(CodeModelAnalysis.javadocNameOf((JType)field.parent().getImplClass()), CodeModelAnalysis.javadocNameOf((JVar)$field)));
            $adder.body()._if(CodeModelAnalysis.$this.ref((JVar)$field).eq(CodeModelAnalysis.$null))._then().assign((JAssignmentTarget)CodeModelAnalysis.$this.ref((JVar)$field), (JExpression)CodeModelAnalysis.copyFactoryFor($field.type()));
            $adder.body().add((JStatement)CodeModelAnalysis.$this.ref((JVar)$field).invoke("add").arg((JExpression)$adderParam));
            $adder.body()._return(CodeModelAnalysis.$this);
            JMethod $remover = $Builder.method(modifiers & 0xFFFFFFDF, (JType)$Builder, OutlineAnalysis.guessRemoverName(field));
            this.hijackGeneratedAnnotation((JAnnotatable)$ImplClass, (JAnnotatable)$remover, ConstructionPlugin.class, ConstructionPluginMessages.BUILDER_REMOVER_COMMENT.text());
            CodeRetrofit.javadocSection((JDocCommentable)$remover).append((Object)ConstructionPluginMessages.BUILDER_REMOVER_JAVADOC.format(CodeModelAnalysis.javadocNameOf((JType)field.parent().getImplClass()), CodeModelAnalysis.javadocNameOf((JVar)$field)));
            CodeRetrofit.javadocSection($remover.javadoc().addReturn()).append((Object)ConstructionPluginMessages.BUILDER_REMOVER_RETURN.text());
            JVar $removerParam = $remover.param(8, (JType)CodeModelAnalysis.typeParameterOf($field.type().boxify()), $field.name());
            CodeRetrofit.javadocSection($remover.javadoc().addParam($removerParam)).append((Object)ConstructionPluginMessages.BUILDER_REMOVER_ARGUMENT.format(CodeModelAnalysis.javadocNameOf((JType)field.parent().getImplClass()), CodeModelAnalysis.javadocNameOf((JVar)$field)));
            $remover.body()._if(JOp.not((JExpression)CodeModelAnalysis.$this.ref((JVar)$field).eq(CodeModelAnalysis.$null)))._then().add((JStatement)CodeModelAnalysis.$this.ref((JVar)$field).invoke("remove").arg((JExpression)$removerParam));
            $remover.body()._return(CodeModelAnalysis.$this);
        }
        for (Map.Entry<FieldOutline, JFieldVar> property : OutlineAnalysis.superAndGeneratedPropertiesOf(superClazz).entrySet()) {
            field = property.getKey();
            $field = property.getValue();
            JDefinedClass $SuperBuilder = (JDefinedClass)superBuilder.get();
            JMethod $wither = $Builder.method(modifiers & 0xFFFFFFDF, (JType)$Builder, OutlineAnalysis.guessWitherName(field));
            $wither.annotate(Override.class);
            this.hijackGeneratedAnnotation((JAnnotatable)$ImplClass, (JAnnotatable)$wither, ConstructionPlugin.class, ConstructionPluginMessages.BUILDER_WITHER_COMMENT.text());
            JVar $witherParam = $wither.param(8, ConstructionPlugin.parameterTypeOf((JVar)$field), $field.name());
            $wither.body().invoke(CodeModelAnalysis.$super, $wither).arg((JExpression)$witherParam);
            $wither.body()._return(CodeModelAnalysis.$this);
            CodeRetrofit.relayThrows(CodeModelAnalysis.getMethod($SuperBuilder, OutlineAnalysis.guessWitherName(field), ConstructionPlugin.parameterTypeOf((JVar)$field)).get(), $wither);
            if (!GENERATE_ADDITIONAL_WITHER.isActivated() || !field.getPropertyInfo().isCollection()) continue;
            JMethod $adder = $Builder.method(modifiers & 0xFFFFFFDF, (JType)$Builder, OutlineAnalysis.guessAdderName(field));
            $adder.annotate(Override.class);
            this.hijackGeneratedAnnotation((JAnnotatable)$ImplClass, (JAnnotatable)$adder, ConstructionPlugin.class, ConstructionPluginMessages.BUILDER_ADDER_COMMENT.text());
            JVar $adderParam = $adder.param(8, (JType)CodeModelAnalysis.typeParameterOf($field.type().boxify()), $field.name());
            $adder.body().invoke(CodeModelAnalysis.$super, $adder).arg((JExpression)$adderParam);
            $adder.body()._return(CodeModelAnalysis.$this);
            JMethod $remover = $Builder.method(modifiers & 0xFFFFFFDF, (JType)$Builder, OutlineAnalysis.guessRemoverName(field));
            $remover.annotate(Override.class);
            this.hijackGeneratedAnnotation((JAnnotatable)$ImplClass, (JAnnotatable)$remover, ConstructionPlugin.class, ConstructionPluginMessages.BUILDER_REMOVER_COMMENT.text());
            JVar $removerParam = $remover.param(8, (JType)CodeModelAnalysis.typeParameterOf($field.type().boxify()), $field.name());
            $remover.body().invoke(CodeModelAnalysis.$super, $remover).arg((JExpression)$removerParam);
            $remover.body()._return(CodeModelAnalysis.$this);
        }
        return $Builder;
    }

    private final void generateWithers(ClassOutline clazz, JDefinedClass $Builder) {
        JDefinedClass $ImplClass = clazz.getImplClass();
        int modifiers = $ImplClass.mods().getValue() & 0xFFFFFFEF;
        JMethod $implClassToBuilder = CodeModelAnalysis.getMethod($ImplClass, toBuilder).get();
        LinkedHashMap<FieldOutline, JFieldVar> inheritedProperties = OutlineAnalysis.superAndGeneratedPropertiesOf(clazz.getSuperClass());
        for (Map.Entry<FieldOutline, JFieldVar> property : OutlineAnalysis.superAndGeneratedPropertiesOf(clazz).entrySet()) {
            String code;
            FieldOutline field = property.getKey();
            JFieldVar $field = property.getValue();
            JMethod $builderBuild = CodeModelAnalysis.getMethod($Builder, build).get();
            JMethod $builderWither = CodeModelAnalysis.getMethod($Builder, OutlineAnalysis.guessWitherName(field), ConstructionPlugin.parameterTypeOf((JVar)$field)).get();
            JVar $builderWitherParam = (JVar)$builderWither.params().get(0);
            JMethod $wither = $ImplClass.method(modifiers, (JType)$ImplClass, OutlineAnalysis.guessWitherName(field));
            JVar $witherParam = $wither.param(8, $builderWitherParam.type(), $builderWitherParam.name());
            if (inheritedProperties.containsKey(field)) {
                $wither.annotate(Override.class);
            } else {
                CodeRetrofit.javadocSection((JDocCommentable)$wither).append((Object)ConstructionPluginMessages.WITHER_JAVADOC.format(CodeModelAnalysis.javadocNameOf((JType)field.parent().getImplClass()), CodeModelAnalysis.javadocNameOf((JVar)$field)));
                CodeRetrofit.javadocSection($wither.javadoc().addReturn()).append((Object)ConstructionPluginMessages.WITHER_RETURN.text());
                CodeRetrofit.relayParamDoc($builderWither, $wither, $builderWitherParam);
            }
            this.hijackGeneratedAnnotation((JAnnotatable)$ImplClass, (JAnnotatable)$wither, ConstructionPlugin.class, ConstructionPluginMessages.WITHER_COMMENT.text());
            if ($wither.mods().isAbstract()) {
                CodeRetrofit.javadocSection((JDocCommentable)$wither).append((Object)ConstructionPluginMessages.WITHER_ABSTRACT_IMPLNOTE.text());
            } else {
                code = String.format("this.%s().%s(%s).%s()", $implClassToBuilder.name(), $builderWither.name(), $witherParam.name(), $builderBuild.name());
                CodeRetrofit.javadocSection((JDocCommentable)$wither).append((Object)ConstructionPluginMessages.WITHER_IMPLNOTE.format(CodeModelAnalysis.javadocNameOf((JType)$Builder), code));
                $wither.body()._return((JExpression)CodeModelAnalysis.$this.invoke($implClassToBuilder).invoke($builderWither).arg((JExpression)$witherParam).invoke($builderBuild));
                if (inheritedProperties.containsKey(field)) {
                    CodeRetrofit.relayThrows($builderWither, $wither);
                } else {
                    CodeRetrofit.relayThrows($builderWither, $wither, "###-Copy-Javadoc-Marker-###");
                }
            }
            if (!GENERATE_ADDITIONAL_WITHER.isActivated() || !field.getPropertyInfo().isCollection()) continue;
            JMethod $builderAdder = CodeModelAnalysis.getMethod($Builder, OutlineAnalysis.guessAdderName(field), new JType[]{CodeModelAnalysis.typeParameterOf($field.type().boxify())}).get();
            JVar $builderAdderParam = (JVar)$builderAdder.params().get(0);
            JMethod $adder = $ImplClass.method(modifiers, (JType)$ImplClass, OutlineAnalysis.guessWithAdditionalName(field));
            JVar $adderParam = $adder.param(8, $builderAdderParam.type(), $builderAdderParam.name());
            if (inheritedProperties.containsKey(field)) {
                $adder.annotate(Override.class);
            } else {
                CodeRetrofit.javadocSection((JDocCommentable)$adder).append((Object)ConstructionPluginMessages.ADDER_JAVADOC.format(CodeModelAnalysis.javadocNameOf((JType)field.parent().getImplClass()), CodeModelAnalysis.javadocNameOf((JVar)$field)));
                CodeRetrofit.javadocSection($adder.javadoc().addParam($adderParam)).append((Object)ConstructionPluginMessages.ADDER_ARGUMENT.format(CodeModelAnalysis.javadocNameOf((JType)field.parent().getImplClass()), CodeModelAnalysis.javadocNameOf((JVar)$field)));
                CodeRetrofit.javadocSection($adder.javadoc().addReturn()).append((Object)ConstructionPluginMessages.ADDER_RETURN.text());
            }
            this.hijackGeneratedAnnotation((JAnnotatable)$ImplClass, (JAnnotatable)$adder, ConstructionPlugin.class, ConstructionPluginMessages.ADDER_COMMENT.text());
            if ($adder.mods().isAbstract()) {
                CodeRetrofit.javadocSection((JDocCommentable)$adder).append((Object)ConstructionPluginMessages.ADDER_ABSTRACT_IMPLNOTE.text());
            } else {
                code = String.format("this.%s().%s(%s).%s()", $implClassToBuilder.name(), $builderAdder.name(), $adderParam.name(), $builderBuild.name());
                CodeRetrofit.javadocSection((JDocCommentable)$adder).append((Object)ConstructionPluginMessages.ADDER_IMPLNOTE.format(CodeModelAnalysis.javadocNameOf((JType)$Builder), code));
                $adder.body()._return((JExpression)CodeModelAnalysis.$this.invoke($implClassToBuilder).invoke($builderAdder).arg((JExpression)$adderParam).invoke($builderBuild));
            }
            JMethod $builderRemover = CodeModelAnalysis.getMethod($Builder, OutlineAnalysis.guessRemoverName(field), new JType[]{CodeModelAnalysis.typeParameterOf($field.type().boxify())}).get();
            JVar $builderRemoverParam = (JVar)$builderRemover.params().get(0);
            JMethod $remover = $ImplClass.method(modifiers, (JType)$ImplClass, OutlineAnalysis.guessWithoutSpecificName(field));
            JVar $removerParam = $remover.param(8, $builderRemoverParam.type(), $builderRemoverParam.name());
            if (inheritedProperties.containsKey(field)) {
                $remover.annotate(Override.class);
            } else {
                CodeRetrofit.javadocSection((JDocCommentable)$remover).append((Object)ConstructionPluginMessages.REMOVER_JAVADOC.format(CodeModelAnalysis.javadocNameOf((JType)field.parent().getImplClass()), CodeModelAnalysis.javadocNameOf((JVar)$field)));
                CodeRetrofit.javadocSection($remover.javadoc().addParam($removerParam)).append((Object)ConstructionPluginMessages.REMOVER_ARGUMENT.format(CodeModelAnalysis.javadocNameOf((JType)field.parent().getImplClass()), CodeModelAnalysis.javadocNameOf((JVar)$field)));
                CodeRetrofit.javadocSection($remover.javadoc().addReturn()).append((Object)ConstructionPluginMessages.REMOVER_RETURN.text());
            }
            this.hijackGeneratedAnnotation((JAnnotatable)$ImplClass, (JAnnotatable)$remover, ConstructionPlugin.class, ConstructionPluginMessages.REMOVER_COMMENT.text());
            if ($remover.mods().isAbstract()) {
                CodeRetrofit.javadocSection((JDocCommentable)$remover).append((Object)ConstructionPluginMessages.REMOVER_ABSTRACT_IMPLNOTE.text());
                continue;
            }
            code = String.format("this.%s().%s(%s).%s()", $implClassToBuilder.name(), $builderRemover.name(), $removerParam.name(), $builderBuild.name());
            CodeRetrofit.javadocSection((JDocCommentable)$remover).append((Object)ConstructionPluginMessages.REMOVER_IMPLNOTE.format(CodeModelAnalysis.javadocNameOf((JType)$Builder), code));
            $remover.body()._return((JExpression)CodeModelAnalysis.$this.invoke($implClassToBuilder).invoke($builderRemover).arg((JExpression)$removerParam).invoke($builderBuild));
        }
    }

    private final void hideDefaultFactory(ClassOutline clazz, Optional<? extends JDefinedClass> $Builder) {
        JDefinedClass $ObjectFactory = clazz._package().objectFactory();
        Optional<JMethod> $factoryLookup = CodeModelAnalysis.getMethod($ObjectFactory, OutlineAnalysis.guessFactoryName(clazz));
        $factoryLookup.ifPresent($factory -> {
            boolean anyOtherConstructorExists = !OutlineAnalysis.getConstructors(clazz, c -> c.params().size() > 0).isEmpty();
            LOG.info(MODIFY_FACTORY, new Object[]{"accessibility", $ObjectFactory.fullName(), $factory.name(), "private"});
            $factory.mods().setPrivate();
            $factory.annotate(SuppressWarnings.class).param("value", "unused");
            CodeRetrofit.javadocSection((JDocCommentable)$factory).append((Object)ConstructionPluginMessages.PRIVATE_FACTORY_IMPLNOTE.text());
            if (anyOtherConstructorExists && $Builder.isPresent()) {
                CodeRetrofit.javadocSection((JDocCommentable)$factory).append((Object)ConstructionPluginMessages.ALTERNATIVE_INSTANTIATION.format(CodeModelAnalysis.javadocNameOf((JType)$Builder.get())));
            } else if (anyOtherConstructorExists) {
                CodeRetrofit.javadocSection((JDocCommentable)$factory).append((Object)ConstructionPluginMessages.ALTERNATIVE_CONSTRUCTORS.text());
            } else if ($Builder.isPresent()) {
                CodeRetrofit.javadocSection((JDocCommentable)$factory).append((Object)ConstructionPluginMessages.ALTERNATIVE_BUILDER.format(CodeModelAnalysis.javadocNameOf((JType)$Builder.get())));
            }
        });
    }

    private final void removeDefaultFactory(ClassOutline clazz) {
        JDefinedClass $ObjectFactory = clazz._package().objectFactory();
        Optional<JMethod> $factoryLookup = CodeModelAnalysis.getMethod($ObjectFactory, OutlineAnalysis.guessFactoryName(clazz));
        $factoryLookup.ifPresent($factory -> {
            LOG.info(REMOVE_FACTORY, (Object)$ObjectFactory.fullName(), (Object)$factory.name());
            $ObjectFactory.methods().remove($factory);
            Assertions.assertThat(CodeModelAnalysis.getMethod($ObjectFactory, OutlineAnalysis.guessFactoryName(clazz))).isNull();
        });
    }
}

